/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.InMemoryExchangeSinkOperator;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.operator.Page;
import com.facebook.presto.tuple.TupleInfo;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import io.airlift.units.DataSize;
import java.util.Collection;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class InMemoryExchange {
    private final List<TupleInfo> tupleInfos;
    private final Queue<Page> buffer;
    private final long maxBufferedBytes;
    @GuardedBy(value="this")
    private boolean finishing;
    @GuardedBy(value="this")
    private boolean noMoreSinkFactories;
    @GuardedBy(value="this")
    private int sinkFactories;
    @GuardedBy(value="this")
    private int sinks;
    @GuardedBy(value="this")
    private long bufferBytes;
    @GuardedBy(value="this")
    private SettableFuture<?> readerFuture;
    @GuardedBy(value="this")
    private SettableFuture<?> writerFuture;

    public InMemoryExchange(List<TupleInfo> tupleInfos) {
        this(tupleInfos, new DataSize(32.0, DataSize.Unit.MEGABYTE));
    }

    public InMemoryExchange(List<TupleInfo> tupleInfos, DataSize maxBufferedBytes) {
        this.tupleInfos = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(tupleInfos, (Object)"tupleInfos is null")));
        this.buffer = new ConcurrentLinkedQueue<Page>();
        Preconditions.checkArgument((maxBufferedBytes.toBytes() > 0L ? 1 : 0) != 0, (Object)"maxBufferedBytes must be greater than zero");
        this.maxBufferedBytes = maxBufferedBytes.toBytes();
    }

    public List<TupleInfo> getTupleInfos() {
        return this.tupleInfos;
    }

    public synchronized OperatorFactory createSinkFactory(int operatorId) {
        ++this.sinkFactories;
        return new InMemoryExchangeSinkOperatorFactory(operatorId);
    }

    private synchronized void addSink() {
        Preconditions.checkState((this.sinkFactories > 0 ? 1 : 0) != 0, (Object)"All sink factories already closed");
        ++this.sinks;
    }

    public synchronized void sinkFinished() {
        Preconditions.checkState((this.sinks != 0 ? 1 : 0) != 0, (Object)"All sinks are already complete");
        --this.sinks;
        this.updateState();
    }

    public synchronized void noMoreSinkFactories() {
        this.noMoreSinkFactories = true;
        this.updateState();
    }

    private synchronized void sinkFactoryClosed() {
        Preconditions.checkState((this.sinkFactories != 0 ? 1 : 0) != 0, (Object)"All sinks factories are already closed");
        --this.sinkFactories;
        this.updateState();
    }

    private void updateState() {
        if (this.noMoreSinkFactories && this.sinkFactories == 0 && this.sinks == 0) {
            this.finish();
        }
    }

    public synchronized boolean isFinishing() {
        return this.finishing;
    }

    public synchronized void finish() {
        this.finishing = true;
        this.notifyBlockedReaders();
        this.notifyBlockedWriters();
    }

    public synchronized boolean isFinished() {
        return this.finishing && this.buffer.isEmpty();
    }

    public synchronized void addPage(Page page) {
        if (this.finishing) {
            return;
        }
        this.buffer.add(page);
        this.bufferBytes += page.getDataSize().toBytes();
        this.notifyBlockedReaders();
    }

    private synchronized void notifyBlockedReaders() {
        if (this.readerFuture != null) {
            this.readerFuture.set(null);
            this.readerFuture = null;
        }
    }

    public synchronized ListenableFuture<?> waitForReading() {
        if (this.finishing || !this.buffer.isEmpty()) {
            return Operator.NOT_BLOCKED;
        }
        if (this.readerFuture == null) {
            this.readerFuture = SettableFuture.create();
        }
        return this.readerFuture;
    }

    public synchronized Page removePage() {
        Page page = this.buffer.poll();
        if (page != null) {
            this.bufferBytes -= page.getDataSize().toBytes();
        }
        if (this.bufferBytes < this.maxBufferedBytes) {
            this.notifyBlockedWriters();
        }
        return page;
    }

    private synchronized void notifyBlockedWriters() {
        if (this.writerFuture != null) {
            this.writerFuture.set(null);
            this.writerFuture = null;
        }
    }

    public synchronized ListenableFuture<?> waitForWriting() {
        if (this.bufferBytes < this.maxBufferedBytes) {
            return Operator.NOT_BLOCKED;
        }
        if (this.writerFuture == null) {
            this.writerFuture = SettableFuture.create();
        }
        return this.writerFuture;
    }

    private class InMemoryExchangeSinkOperatorFactory
    implements OperatorFactory {
        private final int operatorId;
        private boolean closed;

        private InMemoryExchangeSinkOperatorFactory(int operatorId) {
            this.operatorId = operatorId;
        }

        @Override
        public List<TupleInfo> getTupleInfos() {
            return InMemoryExchange.this.tupleInfos;
        }

        @Override
        public Operator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, InMemoryExchangeSinkOperator.class.getSimpleName());
            InMemoryExchange.this.addSink();
            return new InMemoryExchangeSinkOperator(operatorContext, InMemoryExchange.this);
        }

        @Override
        public void close() {
            if (!this.closed) {
                this.closed = true;
                InMemoryExchange.this.sinkFactoryClosed();
            }
        }
    }
}

