/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.block.BlockCursor;
import com.facebook.presto.operator.ChannelIndex;
import com.facebook.presto.operator.HashStrategyUtils;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.PageBuilder;
import com.facebook.presto.operator.PagesIndex;
import com.facebook.presto.tuple.TupleInfo;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import io.airlift.slice.SizeOf;
import io.airlift.units.DataSize;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.longs.Long2IntOpenCustomHashMap;
import it.unimi.dsi.fastutil.longs.LongHash;
import java.util.Arrays;
import java.util.List;

public class JoinHash {
    private static final long CURRENT_ROW_ADDRESS = -1L;
    private final PagesIndex pagesIndex;
    private final PagesHashStrategy hashStrategy;
    private final AddressToPositionMap addressToPositionMap;
    private final IntArrayList positionLinks;

    public JoinHash(PagesIndex pagesIndex, List<Integer> hashChannels, OperatorContext operatorContext) {
        this.pagesIndex = pagesIndex;
        this.hashStrategy = new PagesHashStrategy(pagesIndex, hashChannels);
        this.addressToPositionMap = new AddressToPositionMap(pagesIndex.getPositionCount(), (LongHash.Strategy)this.hashStrategy);
        this.positionLinks = new IntArrayList(new int[pagesIndex.getPositionCount()]);
        Arrays.fill(this.positionLinks.elements(), -1);
        for (int position = 0; position < pagesIndex.getPositionCount(); ++position) {
            operatorContext.setMemoryReservation(this.getEstimatedSize());
            int oldPosition = this.addressToPositionMap.put(position, position);
            if (oldPosition < 0) continue;
            this.positionLinks.set(position, oldPosition);
        }
    }

    public JoinHash(JoinHash joinHash) {
        this.positionLinks = joinHash.positionLinks;
        this.pagesIndex = joinHash.pagesIndex;
        this.hashStrategy = new PagesHashStrategy(joinHash.hashStrategy);
        this.addressToPositionMap = new AddressToPositionMap(joinHash.addressToPositionMap, (LongHash.Strategy)this.hashStrategy);
    }

    public long getEstimatedSize() {
        return this.pagesIndex.getEstimatedSize().toBytes() + this.addressToPositionMap.getEstimatedSize().toBytes() + SizeOf.sizeOf((int[])this.positionLinks.elements());
    }

    public int getChannelCount() {
        return this.pagesIndex.getTupleInfos().size();
    }

    public void setProbeCursors(BlockCursor[] cursors, int[] probeJoinChannels) {
        this.hashStrategy.setProbeCursors(cursors, probeJoinChannels);
    }

    public int getJoinPosition() {
        int position = this.addressToPositionMap.get(-1L);
        return position;
    }

    public int getNextJoinPosition(int currentPosition) {
        return this.positionLinks.getInt(currentPosition);
    }

    public void appendTupleTo(int position, PageBuilder pageBuilder, int outputChannelOffset) {
        for (int channel = 0; channel < this.getChannelCount(); ++channel) {
            this.pagesIndex.appendTupleTo(channel, position, pageBuilder.getBlockBuilder(outputChannelOffset + channel));
        }
    }

    private static class AddressToPositionMap
    extends Long2IntOpenCustomHashMap {
        private AddressToPositionMap(int expected, LongHash.Strategy strategy) {
            super(expected, strategy);
            this.defaultReturnValue(-1);
        }

        private AddressToPositionMap(AddressToPositionMap map, LongHash.Strategy strategy) {
            super(0, 0.75f, strategy);
            this.key = map.key;
            this.value = map.value;
            this.used = map.used;
            this.n = map.n;
            this.maxFill = map.maxFill;
            this.mask = map.mask;
            this.size = map.size;
            this.defaultReturnValue(-1);
        }

        public DataSize getEstimatedSize() {
            return new DataSize((double)(SizeOf.sizeOf((long[])this.key) + SizeOf.sizeOf((int[])this.value) + SizeOf.sizeOf((boolean[])this.used)), DataSize.Unit.BYTE);
        }
    }

    private static class PagesHashStrategy
    implements LongHash.Strategy {
        private final List<TupleInfo.Type> types;
        private final List<ChannelIndex> channels;
        private final BlockCursor[] joinCursors;

        private PagesHashStrategy(PagesIndex pagesIndex, List<Integer> hashChannels) {
            ImmutableList.Builder types = ImmutableList.builder();
            ImmutableList.Builder channels = ImmutableList.builder();
            for (int channel : hashChannels) {
                types.add((Object)pagesIndex.getTupleInfo(channel).getType());
                channels.add((Object)pagesIndex.getIndex(channel));
            }
            this.types = types.build();
            this.channels = channels.build();
            this.joinCursors = new BlockCursor[hashChannels.size()];
        }

        private PagesHashStrategy(PagesHashStrategy pagesHashStrategy) {
            this.types = pagesHashStrategy.types;
            this.channels = pagesHashStrategy.channels;
            this.joinCursors = new BlockCursor[this.types.size()];
        }

        public void setProbeCursors(BlockCursor[] cursors, int[] probeJoinChannels) {
            for (int i = 0; i < probeJoinChannels.length; ++i) {
                int probeJoinChannel = probeJoinChannels[i];
                this.joinCursors[i] = cursors[probeJoinChannel];
            }
        }

        public int hashCode(long address) {
            if (address == -1L) {
                return this.hashCurrentRow();
            }
            return this.hashPosition(address);
        }

        private int hashPosition(long address) {
            int position = Ints.checkedCast((long)address);
            int result = 0;
            for (ChannelIndex hashChannel : this.channels) {
                result = HashStrategyUtils.addToHashCode(result, hashChannel.hashCode(position));
            }
            return result;
        }

        private int hashCurrentRow() {
            int result = 0;
            for (int channel = 0; channel < this.types.size(); ++channel) {
                TupleInfo.Type type = this.types.get(channel);
                BlockCursor cursor = this.joinCursors[channel];
                result = HashStrategyUtils.addToHashCode(result, HashStrategyUtils.valueHashCode(type, cursor.getRawSlice(), cursor.getRawOffset()));
            }
            return result;
        }

        public boolean equals(long leftAddress, long rightAddress) {
            if (leftAddress == -1L && rightAddress == -1L) {
                return true;
            }
            if (leftAddress == -1L) {
                return this.positionEqualsCurrentRow(Ints.saturatedCast((long)rightAddress));
            }
            if (rightAddress == -1L) {
                return this.positionEqualsCurrentRow(Ints.saturatedCast((long)leftAddress));
            }
            return this.positionEqualsPosition(Ints.saturatedCast((long)leftAddress), Ints.saturatedCast((long)rightAddress));
        }

        public boolean positionEqualsPosition(int thisPosition, int thatPosition) {
            if (thisPosition == thatPosition) {
                return true;
            }
            for (ChannelIndex hashChannel : this.channels) {
                if (hashChannel.equals(thisPosition, thatPosition)) continue;
                return false;
            }
            return true;
        }

        private boolean positionEqualsCurrentRow(int position) {
            for (int i = 0; i < this.channels.size(); ++i) {
                ChannelIndex channelIndex = this.channels.get(i);
                if (channelIndex.equals(position, this.joinCursors[i])) continue;
                return false;
            }
            return true;
        }
    }
}

