/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.block.Block;
import com.facebook.presto.block.BlockBuilder;
import com.facebook.presto.block.BlockCursor;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.operator.Page;
import com.facebook.presto.tuple.TupleInfo;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;

public class LimitOperator
implements Operator {
    private final OperatorContext operatorContext;
    private final List<TupleInfo> tupleInfos;
    private final Optional<Integer> sampleWeightChannel;
    private Page nextPage;
    private long remainingLimit;

    public LimitOperator(OperatorContext operatorContext, List<TupleInfo> tupleInfos, long limit, Optional<Integer> sampleWeightChannel) {
        this.operatorContext = (OperatorContext)Preconditions.checkNotNull((Object)operatorContext, (Object)"operatorContext is null");
        this.tupleInfos = (List)Preconditions.checkNotNull(tupleInfos, (Object)"tupleInfos is null");
        Preconditions.checkArgument((limit >= 0L ? 1 : 0) != 0, (Object)"limit must be at least zero");
        this.remainingLimit = limit;
        this.sampleWeightChannel = (Optional)Preconditions.checkNotNull(sampleWeightChannel, (Object)"sampleWeightChannel is null");
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public List<TupleInfo> getTupleInfos() {
        return this.tupleInfos;
    }

    @Override
    public void finish() {
        this.remainingLimit = 0L;
    }

    @Override
    public boolean isFinished() {
        return this.remainingLimit == 0L && this.nextPage == null;
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        return NOT_BLOCKED;
    }

    @Override
    public boolean needsInput() {
        return this.remainingLimit > 0L && this.nextPage == null;
    }

    @Override
    public void addInput(Page page) {
        Preconditions.checkState((boolean)this.needsInput());
        if (this.sampleWeightChannel.isPresent()) {
            this.addInputWithSampling(page, (Integer)this.sampleWeightChannel.get());
        } else {
            this.addInputWithoutSampling(page);
        }
    }

    private void addInputWithoutSampling(Page page) {
        if ((long)page.getPositionCount() <= this.remainingLimit) {
            this.remainingLimit -= (long)page.getPositionCount();
            this.nextPage = page;
        } else {
            Block[] blocks = new Block[page.getChannelCount()];
            for (int channel = 0; channel < page.getChannelCount(); ++channel) {
                Block block = page.getBlock(channel);
                blocks[channel] = block.getRegion(0, (int)this.remainingLimit);
            }
            this.nextPage = new Page((int)this.remainingLimit, blocks);
            this.remainingLimit = 0L;
        }
    }

    private void addInputWithSampling(Page page, int sampleWeightChannel) {
        BlockCursor cursor = page.getBlock(sampleWeightChannel).cursor();
        BlockBuilder builder = new BlockBuilder(TupleInfo.SINGLE_LONG);
        int rowsToCopy = 0;
        while (this.remainingLimit > 0L && cursor.advanceNextPosition()) {
            ++rowsToCopy;
            long sampleWeight = cursor.getLong();
            if (sampleWeight <= this.remainingLimit) {
                builder.append(sampleWeight);
            } else {
                builder.append(this.remainingLimit);
            }
            this.remainingLimit -= sampleWeight;
        }
        if (this.remainingLimit >= 0L && rowsToCopy == page.getPositionCount()) {
            this.nextPage = page;
        } else {
            Block[] blocks = new Block[page.getChannelCount()];
            blocks[sampleWeightChannel] = builder.build();
            for (int channel = 0; channel < page.getChannelCount(); ++channel) {
                if (channel == sampleWeightChannel) continue;
                Block block = page.getBlock(channel);
                blocks[channel] = block.getRegion(0, rowsToCopy);
            }
            this.nextPage = new Page(rowsToCopy, blocks);
            this.remainingLimit = 0L;
        }
    }

    @Override
    public Page getOutput() {
        Page page = this.nextPage;
        this.nextPage = null;
        return page;
    }

    public static class LimitOperatorFactory
    implements OperatorFactory {
        private final int operatorId;
        private final List<TupleInfo> tupleInfos;
        private final long limit;
        private final Optional<Integer> sampleWeightChannel;
        private boolean closed;

        public LimitOperatorFactory(int operatorId, List<TupleInfo> tupleInfos, long limit, Optional<Integer> sampleWeightChannel) {
            this.operatorId = operatorId;
            this.tupleInfos = tupleInfos;
            this.limit = limit;
            this.sampleWeightChannel = sampleWeightChannel;
        }

        @Override
        public List<TupleInfo> getTupleInfos() {
            return this.tupleInfos;
        }

        @Override
        public Operator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, LimitOperator.class.getSimpleName());
            return new LimitOperator(operatorContext, this.tupleInfos, this.limit, this.sampleWeightChannel);
        }

        @Override
        public void close() {
            this.closed = true;
        }
    }
}

