/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.block.Block;
import com.facebook.presto.block.BlockBuilder;
import com.facebook.presto.operator.GroupByHash;
import com.facebook.presto.operator.GroupByIdBlock;
import com.facebook.presto.operator.Page;
import com.facebook.presto.tuple.TupleInfo;
import io.airlift.slice.Slices;
import java.util.List;

public class MarkDistinctHash {
    private final GroupByHash groupByHash;
    private long nextDistinctId;

    public MarkDistinctHash(List<TupleInfo.Type> types, int[] channels) {
        this(types, channels, 10000);
    }

    public MarkDistinctHash(List<TupleInfo.Type> types, int[] channels, int expectedDistinctValues) {
        this.groupByHash = new GroupByHash(types, channels, expectedDistinctValues);
    }

    public long getEstimatedSize() {
        return this.groupByHash.getEstimatedSize();
    }

    public Block markDistinctRows(Page page) {
        int positionCount = page.getPositionCount();
        int blockSize = TupleInfo.SINGLE_BOOLEAN.getFixedSize() * positionCount;
        BlockBuilder blockBuilder = new BlockBuilder(TupleInfo.SINGLE_BOOLEAN, blockSize, Slices.allocate((int)blockSize).getOutput());
        GroupByIdBlock ids = this.groupByHash.getGroupIds(page);
        for (int i = 0; i < ids.getPositionCount(); ++i) {
            if (ids.getGroupId(i) == this.nextDistinctId) {
                blockBuilder.append(true);
                ++this.nextDistinctId;
                continue;
            }
            blockBuilder.append(false);
        }
        return blockBuilder.build();
    }
}

