/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.block.Block;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.MarkDistinctHash;
import com.facebook.presto.operator.MarkDistinctSampledOperator;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.operator.Page;
import com.facebook.presto.tuple.TupleInfo;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Collection;
import java.util.List;

public class MarkDistinctOperator
implements Operator {
    private final OperatorContext operatorContext;
    private final List<TupleInfo> tupleInfos;
    private final MarkDistinctHash markDistinctHash;
    private Page outputPage;
    private boolean finishing;

    public MarkDistinctOperator(OperatorContext operatorContext, List<TupleInfo> tupleInfos, int[] markDistinctChannels) {
        this.operatorContext = (OperatorContext)Preconditions.checkNotNull((Object)operatorContext, (Object)"operatorContext is null");
        Preconditions.checkNotNull(tupleInfos, (Object)"tupleInfos is null");
        Preconditions.checkArgument((markDistinctChannels.length >= 0 ? 1 : 0) != 0, (Object)"markDistinctChannels is empty");
        ImmutableList.Builder types = ImmutableList.builder();
        for (int channel : markDistinctChannels) {
            types.add((Object)tupleInfos.get(channel).getType());
        }
        this.markDistinctHash = new MarkDistinctHash((List<TupleInfo.Type>)types.build(), markDistinctChannels);
        this.tupleInfos = tupleInfos;
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public List<TupleInfo> getTupleInfos() {
        return this.tupleInfos;
    }

    @Override
    public void finish() {
        this.finishing = true;
    }

    @Override
    public boolean isFinished() {
        return this.finishing && this.outputPage == null;
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        return NOT_BLOCKED;
    }

    @Override
    public boolean needsInput() {
        this.operatorContext.setMemoryReservation(this.markDistinctHash.getEstimatedSize());
        return !this.finishing && this.outputPage == null;
    }

    @Override
    public void addInput(Page page) {
        Preconditions.checkNotNull((Object)page, (Object)"page is null");
        Preconditions.checkState((!this.finishing ? 1 : 0) != 0, (Object)"Operator is finishing");
        Preconditions.checkState((this.outputPage == null ? 1 : 0) != 0, (Object)"Operator still has pending output");
        this.operatorContext.setMemoryReservation(this.markDistinctHash.getEstimatedSize());
        Block markerBlock = this.markDistinctHash.markDistinctRows(page);
        Block[] sourceBlocks = page.getBlocks();
        Block[] outputBlocks = new Block[sourceBlocks.length + 1];
        System.arraycopy(sourceBlocks, 0, outputBlocks, 0, sourceBlocks.length);
        outputBlocks[sourceBlocks.length] = markerBlock;
        this.outputPage = new Page(outputBlocks);
    }

    @Override
    public Page getOutput() {
        Page result = this.outputPage;
        this.outputPage = null;
        return result;
    }

    public static class MarkDistinctOperatorFactory
    implements OperatorFactory {
        private final int operatorId;
        private final int[] markDistinctChannels;
        private final List<TupleInfo> tupleInfos;
        private final Optional<Integer> sampleWeightChannel;
        private boolean closed;

        public MarkDistinctOperatorFactory(int operatorId, List<TupleInfo> sourceTupleInfos, Collection<Integer> markDistinctChannels, Optional<Integer> sampleWeightChannel) {
            this.operatorId = operatorId;
            Preconditions.checkNotNull(markDistinctChannels, (Object)"markDistinctChannels is null");
            Preconditions.checkArgument((!markDistinctChannels.isEmpty() ? 1 : 0) != 0, (Object)"markDistinctChannels is empty");
            Preconditions.checkNotNull(sampleWeightChannel, (Object)"sampleWeightChannel is null");
            this.markDistinctChannels = Ints.toArray(markDistinctChannels);
            this.sampleWeightChannel = sampleWeightChannel;
            this.tupleInfos = ImmutableList.builder().addAll(sourceTupleInfos).add((Object)TupleInfo.SINGLE_BOOLEAN).build();
        }

        @Override
        public List<TupleInfo> getTupleInfos() {
            return this.tupleInfos;
        }

        @Override
        public Operator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, MarkDistinctOperator.class.getSimpleName());
            if (this.sampleWeightChannel.isPresent()) {
                return new MarkDistinctSampledOperator(operatorContext, this.tupleInfos, this.markDistinctChannels, (Integer)this.sampleWeightChannel.get());
            }
            return new MarkDistinctOperator(operatorContext, this.tupleInfos, this.markDistinctChannels);
        }

        @Override
        public void close() {
            this.closed = true;
        }
    }
}

