/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.block.BlockBuilder;
import com.facebook.presto.block.BlockCursor;
import com.facebook.presto.operator.MarkDistinctHash;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.Page;
import com.facebook.presto.operator.PageBuilder;
import com.facebook.presto.tuple.TupleInfo;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Arrays;
import java.util.List;

class MarkDistinctSampledOperator
implements Operator {
    private final OperatorContext operatorContext;
    private final List<TupleInfo> tupleInfos;
    private final MarkDistinctHash markDistinctHash;
    private final int sampleWeightChannel;
    private final int markerChannel;
    private BlockCursor[] cursors;
    private BlockCursor markerCursor;
    private boolean finishing;
    private PageBuilder pageBuilder;
    private long sampleWeight;
    private boolean distinct;

    public MarkDistinctSampledOperator(OperatorContext operatorContext, List<TupleInfo> tupleInfos, int[] markDistinctChannels, int sampleWeightChannel) {
        this.operatorContext = (OperatorContext)Preconditions.checkNotNull((Object)operatorContext, (Object)"operatorContext is null");
        Preconditions.checkNotNull(tupleInfos, (Object)"tupleInfos is null");
        Preconditions.checkArgument((markDistinctChannels.length >= 0 ? 1 : 0) != 0, (Object)"markDistinctChannels is empty");
        this.sampleWeightChannel = sampleWeightChannel;
        this.markerChannel = tupleInfos.size() - 1;
        ImmutableList.Builder types = ImmutableList.builder();
        for (int channel : markDistinctChannels) {
            types.add((Object)tupleInfos.get(channel).getType());
        }
        this.markDistinctHash = new MarkDistinctHash((List<TupleInfo.Type>)types.build(), markDistinctChannels);
        this.tupleInfos = tupleInfos;
        this.pageBuilder = new PageBuilder(tupleInfos);
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public List<TupleInfo> getTupleInfos() {
        return this.tupleInfos;
    }

    @Override
    public void finish() {
        this.finishing = true;
    }

    @Override
    public boolean isFinished() {
        return this.finishing && this.markerCursor == null && this.pageBuilder.isEmpty();
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        return NOT_BLOCKED;
    }

    @Override
    public boolean needsInput() {
        this.operatorContext.setMemoryReservation(this.markDistinctHash.getEstimatedSize());
        return !this.finishing && this.markerCursor == null;
    }

    @Override
    public void addInput(Page page) {
        Preconditions.checkNotNull((Object)page, (Object)"page is null");
        Preconditions.checkState((!this.finishing ? 1 : 0) != 0, (Object)"Operator is finishing");
        Preconditions.checkState((this.markerCursor == null ? 1 : 0) != 0, (Object)"Current page has not been completely processed yet");
        this.operatorContext.setMemoryReservation(this.markDistinctHash.getEstimatedSize());
        this.markerCursor = this.markDistinctHash.markDistinctRows(page).cursor();
        this.cursors = new BlockCursor[page.getChannelCount()];
        for (int i = 0; i < page.getChannelCount(); ++i) {
            this.cursors[i] = page.getBlock(i).cursor();
        }
    }

    private boolean advance() {
        if (this.markerCursor == null) {
            return false;
        }
        if (this.distinct && this.sampleWeight > 1L) {
            this.distinct = false;
            --this.sampleWeight;
            return true;
        }
        boolean advanced = this.markerCursor.advanceNextPosition();
        for (BlockCursor cursor : this.cursors) {
            Preconditions.checkState((advanced == cursor.advanceNextPosition() ? 1 : 0) != 0);
        }
        if (!advanced) {
            this.markerCursor = null;
            Arrays.fill(this.cursors, null);
        } else {
            this.sampleWeight = this.cursors[this.sampleWeightChannel].getLong();
            this.distinct = this.markerCursor.getBoolean();
        }
        return advanced;
    }

    @Override
    public Page getOutput() {
        while (!this.pageBuilder.isFull() && this.advance()) {
            for (int i = 0; i < this.cursors.length; ++i) {
                BlockBuilder builder = this.pageBuilder.getBlockBuilder(i);
                if (i == this.sampleWeightChannel) {
                    if (this.distinct) {
                        builder.append(1L);
                        continue;
                    }
                    builder.append(this.sampleWeight);
                    continue;
                }
                builder.append(this.cursors[i]);
            }
            this.pageBuilder.getBlockBuilder(this.markerChannel).append(this.distinct);
        }
        if (this.pageBuilder.isFull() || this.finishing && !this.pageBuilder.isEmpty() && this.markerCursor == null) {
            Page page = this.pageBuilder.build();
            this.pageBuilder.reset();
            return page;
        }
        return null;
    }
}

