/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.operator.Page;
import com.facebook.presto.operator.PageBuilder;
import com.facebook.presto.operator.PagesIndex;
import com.facebook.presto.operator.SortOrder;
import com.facebook.presto.tuple.TupleInfo;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class OrderByOperator
implements Operator {
    private final OperatorContext operatorContext;
    private final int[] sortChannels;
    private final SortOrder[] sortOrder;
    private final int[] outputChannels;
    private final List<TupleInfo> tupleInfos;
    private final PagesIndex pageIndex;
    private final PageBuilder pageBuilder;
    private int currentPosition;
    private State state = State.NEEDS_INPUT;

    public OrderByOperator(OperatorContext operatorContext, List<TupleInfo> sourceTupleInfos, int[] outputChannels, int expectedPositions, int[] sortChannels, SortOrder[] sortOrder) {
        this.operatorContext = (OperatorContext)Preconditions.checkNotNull((Object)operatorContext, (Object)"operatorContext is null");
        this.outputChannels = (int[])Preconditions.checkNotNull((Object)outputChannels, (Object)"outputChannels is null");
        this.tupleInfos = OrderByOperator.toTupleInfos(sourceTupleInfos, outputChannels);
        this.sortChannels = (int[])Preconditions.checkNotNull((Object)sortChannels, (Object)"sortChannels is null");
        this.sortOrder = (SortOrder[])Preconditions.checkNotNull((Object)sortOrder, (Object)"sortOrder is null");
        this.pageIndex = new PagesIndex(sourceTupleInfos, expectedPositions, operatorContext);
        this.pageBuilder = new PageBuilder(this.tupleInfos);
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public List<TupleInfo> getTupleInfos() {
        return this.tupleInfos;
    }

    @Override
    public void finish() {
        if (this.state == State.NEEDS_INPUT) {
            this.state = State.HAS_OUTPUT;
            this.pageIndex.sort(this.sortChannels, this.sortOrder);
        }
    }

    @Override
    public boolean isFinished() {
        return this.state == State.FINISHED;
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        return NOT_BLOCKED;
    }

    @Override
    public boolean needsInput() {
        return this.state == State.NEEDS_INPUT;
    }

    @Override
    public void addInput(Page page) {
        Preconditions.checkState((this.state == State.NEEDS_INPUT ? 1 : 0) != 0, (Object)"Operator is already finishing");
        Preconditions.checkNotNull((Object)page, (Object)"page is null");
        this.pageIndex.addPage(page);
    }

    @Override
    public Page getOutput() {
        if (this.state != State.HAS_OUTPUT) {
            return null;
        }
        if (this.currentPosition >= this.pageIndex.getPositionCount()) {
            this.state = State.FINISHED;
            return null;
        }
        this.pageBuilder.reset();
        while (!this.pageBuilder.isFull() && this.currentPosition < this.pageIndex.getPositionCount()) {
            for (int i = 0; i < this.outputChannels.length; ++i) {
                this.pageIndex.appendTupleTo(this.outputChannels[i], this.currentPosition, this.pageBuilder.getBlockBuilder(i));
            }
            ++this.currentPosition;
        }
        if (this.pageBuilder.isEmpty()) {
            this.state = State.FINISHED;
            return null;
        }
        Page page = this.pageBuilder.build();
        return page;
    }

    private static SortOrder[] defaultSortOrder(int[] orderByChannels) {
        SortOrder[] sortOrder = new SortOrder[orderByChannels.length];
        Arrays.fill((Object[])sortOrder, (Object)SortOrder.ASC_NULLS_LAST);
        return sortOrder;
    }

    private static List<TupleInfo> toTupleInfos(List<TupleInfo> sourceTupleInfos, int[] outputChannels) {
        ImmutableList.Builder tupleInfos = ImmutableList.builder();
        for (int channel : outputChannels) {
            tupleInfos.add((Object)sourceTupleInfos.get(channel));
        }
        return tupleInfos.build();
    }

    private static enum State {
        NEEDS_INPUT,
        HAS_OUTPUT,
        FINISHED;

    }

    public static class OrderByOperatorFactory
    implements OperatorFactory {
        private final int operatorId;
        private final List<TupleInfo> sourceTupleInfos;
        private final int[] outputChannels;
        private final int expectedPositions;
        private final int[] sortChannels;
        private final SortOrder[] sortOrder;
        private final List<TupleInfo> tupleInfos;
        private boolean closed;

        public OrderByOperatorFactory(int operatorId, List<TupleInfo> sourceTupleInfos, int[] sortChannels, int[] outputChannels, int expectedPositions) {
            this(operatorId, sourceTupleInfos, outputChannels, expectedPositions, sortChannels, OrderByOperator.defaultSortOrder(sortChannels));
        }

        public OrderByOperatorFactory(int operatorId, List<TupleInfo> sourceTupleInfos, int[] outputChannels, int expectedPositions, int[] sortChannels, SortOrder[] sortOrder) {
            this.operatorId = operatorId;
            this.sourceTupleInfos = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(sourceTupleInfos, (Object)"sourceTupleInfos is null")));
            this.outputChannels = (int[])Preconditions.checkNotNull((Object)outputChannels, (Object)"outputChannels is null");
            this.expectedPositions = expectedPositions;
            this.sortChannels = (int[])Preconditions.checkNotNull((Object)sortChannels, (Object)"sortChannels is null");
            this.sortOrder = (SortOrder[])Preconditions.checkNotNull((Object)sortOrder, (Object)"sortOrder is null");
            this.tupleInfos = OrderByOperator.toTupleInfos(sourceTupleInfos, outputChannels);
        }

        @Override
        public List<TupleInfo> getTupleInfos() {
            return this.tupleInfos;
        }

        @Override
        public Operator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, OrderByOperator.class.getSimpleName());
            return new OrderByOperator(operatorContext, this.sourceTupleInfos, this.outputChannels, this.expectedPositions, this.sortChannels, this.sortOrder);
        }

        @Override
        public void close() {
            this.closed = true;
        }
    }
}

