/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.block.Block;
import com.facebook.presto.block.BlockBuilder;
import com.facebook.presto.block.uncompressed.UncompressedBlock;
import com.facebook.presto.operator.ChannelIndex;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.Page;
import com.facebook.presto.operator.SortOrder;
import com.facebook.presto.tuple.TupleInfo;
import io.airlift.units.DataSize;
import it.unimi.dsi.fastutil.Arrays;
import it.unimi.dsi.fastutil.Swapper;
import it.unimi.dsi.fastutil.ints.AbstractIntComparator;
import it.unimi.dsi.fastutil.ints.IntComparator;
import java.util.List;

public class PagesIndex
implements Swapper {
    private final ChannelIndex[] indexes;
    private final List<TupleInfo> tupleInfos;
    private final OperatorContext operatorContext;
    private int positionCount;
    private long estimatedSize;

    public PagesIndex(List<TupleInfo> tupleInfos, int expectedPositions, OperatorContext operatorContext) {
        this.tupleInfos = tupleInfos;
        this.operatorContext = operatorContext;
        this.indexes = new ChannelIndex[tupleInfos.size()];
        for (int channel = 0; channel < this.indexes.length; ++channel) {
            this.indexes[channel] = new ChannelIndex(expectedPositions, tupleInfos.get(channel));
        }
    }

    public List<TupleInfo> getTupleInfos() {
        return this.tupleInfos;
    }

    public int getPositionCount() {
        return this.positionCount;
    }

    public void addPage(Page page) {
        this.positionCount += page.getPositionCount();
        Block[] blocks = page.getBlocks();
        for (int channel = 0; channel < this.indexes.length; ++channel) {
            this.indexes[channel].indexBlock((UncompressedBlock)blocks[channel]);
        }
        this.estimatedSize = this.operatorContext.setMemoryReservation(this.calculateEstimatedSize());
    }

    public DataSize getEstimatedSize() {
        return new DataSize((double)this.estimatedSize, DataSize.Unit.BYTE);
    }

    private long calculateEstimatedSize() {
        long size = 0L;
        for (ChannelIndex channelIndex : this.indexes) {
            size += channelIndex.getEstimatedSize().toBytes();
        }
        return size;
    }

    public TupleInfo getTupleInfo(int channel) {
        return this.indexes[channel].getTupleInfo();
    }

    public ChannelIndex getIndex(int channel) {
        return this.indexes[channel];
    }

    public void swap(int a, int b) {
        for (ChannelIndex index : this.indexes) {
            index.swap(a, b);
        }
    }

    public void appendTupleTo(int channel, int position, BlockBuilder output) {
        this.indexes[channel].appendTo(position, output);
    }

    public void sort(int[] sortChannels, SortOrder[] sortOrders) {
        MultiSliceFieldOrderedTupleComparator comparator = new MultiSliceFieldOrderedTupleComparator(this, sortChannels, sortOrders);
        Arrays.quickSort((int)0, (int)this.positionCount, (IntComparator)comparator, (Swapper)this);
    }

    public static class MultiSliceFieldOrderedTupleComparator
    extends AbstractIntComparator {
        private final PagesIndex pagesIndex;
        private final int[] sortChannels;
        private final SortOrder[] sortOrders;

        public MultiSliceFieldOrderedTupleComparator(PagesIndex pagesIndex, int[] sortChannels, SortOrder[] sortOrders) {
            this.pagesIndex = pagesIndex;
            this.sortChannels = sortChannels;
            this.sortOrders = sortOrders;
        }

        public int compare(int leftPosition, int rightPosition) {
            for (int i = 0; i < this.sortChannels.length; ++i) {
                ChannelIndex index = this.pagesIndex.getIndex(this.sortChannels[i]);
                int compare = index.compare(this.sortOrders[i], leftPosition, rightPosition);
                if (compare == 0) continue;
                return compare;
            }
            return 0;
        }
    }
}

