/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.block.BlockBuilder;
import com.facebook.presto.operator.ProjectionFunction;
import com.facebook.presto.spi.RecordCursor;
import com.facebook.presto.sql.tree.Input;
import com.facebook.presto.tuple.TupleInfo;
import com.facebook.presto.tuple.TupleReadable;
import com.google.common.base.Preconditions;

public final class ProjectionFunctions {
    private ProjectionFunctions() {
    }

    public static ProjectionFunction singleColumn(TupleInfo.Type columnType, int channelIndex) {
        return new SingleColumnProjection(columnType, channelIndex);
    }

    public static ProjectionFunction singleColumn(TupleInfo.Type columnType, Input input) {
        return new SingleColumnProjection(columnType, input.getChannel());
    }

    private static class SingleColumnProjection
    implements ProjectionFunction {
        private final TupleInfo.Type columnType;
        private final int channelIndex;
        private final TupleInfo info;

        public SingleColumnProjection(TupleInfo.Type columnType, int channelIndex) {
            Preconditions.checkNotNull((Object)columnType, (Object)"columnType is null");
            Preconditions.checkArgument((channelIndex >= 0 ? 1 : 0) != 0, (Object)"channelIndex is negative");
            this.columnType = columnType;
            this.channelIndex = channelIndex;
            this.info = new TupleInfo(columnType);
        }

        @Override
        public TupleInfo getTupleInfo() {
            return this.info;
        }

        @Override
        public void project(TupleReadable[] cursors, BlockBuilder output) {
            if (!cursors[this.channelIndex].isNull()) {
                switch (this.columnType) {
                    case BOOLEAN: {
                        output.append(cursors[this.channelIndex].getBoolean());
                        return;
                    }
                    case FIXED_INT_64: {
                        output.append(cursors[this.channelIndex].getLong());
                        return;
                    }
                    case VARIABLE_BINARY: {
                        output.append(cursors[this.channelIndex].getSlice());
                        return;
                    }
                    case DOUBLE: {
                        output.append(cursors[this.channelIndex].getDouble());
                        return;
                    }
                }
                throw new IllegalStateException("Unsupported type info " + this.info);
            }
            output.appendNull();
        }

        @Override
        public void project(RecordCursor cursor, BlockBuilder output) {
            if (cursor.isNull(this.channelIndex)) {
                output.appendNull();
            } else {
                switch (this.columnType) {
                    case BOOLEAN: {
                        output.append(cursor.getBoolean(this.channelIndex));
                        break;
                    }
                    case FIXED_INT_64: {
                        output.append(cursor.getLong(this.channelIndex));
                        break;
                    }
                    case VARIABLE_BINARY: {
                        output.append(cursor.getString(this.channelIndex));
                        break;
                    }
                    case DOUBLE: {
                        output.append(cursor.getDouble(this.channelIndex));
                    }
                }
            }
        }
    }
}

