/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.RecordSinkProvider;
import com.facebook.presto.spi.ConnectorRecordSinkProvider;
import com.facebook.presto.spi.OutputTableHandle;
import com.facebook.presto.spi.RecordSink;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Set;
import javax.inject.Inject;

public class RecordSinkManager
implements RecordSinkProvider {
    private final Set<ConnectorRecordSinkProvider> recordSinkProviders = Sets.newConcurrentHashSet();

    public RecordSinkManager(ConnectorRecordSinkProvider ... recordSinkProviders) {
        this((Set<ConnectorRecordSinkProvider>)ImmutableSet.copyOf((Object[])recordSinkProviders));
    }

    @Inject
    public RecordSinkManager(Set<ConnectorRecordSinkProvider> recordSinkProviders) {
        this.recordSinkProviders.addAll(recordSinkProviders);
    }

    public void addConnectorRecordSinkProvider(ConnectorRecordSinkProvider recordSinkProvider) {
        this.recordSinkProviders.add(recordSinkProvider);
    }

    @Override
    public RecordSink getRecordSink(OutputTableHandle tableHandle) {
        for (ConnectorRecordSinkProvider provider : this.recordSinkProviders) {
            if (!provider.canHandle(tableHandle)) continue;
            return provider.getRecordSink(tableHandle);
        }
        throw new IllegalArgumentException("No record sink for " + tableHandle);
    }
}

