/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.block.BlockCursor;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.operator.Page;
import com.facebook.presto.operator.PageBuilder;
import com.facebook.presto.tuple.TupleInfo;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import org.apache.commons.math3.random.RandomDataGenerator;

public class SampleOperator
implements Operator {
    private final OperatorContext operatorContext;
    private final List<TupleInfo> tupleInfos;
    private final PageBuilder pageBuilder;
    private final BlockCursor[] cursors;
    private final RandomDataGenerator rand = new RandomDataGenerator();
    private final double sampleRatio;
    private final boolean rescaled;
    private final int sampleWeightChannel;
    private boolean finishing;
    private int remainingPositions;

    public SampleOperator(OperatorContext operatorContext, double sampleRatio, boolean rescaled, List<TupleInfo> tupleInfos) {
        Preconditions.checkArgument((sampleRatio > 0.0 ? 1 : 0) != 0, (Object)"sample ratio must be strictly positive");
        this.operatorContext = (OperatorContext)Preconditions.checkNotNull((Object)operatorContext, (Object)"operatorContext is null");
        this.tupleInfos = ImmutableList.copyOf(tupleInfos);
        this.pageBuilder = new PageBuilder(tupleInfos);
        this.cursors = new BlockCursor[tupleInfos.size() - 1];
        this.sampleWeightChannel = tupleInfos.size() - 1;
        this.sampleRatio = sampleRatio;
        this.rescaled = rescaled;
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public List<TupleInfo> getTupleInfos() {
        return this.tupleInfos;
    }

    @Override
    public final void finish() {
        this.finishing = true;
    }

    @Override
    public final boolean isFinished() {
        return this.finishing && this.pageBuilder.isEmpty() && this.remainingPositions == 0;
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        return NOT_BLOCKED;
    }

    @Override
    public final boolean needsInput() {
        return !this.finishing && !this.pageBuilder.isFull() && this.remainingPositions == 0;
    }

    @Override
    public void addInput(Page page) {
        Preconditions.checkState((!this.finishing ? 1 : 0) != 0, (Object)"Operator is already finishing");
        Preconditions.checkNotNull((Object)page, (Object)"page is null");
        Preconditions.checkState((!this.pageBuilder.isFull() ? 1 : 0) != 0, (Object)"Page buffer is full");
        Preconditions.checkState((this.remainingPositions == 0 ? 1 : 0) != 0, (Object)"previous page has not been completely processed");
        for (int i = 0; i < page.getChannelCount(); ++i) {
            this.cursors[i] = page.getBlock(i).cursor();
        }
        this.remainingPositions = page.getPositionCount();
    }

    @Override
    public Page getOutput() {
        while (this.remainingPositions > 0 && !this.pageBuilder.isFull()) {
            for (BlockCursor cursor : this.cursors) {
                Preconditions.checkState((boolean)cursor.advanceNextPosition());
            }
            long repeats = this.rand.nextPoisson(this.sampleRatio);
            if (this.rescaled && repeats > 0L) {
                repeats *= this.rand.nextPoisson(1.0 / this.sampleRatio);
            }
            if (repeats > 0L) {
                for (int i = 0; i < this.cursors.length; ++i) {
                    this.cursors[i].appendTupleTo(this.pageBuilder.getBlockBuilder(i));
                }
                this.pageBuilder.getBlockBuilder(this.sampleWeightChannel).append(repeats);
            }
            --this.remainingPositions;
        }
        if (this.pageBuilder.isFull() || this.finishing && !this.pageBuilder.isEmpty()) {
            Page page = this.pageBuilder.build();
            this.pageBuilder.reset();
            return page;
        }
        return null;
    }

    public static class SampleOperatorFactory
    implements OperatorFactory {
        private final int operatorId;
        private final double sampleRatio;
        private final boolean rescaled;
        private final List<TupleInfo> tupleInfos;
        private boolean closed;

        public SampleOperatorFactory(int operatorId, double sampleRatio, boolean rescaled, List<TupleInfo> sourceTupleInfos) {
            this.operatorId = operatorId;
            this.sampleRatio = sampleRatio;
            this.rescaled = rescaled;
            this.tupleInfos = ImmutableList.builder().addAll((Iterable)Preconditions.checkNotNull(sourceTupleInfos, (Object)"sourceTupleInfos is null")).add((Object)TupleInfo.SINGLE_LONG).build();
        }

        @Override
        public List<TupleInfo> getTupleInfos() {
            return this.tupleInfos;
        }

        @Override
        public Operator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, SampleOperator.class.getSimpleName());
            return new SampleOperator(operatorContext, this.sampleRatio, this.rescaled, this.tupleInfos);
        }

        @Override
        public void close() {
            this.closed = true;
        }
    }
}

