/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.SyntheticAddress;
import com.facebook.presto.tuple.TupleInfo;
import com.google.common.base.Preconditions;
import io.airlift.slice.Slice;
import io.airlift.units.DataSize;
import it.unimi.dsi.fastutil.longs.LongHash;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;

public class SliceHashStrategy
implements LongHash.Strategy {
    public static final int LOOKUP_SLICE_INDEX = -1;
    private final TupleInfo tupleInfo;
    private final List<Slice> slices;
    private Slice lookupSlice;
    private long memorySize;

    public SliceHashStrategy(TupleInfo tupleInfo) {
        this.tupleInfo = (TupleInfo)Preconditions.checkNotNull((Object)tupleInfo, (Object)"tupleInfo is null");
        this.slices = ObjectArrayList.wrap((Object[])new Slice[1024], (int)0);
    }

    public SliceHashStrategy(SliceHashStrategy strategy) {
        Preconditions.checkNotNull((Object)strategy, (Object)"strategy is null");
        this.tupleInfo = strategy.tupleInfo;
        this.slices = strategy.slices;
    }

    public DataSize getEstimatedSize() {
        return new DataSize((double)this.memorySize, DataSize.Unit.BYTE);
    }

    public void setLookupSlice(Slice lookupSlice) {
        Preconditions.checkNotNull((Object)lookupSlice, (Object)"lookupSlice is null");
        this.lookupSlice = lookupSlice;
    }

    public void addSlices(Iterable<Slice> slices) {
        for (Slice slice : slices) {
            this.addSlice(slice);
        }
    }

    public void addSlice(Slice slice) {
        this.memorySize += (long)slice.length();
        this.slices.add(slice);
    }

    public int hashCode(long sliceAddress) {
        Slice slice = this.getSliceForSyntheticAddress(sliceAddress);
        int offset = (int)sliceAddress;
        int length = this.tupleInfo.size(slice, offset);
        return slice.hashCode(offset, length);
    }

    public boolean equals(long leftSliceAddress, long rightSliceAddress) {
        Slice leftSlice = this.getSliceForSyntheticAddress(leftSliceAddress);
        int leftOffset = SyntheticAddress.decodePosition(leftSliceAddress);
        int leftLength = this.tupleInfo.size(leftSlice, leftOffset);
        Slice rightSlice = this.getSliceForSyntheticAddress(rightSliceAddress);
        int rightOffset = SyntheticAddress.decodePosition(rightSliceAddress);
        int rightLength = this.tupleInfo.size(rightSlice, rightOffset);
        return leftSlice.equals(leftOffset, leftLength, rightSlice, rightOffset, rightLength);
    }

    private Slice getSliceForSyntheticAddress(long sliceAddress) {
        int sliceIndex = SyntheticAddress.decodeSliceIndex(sliceAddress);
        return sliceIndex == -1 ? this.lookupSlice : this.slices.get(sliceIndex);
    }
}

