/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.execution.StateMachine;
import com.facebook.presto.execution.TaskId;
import com.facebook.presto.execution.TaskState;
import com.facebook.presto.execution.TaskStateMachine;
import com.facebook.presto.operator.PipelineContext;
import com.facebook.presto.operator.PipelineStats;
import com.facebook.presto.operator.TaskStats;
import com.facebook.presto.sql.analyzer.Session;
import com.facebook.presto.util.Threads;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.airlift.stats.CounterStat;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.concurrent.ThreadSafe;
import org.joda.time.DateTime;

@ThreadSafe
public class TaskContext {
    private final TaskStateMachine taskStateMachine;
    private final Executor executor;
    private final Session session;
    private final long maxMemory;
    private final DataSize operatorPreAllocatedMemory;
    private final AtomicLong memoryReservation = new AtomicLong();
    private final DateTime createdTime = DateTime.now();
    private final long createNanos = System.nanoTime();
    private final AtomicLong startNanos = new AtomicLong();
    private final AtomicLong endNanos = new AtomicLong();
    private final AtomicReference<DateTime> executionStartTime = new AtomicReference();
    private final AtomicReference<DateTime> lastExecutionStartTime = new AtomicReference();
    private final AtomicReference<DateTime> executionEndTime = new AtomicReference();
    private final List<PipelineContext> pipelineContexts = new CopyOnWriteArrayList<PipelineContext>();
    private final boolean cpuTimerEnabled;

    public TaskContext(TaskId taskId, Executor executor, Session session) {
        this((TaskId)Preconditions.checkNotNull((Object)taskId, (Object)"taskId is null"), Threads.checkNotSameThreadExecutor(executor, "executor is null"), session, new DataSize(256.0, DataSize.Unit.MEGABYTE));
    }

    public TaskContext(TaskId taskId, Executor executor, Session session, DataSize maxMemory) {
        this(new TaskStateMachine((TaskId)Preconditions.checkNotNull((Object)taskId, (Object)"taskId is null"), Threads.checkNotSameThreadExecutor(executor, "executor is null")), executor, session, (DataSize)Preconditions.checkNotNull((Object)maxMemory, (Object)"maxMemory is null"), new DataSize(1.0, DataSize.Unit.MEGABYTE), true);
    }

    public TaskContext(TaskStateMachine taskStateMachine, Executor executor, Session session, DataSize maxMemory, DataSize operatorPreAllocatedMemory, boolean cpuTimerEnabled) {
        this.taskStateMachine = (TaskStateMachine)Preconditions.checkNotNull((Object)taskStateMachine, (Object)"taskStateMachine is null");
        this.executor = (Executor)Preconditions.checkNotNull((Object)executor, (Object)"executor is null");
        this.session = session;
        this.maxMemory = ((DataSize)Preconditions.checkNotNull((Object)maxMemory, (Object)"maxMemory is null")).toBytes();
        this.operatorPreAllocatedMemory = (DataSize)Preconditions.checkNotNull((Object)operatorPreAllocatedMemory, (Object)"operatorPreAllocatedMemory is null");
        taskStateMachine.addStateChangeListener(new StateMachine.StateChangeListener<TaskState>(){

            @Override
            public void stateChanged(TaskState newValue) {
                if (newValue.isDone()) {
                    TaskContext.this.executionEndTime.set(DateTime.now());
                    TaskContext.this.endNanos.set(System.nanoTime());
                }
            }
        });
        this.cpuTimerEnabled = cpuTimerEnabled;
    }

    public TaskId getTaskId() {
        return this.taskStateMachine.getTaskId();
    }

    public PipelineContext addPipelineContext(boolean inputPipeline, boolean outputPipeline) {
        PipelineContext pipelineContext = new PipelineContext(this, this.executor, inputPipeline, outputPipeline);
        this.pipelineContexts.add(pipelineContext);
        return pipelineContext;
    }

    public List<PipelineContext> getPipelineContexts() {
        return ImmutableList.copyOf(this.pipelineContexts);
    }

    public Session getSession() {
        return this.session;
    }

    public void start() {
        if (!this.startNanos.compareAndSet(0L, System.nanoTime())) {
            return;
        }
        DateTime now = DateTime.now();
        this.executionStartTime.compareAndSet(null, now);
        this.lastExecutionStartTime.set(now);
    }

    public void failed(Throwable cause) {
        this.taskStateMachine.failed(cause);
    }

    public boolean isDone() {
        return this.taskStateMachine.getState().isDone();
    }

    public DataSize getMaxMemorySize() {
        return new DataSize((double)this.maxMemory, DataSize.Unit.BYTE).convertToMostSuccinctDataSize();
    }

    public DataSize getOperatorPreAllocatedMemory() {
        return this.operatorPreAllocatedMemory;
    }

    public synchronized boolean reserveMemory(long bytes) {
        Preconditions.checkArgument((bytes >= 0L ? 1 : 0) != 0, (Object)"bytes is negative");
        if (this.memoryReservation.get() + bytes > this.maxMemory) {
            return false;
        }
        this.memoryReservation.getAndAdd(bytes);
        return true;
    }

    public boolean isCpuTimerEnabled() {
        return this.cpuTimerEnabled;
    }

    public CounterStat getInputDataSize() {
        CounterStat stat = new CounterStat();
        for (PipelineContext pipelineContext : this.pipelineContexts) {
            if (!pipelineContext.isInputPipeline()) continue;
            stat.merge(pipelineContext.getInputDataSize());
        }
        return stat;
    }

    public CounterStat getInputPositions() {
        CounterStat stat = new CounterStat();
        for (PipelineContext pipelineContext : this.pipelineContexts) {
            if (!pipelineContext.isInputPipeline()) continue;
            stat.merge(pipelineContext.getInputPositions());
        }
        return stat;
    }

    public CounterStat getOutputDataSize() {
        CounterStat stat = new CounterStat();
        for (PipelineContext pipelineContext : this.pipelineContexts) {
            if (!pipelineContext.isOutputPipeline()) continue;
            stat.merge(pipelineContext.getOutputDataSize());
        }
        return stat;
    }

    public CounterStat getOutputPositions() {
        CounterStat stat = new CounterStat();
        for (PipelineContext pipelineContext : this.pipelineContexts) {
            if (!pipelineContext.isOutputPipeline()) continue;
            stat.merge(pipelineContext.getOutputPositions());
        }
        return stat;
    }

    public TaskStats getTaskStats() {
        DateTime now;
        if (this.taskStateMachine.getState().isDone() && this.executionEndTime.compareAndSet(null, now = DateTime.now())) {
            this.lastExecutionStartTime.set(now);
            this.endNanos.set(System.nanoTime());
        }
        ImmutableList pipelineStats = ImmutableList.copyOf((Iterable)Iterables.transform(this.pipelineContexts, PipelineContext.pipelineStatsGetter()));
        int totalDrivers = 0;
        int queuedDrivers = 0;
        int runningDrivers = 0;
        int completedDrivers = 0;
        long totalScheduledTime = 0L;
        long totalCpuTime = 0L;
        long totalUserTime = 0L;
        long totalBlockedTime = 0L;
        long rawInputDataSize = 0L;
        long rawInputPositions = 0L;
        long processedInputDataSize = 0L;
        long processedInputPositions = 0L;
        long outputDataSize = 0L;
        long outputPositions = 0L;
        for (PipelineStats pipeline : pipelineStats) {
            totalDrivers += pipeline.getTotalDrivers();
            queuedDrivers += pipeline.getQueuedDrivers();
            runningDrivers += pipeline.getRunningDrivers();
            completedDrivers += pipeline.getCompletedDrivers();
            totalScheduledTime += pipeline.getTotalScheduledTime().roundTo(TimeUnit.NANOSECONDS);
            totalCpuTime += pipeline.getTotalCpuTime().roundTo(TimeUnit.NANOSECONDS);
            totalUserTime += pipeline.getTotalUserTime().roundTo(TimeUnit.NANOSECONDS);
            totalBlockedTime += pipeline.getTotalBlockedTime().roundTo(TimeUnit.NANOSECONDS);
            if (pipeline.isInputPipeline()) {
                rawInputDataSize += pipeline.getRawInputDataSize().toBytes();
                rawInputPositions += pipeline.getRawInputPositions();
                processedInputDataSize += pipeline.getProcessedInputDataSize().toBytes();
                processedInputPositions += pipeline.getProcessedInputPositions();
            }
            if (!pipeline.isOutputPipeline()) continue;
            outputDataSize += pipeline.getOutputDataSize().toBytes();
            outputPositions += pipeline.getOutputPositions();
        }
        long startNanos = this.startNanos.get();
        if (startNanos < this.createNanos) {
            startNanos = System.nanoTime();
        }
        Duration queuedTime = new Duration((double)(startNanos - this.createNanos), TimeUnit.NANOSECONDS);
        long endNanos = this.endNanos.get();
        Duration elapsedTime = endNanos >= startNanos ? new Duration((double)(endNanos - this.createNanos), TimeUnit.NANOSECONDS) : new Duration(0.0, TimeUnit.NANOSECONDS);
        return new TaskStats(this.createdTime, this.executionStartTime.get(), this.lastExecutionStartTime.get(), this.executionEndTime.get(), elapsedTime.convertToMostSuccinctTimeUnit(), queuedTime.convertToMostSuccinctTimeUnit(), totalDrivers, queuedDrivers, runningDrivers, completedDrivers, new DataSize((double)this.memoryReservation.get(), DataSize.Unit.BYTE).convertToMostSuccinctDataSize(), new Duration((double)totalScheduledTime, TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit(), new Duration((double)totalCpuTime, TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit(), new Duration((double)totalUserTime, TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit(), new Duration((double)totalBlockedTime, TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit(), new DataSize((double)rawInputDataSize, DataSize.Unit.BYTE).convertToMostSuccinctDataSize(), rawInputPositions, new DataSize((double)processedInputDataSize, DataSize.Unit.BYTE).convertToMostSuccinctDataSize(), processedInputPositions, new DataSize((double)outputDataSize, DataSize.Unit.BYTE).convertToMostSuccinctDataSize(), outputPositions, (List<PipelineStats>)pipelineStats);
    }

    public static Function<TaskContext, TaskStats> taskStatsGetter() {
        return new Function<TaskContext, TaskStats>(){

            public TaskStats apply(TaskContext taskContext) {
                return taskContext.getTaskStats();
            }
        };
    }
}

