/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.block.BlockCursor;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.operator.Page;
import com.facebook.presto.operator.PageBuilder;
import com.facebook.presto.operator.ProjectionFunction;
import com.facebook.presto.tuple.Tuple;
import com.facebook.presto.tuple.TupleInfo;
import com.facebook.presto.tuple.TupleReadable;
import com.facebook.presto.tuple.Tuples;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Ordering;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.units.DataSize;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.PriorityQueue;

public class TopNOperator
implements Operator {
    private static final int MAX_INITIAL_PRIORITY_QUEUE_SIZE = 10000;
    private static final DataSize OVERHEAD_PER_TUPLE = new DataSize(100.0, DataSize.Unit.BYTE);
    private final OperatorContext operatorContext;
    private final int n;
    private final List<ProjectionFunction> projections;
    private final Ordering<TupleReadable[]> ordering;
    private final List<TupleInfo> tupleInfos;
    private final TopNMemoryManager memoryManager;
    private final boolean partial;
    private final Optional<Integer> sampleWeight;
    private final PageBuilder pageBuilder;
    private TopNBuilder topNBuilder;
    private boolean finishing;
    private Iterator<TupleReadable[]> outputIterator;

    public TopNOperator(OperatorContext operatorContext, int n, List<ProjectionFunction> projections, Ordering<TupleReadable[]> ordering, Optional<Integer> sampleWeight, boolean partial) {
        this.operatorContext = (OperatorContext)Preconditions.checkNotNull((Object)operatorContext, (Object)"operatorContext is null");
        Preconditions.checkArgument((n > 0 ? 1 : 0) != 0, (Object)"n must be greater than zero");
        this.n = n;
        this.projections = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(projections, (Object)"projections is null")));
        Preconditions.checkArgument((!projections.isEmpty() ? 1 : 0) != 0, (Object)"projections is empty");
        this.ordering = ((Ordering)Preconditions.checkNotNull(ordering, (Object)"ordering is null")).reverse();
        this.partial = partial;
        this.memoryManager = new TopNMemoryManager((OperatorContext)Preconditions.checkNotNull((Object)operatorContext, (Object)"operatorContext is null"));
        this.tupleInfos = TopNOperator.toTupleInfos(projections);
        this.pageBuilder = new PageBuilder(this.getTupleInfos());
        this.sampleWeight = sampleWeight;
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public List<TupleInfo> getTupleInfos() {
        return this.tupleInfos;
    }

    @Override
    public void finish() {
        this.finishing = true;
    }

    @Override
    public boolean isFinished() {
        return this.finishing && this.topNBuilder == null && (this.outputIterator == null || !this.outputIterator.hasNext());
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        return NOT_BLOCKED;
    }

    @Override
    public boolean needsInput() {
        return !this.finishing && this.outputIterator == null && (this.topNBuilder == null || !this.topNBuilder.isFull());
    }

    @Override
    public void addInput(Page page) {
        Preconditions.checkState((!this.finishing ? 1 : 0) != 0, (Object)"Operator is already finishing");
        Preconditions.checkNotNull((Object)page, (Object)"page is null");
        if (this.topNBuilder == null) {
            this.topNBuilder = new TopNBuilder(this.n, this.ordering, this.sampleWeight, this.memoryManager);
        }
        Preconditions.checkState((!this.topNBuilder.isFull() ? 1 : 0) != 0, (Object)"Aggregation buffer is full");
        this.topNBuilder.processPage(page);
    }

    @Override
    public Page getOutput() {
        if (this.outputIterator == null || !this.outputIterator.hasNext()) {
            if (this.topNBuilder == null) {
                return null;
            }
            if (!this.finishing && !this.topNBuilder.isFull()) {
                return null;
            }
            Preconditions.checkState((this.finishing || this.partial ? 1 : 0) != 0, (String)"Task exceeded max memory size of %s", (Object[])new Object[]{this.memoryManager.getMaxMemorySize()});
            this.outputIterator = this.topNBuilder.build();
            this.topNBuilder = null;
        }
        this.pageBuilder.reset();
        while (!this.pageBuilder.isFull() && this.outputIterator.hasNext()) {
            TupleReadable[] next = this.outputIterator.next();
            for (int i = 0; i < this.projections.size(); ++i) {
                this.projections.get(i).project(next, this.pageBuilder.getBlockBuilder(i));
            }
        }
        Page page = this.pageBuilder.build();
        return page;
    }

    private static List<TupleInfo> toTupleInfos(List<ProjectionFunction> projections) {
        ImmutableList.Builder tupleInfos = ImmutableList.builder();
        for (ProjectionFunction projection : projections) {
            tupleInfos.add((Object)projection.getTupleInfo());
        }
        return tupleInfos.build();
    }

    public static class TopNMemoryManager {
        private final OperatorContext operatorContext;
        private long currentMemoryReservation;

        public TopNMemoryManager(OperatorContext operatorContext) {
            this.operatorContext = operatorContext;
        }

        public boolean canUse(long memorySize) {
            long delta = (memorySize -= this.operatorContext.getOperatorPreAllocatedMemory().toBytes()) - this.currentMemoryReservation;
            if (delta <= 0L) {
                return false;
            }
            if (!this.operatorContext.reserveMemory(delta)) {
                return true;
            }
            this.currentMemoryReservation = Math.max(this.currentMemoryReservation, memorySize);
            return false;
        }

        public Object getMaxMemorySize() {
            return this.operatorContext.getMaxMemorySize();
        }
    }

    private static class TopNBuilder {
        private final int n;
        private final Ordering<TupleReadable[]> ordering;
        private final TopNMemoryManager memoryManager;
        private final PriorityQueue<Tuple[]> globalCandidates;
        private final Optional<Integer> sampleWeightChannel;
        private long memorySize;

        private TopNBuilder(int n, Ordering<TupleReadable[]> ordering, Optional<Integer> sampleWeightChannel, TopNMemoryManager memoryManager) {
            this.n = n;
            this.ordering = ordering;
            this.memoryManager = memoryManager;
            this.sampleWeightChannel = sampleWeightChannel;
            this.globalCandidates = new PriorityQueue<TupleReadable[]>(Math.min(n, 10000), (Comparator<TupleReadable[]>)ordering);
        }

        public void processPage(Page page) {
            long sizeDelta = this.mergeWithGlobalCandidates(page);
            this.memorySize += sizeDelta;
        }

        private long mergeWithGlobalCandidates(Page page) {
            int i;
            long sizeDelta = 0L;
            BlockCursor[] cursors = new BlockCursor[page.getChannelCount()];
            for (i = 0; i < page.getChannelCount(); ++i) {
                cursors[i] = page.getBlock(i).cursor();
            }
            for (i = 0; i < page.getPositionCount(); ++i) {
                for (BlockCursor cursor : cursors) {
                    Preconditions.checkState((boolean)cursor.advanceNextPosition());
                }
                if (this.globalCandidates.size() < this.n) {
                    sizeDelta += this.addRow(cursors);
                    continue;
                }
                if (this.ordering.compare((Object)cursors, (Object)this.globalCandidates.peek()) <= 0) continue;
                sizeDelta += this.addRow(cursors);
            }
            return sizeDelta;
        }

        private long addRow(BlockCursor[] cursors) {
            long sizeDelta = 0L;
            Tuple[] row = this.getValues(cursors);
            long sampleWeight = 1L;
            if (this.sampleWeightChannel.isPresent()) {
                sampleWeight = row[(Integer)this.sampleWeightChannel.get()].getLong();
                row[((Integer)this.sampleWeightChannel.get()).intValue()] = Tuples.createTuple(1L);
            }
            for (Tuple tuple : row) {
                sizeDelta += (long)tuple.size();
            }
            int i = 0;
            while ((long)i < sampleWeight) {
                sizeDelta += OVERHEAD_PER_TUPLE.toBytes();
                this.globalCandidates.add(row);
                ++i;
            }
            while (this.globalCandidates.size() > this.n) {
                Tuple[] previous = (Tuple[])this.globalCandidates.remove();
                if (previous != this.globalCandidates.peek()) {
                    for (Tuple tuple : previous) {
                        sizeDelta -= (long)tuple.size();
                    }
                }
                sizeDelta -= OVERHEAD_PER_TUPLE.toBytes();
            }
            return sizeDelta;
        }

        private Tuple[] getValues(BlockCursor[] cursors) {
            Tuple[] row = new Tuple[cursors.length];
            for (int i = 0; i < cursors.length; ++i) {
                row[i] = cursors[i].getTuple();
            }
            return row;
        }

        private boolean isFull() {
            return this.memoryManager.canUse(this.memorySize);
        }

        public Iterator<TupleReadable[]> build() {
            ImmutableList.Builder minSortedGlobalCandidates = ImmutableList.builder();
            long sampleWeight = 1L;
            while (!this.globalCandidates.isEmpty()) {
                Tuple[] row = (Tuple[])this.globalCandidates.remove();
                if (this.sampleWeightChannel.isPresent()) {
                    if (this.globalCandidates.peek() != null && this.ordering.compare((Object)row, (Object)this.globalCandidates.peek()) == 0) {
                        ++sampleWeight;
                        continue;
                    }
                    row[((Integer)this.sampleWeightChannel.get()).intValue()] = Tuples.createTuple(sampleWeight);
                    minSortedGlobalCandidates.add((Object)row);
                    sampleWeight = 1L;
                    continue;
                }
                minSortedGlobalCandidates.add((Object)row);
            }
            return minSortedGlobalCandidates.build().reverse().iterator();
        }
    }

    public static class TopNOperatorFactory
    implements OperatorFactory {
        private final int operatorId;
        private final int n;
        private final List<ProjectionFunction> projections;
        private final Ordering<TupleReadable[]> ordering;
        private final boolean partial;
        private final List<TupleInfo> tupleInfos;
        private final Optional<Integer> sampleWeight;
        private boolean closed;

        public TopNOperatorFactory(int operatorId, int n, List<ProjectionFunction> projections, Ordering<TupleReadable[]> ordering, Optional<Integer> sampleWeight, boolean partial) {
            this.operatorId = operatorId;
            this.n = n;
            this.projections = projections;
            this.ordering = ordering;
            this.partial = partial;
            this.sampleWeight = sampleWeight;
            this.tupleInfos = TopNOperator.toTupleInfos(projections);
        }

        @Override
        public List<TupleInfo> getTupleInfos() {
            return this.tupleInfos;
        }

        @Override
        public Operator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, TopNOperator.class.getSimpleName());
            return new TopNOperator(operatorContext, this.n, this.projections, this.ordering, this.sampleWeight, this.partial);
        }

        @Override
        public void close() {
            this.closed = true;
        }
    }
}

