/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.block.Block;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.operator.Page;
import com.facebook.presto.tuple.TupleInfo;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Iterator;
import java.util.List;

public class ValuesOperator
implements Operator {
    private final OperatorContext operatorContext;
    private final ImmutableList<TupleInfo> tupleInfos;
    private final Iterator<Page> pages;

    public ValuesOperator(OperatorContext operatorContext, List<Page> pages) {
        this.operatorContext = (OperatorContext)Preconditions.checkNotNull((Object)operatorContext, (Object)"operatorContext is null");
        Preconditions.checkNotNull(pages, (Object)"pages is null");
        Preconditions.checkArgument((!pages.isEmpty() ? 1 : 0) != 0, (Object)"pages is empty");
        this.tupleInfos = ValuesOperator.extractTupleInfos(pages);
        this.pages = ImmutableList.copyOf(pages).iterator();
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public List<TupleInfo> getTupleInfos() {
        return this.tupleInfos;
    }

    @Override
    public void finish() {
        Iterators.size(this.pages);
    }

    @Override
    public boolean isFinished() {
        return !this.pages.hasNext();
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        return NOT_BLOCKED;
    }

    @Override
    public boolean needsInput() {
        return false;
    }

    @Override
    public void addInput(Page page) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Page getOutput() {
        if (!this.pages.hasNext()) {
            return null;
        }
        Page page = this.pages.next();
        if (page != null) {
            this.operatorContext.recordGeneratedInput(page.getDataSize(), page.getPositionCount());
        }
        return page;
    }

    private static ImmutableList<TupleInfo> extractTupleInfos(List<Page> pages) {
        ImmutableList.Builder tupleInfos = ImmutableList.builder();
        for (Block block : pages.get(0).getBlocks()) {
            tupleInfos.add((Object)block.getTupleInfo());
        }
        return tupleInfos.build();
    }

    public static class ValuesOperatorFactory
    implements OperatorFactory {
        private final int operatorId;
        private final List<TupleInfo> tupleInfos;
        private final List<Page> pages;
        private boolean closed;

        public ValuesOperatorFactory(int operatorId, List<Page> pages) {
            this.operatorId = operatorId;
            this.tupleInfos = ValuesOperator.extractTupleInfos(pages);
            this.pages = pages;
        }

        @Override
        public List<TupleInfo> getTupleInfos() {
            return this.tupleInfos;
        }

        @Override
        public Operator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, ValuesOperator.class.getSimpleName());
            return new ValuesOperator(operatorContext, this.pages);
        }

        @Override
        public void close() {
            this.closed = true;
        }
    }
}

