/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.operator.Page;
import com.facebook.presto.operator.PageBuilder;
import com.facebook.presto.operator.PagesIndex;
import com.facebook.presto.operator.SortOrder;
import com.facebook.presto.operator.window.WindowFunction;
import com.facebook.presto.tuple.TupleInfo;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ObjectArrays;
import com.google.common.primitives.Ints;
import com.google.common.util.concurrent.ListenableFuture;
import it.unimi.dsi.fastutil.ints.IntComparator;
import java.util.Arrays;
import java.util.List;

public class WindowOperator
implements Operator {
    private final OperatorContext operatorContext;
    private final int[] outputChannels;
    private final List<WindowFunction> windowFunctions;
    private final int[] partitionChannels;
    private final int[] sortChannels;
    private final SortOrder[] sortOrder;
    private final List<TupleInfo> tupleInfos;
    private final PagesIndex pageIndex;
    private final PageBuilder pageBuilder;
    private State state = State.NEEDS_INPUT;
    private int currentPosition;
    private IntComparator partitionComparator;
    private IntComparator orderComparator;
    private int partitionEnd;
    private int peerGroupEnd;
    private int peerGroupCount;

    public WindowOperator(OperatorContext operatorContext, List<TupleInfo> sourceTupleInfos, int[] outputChannels, List<WindowFunction> windowFunctions, int[] partitionChannels, int[] sortChannels, SortOrder[] sortOrder, int expectedPositions) {
        this.operatorContext = (OperatorContext)Preconditions.checkNotNull((Object)operatorContext, (Object)"operatorContext is null");
        this.outputChannels = (int[])((int[])Preconditions.checkNotNull((Object)outputChannels, (Object)"outputChannels is null")).clone();
        this.windowFunctions = (List)Preconditions.checkNotNull(windowFunctions, (Object)"windowFunctions is null");
        this.partitionChannels = (int[])((int[])Preconditions.checkNotNull((Object)partitionChannels, (Object)"partitionChannels is null")).clone();
        this.sortChannels = (int[])Preconditions.checkNotNull((Object)sortChannels, (Object)"sortChannels is null");
        this.sortOrder = (SortOrder[])((SortOrder[])Preconditions.checkNotNull((Object)sortOrder, (Object)"sortOrder is null")).clone();
        this.tupleInfos = WindowOperator.toTupleInfos(sourceTupleInfos, outputChannels, windowFunctions);
        this.pageIndex = new PagesIndex(sourceTupleInfos, expectedPositions, operatorContext);
        this.pageBuilder = new PageBuilder(this.tupleInfos);
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public List<TupleInfo> getTupleInfos() {
        return this.tupleInfos;
    }

    @Override
    public void finish() {
        if (this.state == State.NEEDS_INPUT) {
            this.state = State.HAS_OUTPUT;
            int[] orderChannels = Ints.concat((int[][])new int[][]{this.partitionChannels, this.sortChannels});
            SortOrder[] partitionOrder = new SortOrder[this.partitionChannels.length];
            Arrays.fill((Object[])partitionOrder, (Object)SortOrder.ASC_NULLS_LAST);
            SortOrder[] ordering = (SortOrder[])ObjectArrays.concat((Object[])partitionOrder, (Object[])this.sortOrder, SortOrder.class);
            this.pageIndex.sort(orderChannels, ordering);
            this.partitionComparator = new PagesIndex.MultiSliceFieldOrderedTupleComparator(this.pageIndex, this.partitionChannels, partitionOrder);
            this.orderComparator = new PagesIndex.MultiSliceFieldOrderedTupleComparator(this.pageIndex, this.sortChannels, this.sortOrder);
        }
    }

    @Override
    public boolean isFinished() {
        return this.state == State.FINISHED;
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        return NOT_BLOCKED;
    }

    @Override
    public boolean needsInput() {
        return this.state == State.NEEDS_INPUT;
    }

    @Override
    public void addInput(Page page) {
        Preconditions.checkState((this.state == State.NEEDS_INPUT ? 1 : 0) != 0, (Object)"Operator is already finishing");
        Preconditions.checkNotNull((Object)page, (Object)"page is null");
        this.pageIndex.addPage(page);
    }

    @Override
    public Page getOutput() {
        if (this.state != State.HAS_OUTPUT) {
            return null;
        }
        if (this.currentPosition >= this.pageIndex.getPositionCount()) {
            this.state = State.FINISHED;
            return null;
        }
        this.pageBuilder.reset();
        while (!this.pageBuilder.isFull() && this.currentPosition < this.pageIndex.getPositionCount()) {
            boolean newPeerGroup;
            int channel;
            boolean newPartition;
            boolean bl = newPartition = this.currentPosition == 0 || this.currentPosition == this.partitionEnd;
            if (newPartition) {
                ++this.partitionEnd;
                while (this.partitionEnd < this.pageIndex.getPositionCount() && this.partitionComparator.compare(this.partitionEnd - 1, this.partitionEnd) == 0) {
                    ++this.partitionEnd;
                }
                for (WindowFunction function : this.windowFunctions) {
                    function.reset(this.partitionEnd - this.currentPosition);
                }
            }
            for (channel = 0; channel < this.outputChannels.length; ++channel) {
                this.pageIndex.appendTupleTo(this.outputChannels[channel], this.currentPosition, this.pageBuilder.getBlockBuilder(channel));
            }
            boolean bl2 = newPeerGroup = newPartition || this.currentPosition == this.peerGroupEnd;
            if (newPeerGroup) {
                ++this.peerGroupEnd;
                while (this.peerGroupEnd < this.partitionEnd && this.orderComparator.compare(this.peerGroupEnd - 1, this.peerGroupEnd) == 0) {
                    ++this.peerGroupEnd;
                }
                this.peerGroupCount = this.peerGroupEnd - this.currentPosition;
            }
            for (WindowFunction function : this.windowFunctions) {
                function.processRow(this.pageBuilder.getBlockBuilder(channel), newPeerGroup, this.peerGroupCount);
                ++channel;
            }
            ++this.currentPosition;
        }
        if (this.pageBuilder.isEmpty()) {
            this.state = State.FINISHED;
            return null;
        }
        Page page = this.pageBuilder.build();
        return page;
    }

    private static List<TupleInfo> toTupleInfos(List<TupleInfo> sourceTupleInfos, int[] outputChannels, List<WindowFunction> windowFunctions) {
        ImmutableList.Builder tupleInfosBuilder = ImmutableList.builder();
        for (int channel : outputChannels) {
            tupleInfosBuilder.add((Object)sourceTupleInfos.get(channel));
        }
        for (WindowFunction function : windowFunctions) {
            tupleInfosBuilder.add((Object)function.getTupleInfo());
        }
        return tupleInfosBuilder.build();
    }

    private static enum State {
        NEEDS_INPUT,
        HAS_OUTPUT,
        FINISHED;

    }

    public static class WindowOperatorFactory
    implements OperatorFactory {
        private final int operatorId;
        private final List<TupleInfo> sourceTupleInfos;
        private final int[] outputChannels;
        private final List<WindowFunction> windowFunctions;
        private final int[] partitionChannels;
        private final int[] sortChannels;
        private final SortOrder[] sortOrder;
        private final int expectedPositions;
        private final List<TupleInfo> tupleInfos;
        private boolean closed;

        public WindowOperatorFactory(int operatorId, List<TupleInfo> sourceTupleInfos, int[] outputChannels, List<WindowFunction> windowFunctions, int[] partitionChannels, int[] sortChannels, SortOrder[] sortOrder, int expectedPositions) {
            this.operatorId = operatorId;
            this.sourceTupleInfos = sourceTupleInfos;
            this.outputChannels = outputChannels;
            this.windowFunctions = windowFunctions;
            this.partitionChannels = partitionChannels;
            this.sortChannels = sortChannels;
            this.sortOrder = sortOrder;
            this.expectedPositions = expectedPositions;
            this.tupleInfos = WindowOperator.toTupleInfos(sourceTupleInfos, outputChannels, windowFunctions);
        }

        @Override
        public List<TupleInfo> getTupleInfos() {
            return this.tupleInfos;
        }

        @Override
        public Operator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, WindowOperator.class.getSimpleName());
            return new WindowOperator(operatorContext, this.sourceTupleInfos, this.outputChannels, this.windowFunctions, this.partitionChannels, this.sortChannels, this.sortOrder, this.expectedPositions);
        }

        @Override
        public void close() {
            this.closed = true;
        }
    }
}

