/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.block.Block;
import com.facebook.presto.block.BlockBuilder;
import com.facebook.presto.block.BlockCursor;
import com.facebook.presto.operator.GroupByIdBlock;
import com.facebook.presto.operator.aggregation.Accumulator;
import com.facebook.presto.operator.aggregation.ApproximateUtils;
import com.facebook.presto.operator.aggregation.GroupedAccumulator;
import com.facebook.presto.operator.aggregation.SimpleAggregationFunction;
import com.facebook.presto.operator.aggregation.VarianceAggregation;
import com.facebook.presto.tuple.TupleInfo;
import com.facebook.presto.util.array.DoubleBigArray;
import com.facebook.presto.util.array.LongBigArray;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import io.airlift.slice.Slice;

public class ApproximateAverageAggregation
extends SimpleAggregationFunction {
    private final boolean inputIsLong;

    public ApproximateAverageAggregation(TupleInfo.Type parameterType) {
        super(TupleInfo.SINGLE_VARBINARY, TupleInfo.SINGLE_VARBINARY, parameterType);
        if (parameterType == TupleInfo.Type.FIXED_INT_64) {
            this.inputIsLong = true;
        } else if (parameterType == TupleInfo.Type.DOUBLE) {
            this.inputIsLong = false;
        } else {
            throw new IllegalArgumentException("Expected parameter type to be FIXED_INT_64 or DOUBLE, but was " + parameterType);
        }
    }

    @Override
    protected GroupedAccumulator createGroupedAccumulator(Optional<Integer> maskChannel, Optional<Integer> sampleWeightChannel, double confidence, int valueChannel) {
        return new ApproximateAverageGroupedAccumulator(valueChannel, this.inputIsLong, maskChannel, sampleWeightChannel, confidence);
    }

    @Override
    protected Accumulator createAccumulator(Optional<Integer> maskChannel, Optional<Integer> sampleWeightChannel, double confidence, int valueChannel) {
        return new ApproximateAverageAccumulator(valueChannel, this.inputIsLong, maskChannel, sampleWeightChannel, confidence);
    }

    private static String formatApproximateAverage(long count, double mean, double variance, double confidence) {
        return ApproximateUtils.formatApproximateResult(mean, Math.sqrt(variance / (double)count), confidence, false);
    }

    public static class ApproximateAverageAccumulator
    extends SimpleAggregationFunction.SimpleAccumulator {
        private final boolean inputIsLong;
        private final double confidence;
        private long currentCount;
        private double currentMean;
        private double currentM2;

        private ApproximateAverageAccumulator(int valueChannel, boolean inputIsLong, Optional<Integer> maskChannel, Optional<Integer> sampleWeightChannel, double confidence) {
            super(valueChannel, TupleInfo.SINGLE_VARBINARY, TupleInfo.SINGLE_VARBINARY, maskChannel, sampleWeightChannel);
            this.inputIsLong = inputIsLong;
            this.confidence = confidence;
        }

        @Override
        protected void processInput(Block block, Optional<Block> maskBlock, Optional<Block> sampleWeightBlock) {
            BlockCursor values = block.cursor();
            BlockCursor masks = null;
            if (maskBlock.isPresent()) {
                masks = ((Block)maskBlock.get()).cursor();
            }
            BlockCursor sampleWeights = null;
            if (sampleWeightBlock.isPresent()) {
                sampleWeights = ((Block)sampleWeightBlock.get()).cursor();
            }
            for (int position = 0; position < block.getPositionCount(); ++position) {
                Preconditions.checkState((boolean)values.advanceNextPosition());
                Preconditions.checkState((masks == null || masks.advanceNextPosition() ? 1 : 0) != 0);
                Preconditions.checkState((sampleWeights == null || sampleWeights.advanceNextPosition() ? 1 : 0) != 0);
                long sampleWeight = SimpleAggregationFunction.computeSampleWeight(masks, sampleWeights);
                if (values.isNull() || sampleWeight <= 0L) continue;
                double inputValue = this.inputIsLong ? (double)values.getLong() : values.getDouble();
                int i = 0;
                while ((long)i < sampleWeight) {
                    ++this.currentCount;
                    double delta = inputValue - this.currentMean;
                    this.currentMean += delta / (double)this.currentCount;
                    this.currentM2 += delta * (inputValue - this.currentMean);
                    ++i;
                }
            }
            Preconditions.checkState((!values.advanceNextPosition() ? 1 : 0) != 0);
        }

        @Override
        protected void processIntermediate(Block block) {
            BlockCursor values = block.cursor();
            for (int position = 0; position < block.getPositionCount(); ++position) {
                Preconditions.checkState((boolean)values.advanceNextPosition());
                if (values.isNull()) continue;
                Slice slice = values.getSlice();
                long inputCount = VarianceAggregation.getCount(slice);
                double inputMean = VarianceAggregation.getMean(slice);
                double inputM2 = VarianceAggregation.getM2(slice);
                if (inputCount <= 0L) continue;
                long newCount = this.currentCount + inputCount;
                double newMean = ((double)this.currentCount * this.currentMean + (double)inputCount * inputMean) / (double)newCount;
                double delta = inputMean - this.currentMean;
                double newM2 = this.currentM2 + inputM2 + delta * delta * (double)(this.currentCount * inputCount) / (double)newCount;
                this.currentCount = newCount;
                this.currentMean = newMean;
                this.currentM2 = newM2;
            }
            Preconditions.checkState((!values.advanceNextPosition() ? 1 : 0) != 0);
        }

        @Override
        public void evaluateIntermediate(BlockBuilder output) {
            output.append(VarianceAggregation.createIntermediate(this.currentCount, this.currentMean, this.currentM2));
        }

        @Override
        public void evaluateFinal(BlockBuilder output) {
            if (this.currentCount == 0L) {
                output.appendNull();
            } else {
                String result = ApproximateAverageAggregation.formatApproximateAverage(this.currentCount, this.currentMean, this.currentM2 / (double)this.currentCount, this.confidence);
                output.append(result);
            }
        }
    }

    public static class ApproximateAverageGroupedAccumulator
    extends SimpleAggregationFunction.SimpleGroupedAccumulator {
        private final boolean inputIsLong;
        private final double confidence;
        private final LongBigArray counts;
        private final DoubleBigArray means;
        private final DoubleBigArray m2s;

        private ApproximateAverageGroupedAccumulator(int valueChannel, boolean inputIsLong, Optional<Integer> maskChannel, Optional<Integer> sampleWeightChannel, double confidence) {
            super(valueChannel, TupleInfo.SINGLE_VARBINARY, TupleInfo.SINGLE_VARBINARY, maskChannel, sampleWeightChannel);
            this.inputIsLong = inputIsLong;
            this.confidence = confidence;
            this.counts = new LongBigArray();
            this.means = new DoubleBigArray();
            this.m2s = new DoubleBigArray();
        }

        @Override
        public long getEstimatedSize() {
            return this.counts.sizeOf() + this.means.sizeOf() + this.m2s.sizeOf();
        }

        @Override
        protected void processInput(GroupByIdBlock groupIdsBlock, Block valuesBlock, Optional<Block> maskBlock, Optional<Block> sampleWeightBlock) {
            this.counts.ensureCapacity(groupIdsBlock.getGroupCount());
            this.means.ensureCapacity(groupIdsBlock.getGroupCount());
            this.m2s.ensureCapacity(groupIdsBlock.getGroupCount());
            BlockCursor values = valuesBlock.cursor();
            BlockCursor masks = null;
            if (maskBlock.isPresent()) {
                masks = ((Block)maskBlock.get()).cursor();
            }
            BlockCursor sampleWeights = null;
            if (sampleWeightBlock.isPresent()) {
                sampleWeights = ((Block)sampleWeightBlock.get()).cursor();
            }
            for (int position = 0; position < groupIdsBlock.getPositionCount(); ++position) {
                Preconditions.checkState((boolean)values.advanceNextPosition());
                Preconditions.checkState((masks == null || masks.advanceNextPosition() ? 1 : 0) != 0);
                Preconditions.checkState((sampleWeights == null || sampleWeights.advanceNextPosition() ? 1 : 0) != 0);
                long sampleWeight = SimpleAggregationFunction.computeSampleWeight(masks, sampleWeights);
                if (values.isNull() || sampleWeight <= 0L) continue;
                long groupId = groupIdsBlock.getGroupId(position);
                double inputValue = this.inputIsLong ? (double)values.getLong() : values.getDouble();
                long currentCount = this.counts.get(groupId);
                double currentMean = this.means.get(groupId);
                int i = 0;
                while ((long)i < sampleWeight) {
                    double delta = inputValue - currentMean;
                    this.m2s.add(groupId, delta * (inputValue - (currentMean += delta / (double)(++currentCount))));
                    ++i;
                }
                this.counts.set(groupId, currentCount);
                this.means.set(groupId, currentMean);
            }
            Preconditions.checkState((!values.advanceNextPosition() ? 1 : 0) != 0);
        }

        @Override
        protected void processIntermediate(GroupByIdBlock groupIdsBlock, Block valuesBlock) {
            this.counts.ensureCapacity(groupIdsBlock.getGroupCount());
            this.means.ensureCapacity(groupIdsBlock.getGroupCount());
            this.m2s.ensureCapacity(groupIdsBlock.getGroupCount());
            BlockCursor values = valuesBlock.cursor();
            for (int position = 0; position < groupIdsBlock.getPositionCount(); ++position) {
                Preconditions.checkState((boolean)values.advanceNextPosition());
                if (values.isNull()) continue;
                long groupId = groupIdsBlock.getGroupId(position);
                Slice slice = values.getSlice();
                long inputCount = VarianceAggregation.getCount(slice);
                double inputMean = VarianceAggregation.getMean(slice);
                double inputM2 = VarianceAggregation.getM2(slice);
                long currentCount = this.counts.get(groupId);
                double currentMean = this.means.get(groupId);
                double currentM2 = this.m2s.get(groupId);
                if (inputCount <= 0L) continue;
                long newCount = currentCount + inputCount;
                double newMean = ((double)currentCount * currentMean + (double)inputCount * inputMean) / (double)newCount;
                double delta = inputMean - currentMean;
                double newM2 = currentM2 + inputM2 + delta * delta * (double)(currentCount * inputCount) / (double)newCount;
                this.counts.set(groupId, newCount);
                this.means.set(groupId, newMean);
                this.m2s.set(groupId, newM2);
            }
            Preconditions.checkState((!values.advanceNextPosition() ? 1 : 0) != 0);
        }

        @Override
        public void evaluateIntermediate(int groupId, BlockBuilder output) {
            long count = this.counts.get(groupId);
            double mean = this.means.get(groupId);
            double m2 = this.m2s.get(groupId);
            output.append(VarianceAggregation.createIntermediate(count, mean, m2));
        }

        @Override
        public void evaluateFinal(int groupId, BlockBuilder output) {
            long count = this.counts.get(groupId);
            if (count == 0L) {
                output.appendNull();
            } else {
                double mean = this.means.get(groupId);
                double m2 = this.m2s.get(groupId);
                double variance = m2 / (double)count;
                String result = ApproximateAverageAggregation.formatApproximateAverage(count, mean, variance, this.confidence);
                output.append(result);
            }
        }
    }
}

