/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.block.Block;
import com.facebook.presto.block.BlockBuilder;
import com.facebook.presto.block.BlockCursor;
import com.facebook.presto.operator.GroupByIdBlock;
import com.facebook.presto.operator.Page;
import com.facebook.presto.operator.aggregation.Accumulator;
import com.facebook.presto.operator.aggregation.AggregationFunction;
import com.facebook.presto.operator.aggregation.ApproximateUtils;
import com.facebook.presto.operator.aggregation.GroupedAccumulator;
import com.facebook.presto.operator.aggregation.SimpleAggregationFunction;
import com.facebook.presto.tuple.TupleInfo;
import com.facebook.presto.util.array.LongBigArray;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.util.List;

public class ApproximateCountAggregation
implements AggregationFunction {
    public static final ApproximateCountAggregation APPROXIMATE_COUNT_AGGREGATION = new ApproximateCountAggregation();
    private static final int COUNT_OFFSET = 0;
    private static final int SAMPLES_OFFSET = 8;

    @Override
    public List<TupleInfo.Type> getParameterTypes() {
        return ImmutableList.of();
    }

    @Override
    public TupleInfo getFinalTupleInfo() {
        return TupleInfo.SINGLE_VARBINARY;
    }

    @Override
    public TupleInfo getIntermediateTupleInfo() {
        return TupleInfo.SINGLE_VARBINARY;
    }

    @Override
    public boolean isDecomposable() {
        return true;
    }

    @Override
    public ApproximateCountGroupedAccumulator createGroupedAggregation(Optional<Integer> maskChannel, Optional<Integer> sampleWeightChannel, double confidence, int[] argumentChannels) {
        Preconditions.checkArgument((boolean)sampleWeightChannel.isPresent(), (Object)"sampleWeightChannel missing");
        return new ApproximateCountGroupedAccumulator(maskChannel, (Integer)sampleWeightChannel.get(), confidence);
    }

    @Override
    public GroupedAccumulator createGroupedIntermediateAggregation(double confidence) {
        return new ApproximateCountGroupedAccumulator((Optional<Integer>)Optional.absent(), -1, confidence);
    }

    @Override
    public CountAccumulator createAggregation(Optional<Integer> maskChannel, Optional<Integer> sampleWeightChannel, double confidence, int ... argumentChannels) {
        Preconditions.checkArgument((boolean)sampleWeightChannel.isPresent(), (Object)"sampleWeightChannel is missing");
        return new CountAccumulator(maskChannel, (Integer)sampleWeightChannel.get(), confidence);
    }

    @Override
    public CountAccumulator createIntermediateAggregation(double confidence) {
        return new CountAccumulator((Optional<Integer>)Optional.absent(), -1, confidence);
    }

    public static Slice createIntermediate(long count, long samples) {
        Slice slice = Slices.allocate((int)16);
        slice.setLong(0, count);
        slice.setLong(8, samples);
        return slice;
    }

    public static class CountAccumulator
    implements Accumulator {
        private long count;
        private long samples;
        private final Optional<Integer> maskChannel;
        private final int sampleWeightChannel;
        private final double confidence;

        public CountAccumulator(Optional<Integer> maskChannel, int sampleWeightChannel, double confidence) {
            this.maskChannel = maskChannel;
            this.sampleWeightChannel = sampleWeightChannel;
            this.confidence = confidence;
        }

        @Override
        public TupleInfo getFinalTupleInfo() {
            return TupleInfo.SINGLE_VARBINARY;
        }

        @Override
        public TupleInfo getIntermediateTupleInfo() {
            return TupleInfo.SINGLE_VARBINARY;
        }

        @Override
        public void addInput(Page page) {
            BlockCursor masks = null;
            if (this.maskChannel.isPresent()) {
                masks = page.getBlock((Integer)this.maskChannel.get()).cursor();
            }
            BlockCursor sampleWeights = page.getBlock(this.sampleWeightChannel).cursor();
            for (int i = 0; i < page.getPositionCount(); ++i) {
                Preconditions.checkState((masks == null || masks.advanceNextPosition() ? 1 : 0) != 0, (Object)"failed to advance mask cursor");
                Preconditions.checkState((boolean)sampleWeights.advanceNextPosition(), (Object)"failed to advance weight cursor");
                long weight = SimpleAggregationFunction.computeSampleWeight(masks, sampleWeights);
                this.count += weight;
                if (weight <= 0L) continue;
                ++this.samples;
            }
        }

        @Override
        public void addIntermediate(Block block) {
            BlockCursor intermediates = block.cursor();
            for (int position = 0; position < block.getPositionCount(); ++position) {
                Preconditions.checkState((boolean)intermediates.advanceNextPosition(), (Object)"failed to advance intermediates cursor");
                Slice slice = intermediates.getSlice();
                this.count += slice.getLong(0);
                this.samples += slice.getLong(8);
            }
        }

        @Override
        public final Block evaluateIntermediate() {
            return new BlockBuilder(TupleInfo.SINGLE_VARBINARY).append(ApproximateCountAggregation.createIntermediate(this.count, this.samples)).build();
        }

        @Override
        public final Block evaluateFinal() {
            return new BlockBuilder(this.getFinalTupleInfo()).append(ApproximateUtils.formatApproximateResult(this.count, ApproximateUtils.countError(this.samples, this.count), this.confidence, true)).build();
        }
    }

    public static class ApproximateCountGroupedAccumulator
    implements GroupedAccumulator {
        private final LongBigArray counts = new LongBigArray();
        private final LongBigArray samples = new LongBigArray();
        private final Optional<Integer> maskChannel;
        private final int sampleWeightChannel;
        private final double confidence;

        public ApproximateCountGroupedAccumulator(Optional<Integer> maskChannel, int sampleWeightChannel, double confidence) {
            this.maskChannel = maskChannel;
            this.sampleWeightChannel = sampleWeightChannel;
            this.confidence = confidence;
        }

        @Override
        public long getEstimatedSize() {
            return this.counts.sizeOf() + this.samples.sizeOf();
        }

        @Override
        public TupleInfo getFinalTupleInfo() {
            return TupleInfo.SINGLE_VARBINARY;
        }

        @Override
        public TupleInfo getIntermediateTupleInfo() {
            return TupleInfo.SINGLE_VARBINARY;
        }

        @Override
        public void addInput(GroupByIdBlock groupIdsBlock, Page page) {
            this.counts.ensureCapacity(groupIdsBlock.getGroupCount());
            this.samples.ensureCapacity(groupIdsBlock.getGroupCount());
            BlockCursor masks = null;
            if (this.maskChannel.isPresent()) {
                masks = page.getBlock((Integer)this.maskChannel.get()).cursor();
            }
            BlockCursor sampleWeights = page.getBlock(this.sampleWeightChannel).cursor();
            for (int position = 0; position < groupIdsBlock.getPositionCount(); ++position) {
                long groupId = groupIdsBlock.getGroupId(position);
                Preconditions.checkState((masks == null || masks.advanceNextPosition() ? 1 : 0) != 0, (Object)"failed to advance mask cursor");
                Preconditions.checkState((boolean)sampleWeights.advanceNextPosition(), (Object)"failed to advance weight cursor");
                long weight = SimpleAggregationFunction.computeSampleWeight(masks, sampleWeights);
                this.counts.add(groupId, weight);
                if (weight <= 0L) continue;
                this.samples.increment(groupId);
            }
        }

        @Override
        public void addIntermediate(GroupByIdBlock groupIdsBlock, Block block) {
            this.counts.ensureCapacity(groupIdsBlock.getGroupCount());
            this.samples.ensureCapacity(groupIdsBlock.getGroupCount());
            BlockCursor intermediates = block.cursor();
            for (int position = 0; position < groupIdsBlock.getPositionCount(); ++position) {
                Preconditions.checkState((boolean)intermediates.advanceNextPosition(), (Object)"failed to advance intermediates cursor");
                long groupId = groupIdsBlock.getGroupId(position);
                Slice slice = intermediates.getSlice();
                this.counts.add(groupId, slice.getLong(0));
                this.samples.add(groupId, slice.getLong(8));
            }
        }

        @Override
        public void evaluateIntermediate(int groupId, BlockBuilder output) {
            output.append(ApproximateCountAggregation.createIntermediate(this.counts.get(groupId), this.samples.get(groupId)));
        }

        @Override
        public void evaluateFinal(int groupId, BlockBuilder output) {
            long count = this.counts.get(groupId);
            long samples = this.samples.get(groupId);
            output.append(ApproximateUtils.formatApproximateResult(count, ApproximateUtils.countError(samples, count), this.confidence, true));
        }
    }
}

