/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.block.Block;
import com.facebook.presto.block.BlockBuilder;
import com.facebook.presto.block.BlockCursor;
import com.facebook.presto.operator.GroupByIdBlock;
import com.facebook.presto.operator.aggregation.Accumulator;
import com.facebook.presto.operator.aggregation.GroupedAccumulator;
import com.facebook.presto.operator.aggregation.HyperLogLog;
import com.facebook.presto.operator.aggregation.SimpleAggregationFunction;
import com.facebook.presto.tuple.TupleInfo;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import io.airlift.slice.Murmur3;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.util.ArrayList;
import java.util.List;

public class ApproximateCountDistinctAggregation
extends SimpleAggregationFunction {
    private static final HyperLogLog ESTIMATOR = new HyperLogLog(2048);
    private static final int ENTRY_SIZE = 1 + ESTIMATOR.getSizeInBytes();
    private static final int SLICE_SIZE = Math.max(ENTRY_SIZE, Ints.checkedCast((long)(BlockBuilder.DEFAULT_MAX_BLOCK_SIZE.toBytes() / (long)ENTRY_SIZE * (long)ENTRY_SIZE)));
    private static final int ENTRIES_PER_SLICE = SLICE_SIZE / ENTRY_SIZE;
    private final TupleInfo.Type parameterType;

    public ApproximateCountDistinctAggregation(TupleInfo.Type parameterType) {
        super(TupleInfo.SINGLE_LONG, TupleInfo.SINGLE_VARBINARY, parameterType);
        Preconditions.checkArgument((parameterType == TupleInfo.Type.FIXED_INT_64 || parameterType == TupleInfo.Type.DOUBLE || parameterType == TupleInfo.Type.VARIABLE_BINARY ? 1 : 0) != 0, (String)"Expected parameter type to be FIXED_INT_64, DOUBLE, or VARIABLE_BINARY, but was %s", (Object[])new Object[]{parameterType});
        this.parameterType = parameterType;
    }

    @Override
    protected GroupedAccumulator createGroupedAccumulator(Optional<Integer> maskChannel, Optional<Integer> sampleWeightChannel, double confidence, int valueChannel) {
        Preconditions.checkArgument((confidence == 1.0 ? 1 : 0) != 0, (Object)"approximate count distinct does not support approximate queries");
        return new ApproximateCountDistinctGroupedAccumulator(this.parameterType, valueChannel, maskChannel);
    }

    @Override
    protected Accumulator createAccumulator(Optional<Integer> maskChannel, Optional<Integer> sampleWeightChannel, double confidence, int valueChannel) {
        Preconditions.checkArgument((confidence == 1.0 ? 1 : 0) != 0, (Object)"approximate count distinct does not support approximate queries");
        return new ApproximateCountDistinctAccumulator(this.parameterType, valueChannel, maskChannel);
    }

    public static double getStandardError() {
        return ESTIMATOR.getStandardError();
    }

    private static boolean isNull(Slice valueSlice, int offset) {
        return valueSlice.getByte(offset) == 0;
    }

    private static void setNotNull(Slice valueSlice, int offset) {
        valueSlice.setByte(offset, 1);
    }

    private static long hash(BlockCursor values, TupleInfo.Type parameterType) {
        if (parameterType == TupleInfo.Type.FIXED_INT_64) {
            long value = values.getLong();
            return Murmur3.hash64((long)value);
        }
        if (parameterType == TupleInfo.Type.DOUBLE) {
            double value = values.getDouble();
            return Murmur3.hash64((long)Double.doubleToLongBits(value));
        }
        if (parameterType == TupleInfo.Type.VARIABLE_BINARY) {
            return Murmur3.hash64((Slice)values.getSlice());
        }
        throw new IllegalArgumentException("Expected parameter type to be FIXED_INT_64, DOUBLE, or VARIABLE_BINARY");
    }

    public static class ApproximateCountDistinctAccumulator
    extends SimpleAggregationFunction.SimpleAccumulator {
        private final TupleInfo.Type parameterType;
        private final Slice slice = Slices.allocate((int)ApproximateCountDistinctAggregation.access$100());
        private boolean notNull;

        public ApproximateCountDistinctAccumulator(TupleInfo.Type parameterType, int valueChannel, Optional<Integer> maskChannel) {
            super(valueChannel, TupleInfo.SINGLE_LONG, TupleInfo.SINGLE_VARBINARY, maskChannel, (Optional<Integer>)Optional.absent());
            this.parameterType = parameterType;
        }

        @Override
        protected void processInput(Block block, Optional<Block> maskBlock, Optional<Block> sampleWeightBlock) {
            BlockCursor values = block.cursor();
            BlockCursor masks = null;
            if (maskBlock.isPresent()) {
                masks = ((Block)maskBlock.get()).cursor();
            }
            for (int position = 0; position < block.getPositionCount(); ++position) {
                Preconditions.checkState((boolean)values.advanceNextPosition());
                Preconditions.checkState((masks == null || masks.advanceNextPosition() ? 1 : 0) != 0);
                if (values.isNull() || masks != null && !masks.getBoolean()) continue;
                this.notNull = true;
                long hash = ApproximateCountDistinctAggregation.hash(values, this.parameterType);
                ESTIMATOR.update(hash, this.slice, 0);
            }
        }

        @Override
        protected void processIntermediate(Block block) {
            BlockCursor intermediates = block.cursor();
            for (int position = 0; position < block.getPositionCount(); ++position) {
                Preconditions.checkState((boolean)intermediates.advanceNextPosition());
                if (intermediates.isNull()) continue;
                this.notNull = true;
                Slice input = intermediates.getSlice();
                ESTIMATOR.mergeInto(this.slice, 0, input, 0);
            }
        }

        @Override
        public void evaluateIntermediate(BlockBuilder out) {
            if (this.notNull) {
                out.append(this.slice);
            } else {
                out.appendNull();
            }
        }

        @Override
        public void evaluateFinal(BlockBuilder out) {
            if (this.notNull) {
                out.append(ESTIMATOR.estimate(this.slice, 0));
            } else {
                out.append(0L);
            }
        }
    }

    public static class ApproximateCountDistinctGroupedAccumulator
    extends SimpleAggregationFunction.SimpleGroupedAccumulator {
        private final TupleInfo.Type parameterType;
        private final List<Slice> slices = new ArrayList<Slice>();

        public ApproximateCountDistinctGroupedAccumulator(TupleInfo.Type parameterType, int valueChannel, Optional<Integer> maskChannel) {
            super(valueChannel, TupleInfo.SINGLE_LONG, TupleInfo.SINGLE_VARBINARY, maskChannel, (Optional<Integer>)Optional.absent());
            this.parameterType = parameterType;
        }

        @Override
        public long getEstimatedSize() {
            return this.slices.size() * SLICE_SIZE;
        }

        @Override
        protected void processInput(GroupByIdBlock groupIdsBlock, Block valuesBlock, Optional<Block> maskBlock, Optional<Block> sampleWeightBlock) {
            this.ensureCapacity(groupIdsBlock.getGroupCount());
            BlockCursor values = valuesBlock.cursor();
            BlockCursor masks = null;
            if (maskBlock.isPresent()) {
                masks = ((Block)maskBlock.get()).cursor();
            }
            for (int position = 0; position < groupIdsBlock.getPositionCount(); ++position) {
                Preconditions.checkState((boolean)values.advanceNextPosition());
                Preconditions.checkState((masks == null || masks.advanceNextPosition() ? 1 : 0) != 0);
                if (values.isNull() || masks != null && !masks.getBoolean()) continue;
                long groupId = groupIdsBlock.getGroupId(position);
                long globalOffset = groupId * (long)ENTRY_SIZE;
                int sliceIndex = Ints.checkedCast((long)(globalOffset / (long)SLICE_SIZE));
                Slice slice = this.slices.get(sliceIndex);
                int sliceOffset = Ints.checkedCast((long)(globalOffset - (long)(sliceIndex * SLICE_SIZE)));
                long hash = ApproximateCountDistinctAggregation.hash(values, this.parameterType);
                ESTIMATOR.update(hash, slice, sliceOffset + 1);
                ApproximateCountDistinctAggregation.setNotNull(slice, sliceOffset);
            }
            Preconditions.checkState((!values.advanceNextPosition() ? 1 : 0) != 0);
        }

        @Override
        protected void processIntermediate(GroupByIdBlock groupIdsBlock, Block valuesBlock) {
            this.ensureCapacity(groupIdsBlock.getGroupCount());
            BlockCursor intermediates = valuesBlock.cursor();
            for (int position = 0; position < groupIdsBlock.getPositionCount(); ++position) {
                Preconditions.checkState((boolean)intermediates.advanceNextPosition());
                if (intermediates.isNull()) continue;
                long groupId = groupIdsBlock.getGroupId(position);
                long globalOffset = groupId * (long)ENTRY_SIZE;
                int sliceIndex = Ints.checkedCast((long)(globalOffset / (long)SLICE_SIZE));
                Slice slice = this.slices.get(sliceIndex);
                int sliceOffset = Ints.checkedCast((long)(globalOffset - (long)(sliceIndex * SLICE_SIZE)));
                Slice input = intermediates.getSlice();
                ESTIMATOR.mergeInto(slice, sliceOffset + 1, input, 0);
                ApproximateCountDistinctAggregation.setNotNull(slice, sliceOffset);
            }
            Preconditions.checkState((!intermediates.advanceNextPosition() ? 1 : 0) != 0);
        }

        private void ensureCapacity(long groupCount) {
            long neededPages = (groupCount + (long)ENTRIES_PER_SLICE) / (long)ENTRIES_PER_SLICE;
            while ((long)this.slices.size() < neededPages) {
                this.slices.add(Slices.allocate((int)SLICE_SIZE));
            }
        }

        @Override
        public void evaluateIntermediate(int groupId, BlockBuilder output) {
            int valueOffset;
            long globalOffset = groupId * ENTRY_SIZE;
            int sliceIndex = Ints.checkedCast((long)(globalOffset / (long)SLICE_SIZE));
            Slice valueSlice = this.slices.get(sliceIndex);
            if (ApproximateCountDistinctAggregation.isNull(valueSlice, valueOffset = Ints.checkedCast((long)(globalOffset - (long)(sliceIndex * SLICE_SIZE))))) {
                output.appendNull();
            } else {
                Slice intermediate = valueSlice.slice(valueOffset + 1, ESTIMATOR.getSizeInBytes());
                output.append(intermediate);
            }
        }

        @Override
        public void evaluateFinal(int groupId, BlockBuilder output) {
            int valueOffset;
            long globalOffset = groupId * ENTRY_SIZE;
            int sliceIndex = Ints.checkedCast((long)(globalOffset / (long)SLICE_SIZE));
            Slice valueSlice = this.slices.get(sliceIndex);
            if (ApproximateCountDistinctAggregation.isNull(valueSlice, valueOffset = Ints.checkedCast((long)(globalOffset - (long)(sliceIndex * SLICE_SIZE))))) {
                output.append(0L);
            } else {
                output.append(ESTIMATOR.estimate(valueSlice, valueOffset + 1));
            }
        }
    }
}

