/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.block.Block;
import com.facebook.presto.block.BlockBuilder;
import com.facebook.presto.block.BlockCursor;
import com.facebook.presto.operator.GroupByIdBlock;
import com.facebook.presto.operator.aggregation.ApproximateUtils;
import com.facebook.presto.operator.aggregation.SimpleAggregationFunction;
import com.facebook.presto.tuple.TupleInfo;
import com.facebook.presto.util.array.DoubleBigArray;
import com.facebook.presto.util.array.LongBigArray;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;

public class ApproximateLongSumAggregation
extends SimpleAggregationFunction {
    public static final ApproximateLongSumAggregation LONG_APPROXIMATE_SUM_AGGREGATION = new ApproximateLongSumAggregation();
    private static final int COUNT_OFFSET = 0;
    private static final int SAMPLES_OFFSET = 8;
    private static final int SUM_OFFSET = 16;
    private static final int VARIANCE_OFFSET = 24;

    public ApproximateLongSumAggregation() {
        super(TupleInfo.SINGLE_VARBINARY, TupleInfo.SINGLE_VARBINARY, TupleInfo.Type.FIXED_INT_64);
    }

    @Override
    public ApproximateSumGroupedAccumulator createGroupedAccumulator(Optional<Integer> maskChannel, Optional<Integer> sampleWeightChannel, double confidence, int valueChannel) {
        Preconditions.checkArgument((boolean)(sampleWeightChannel.isPresent() ^ valueChannel == -1), (Object)"sampleWeightChannel is missing");
        return new ApproximateSumGroupedAccumulator(valueChannel, maskChannel, sampleWeightChannel, confidence);
    }

    @Override
    public ApproximateSumAccumulator createAccumulator(Optional<Integer> maskChannel, Optional<Integer> sampleWeightChannel, double confidence, int valueChannel) {
        Preconditions.checkArgument((boolean)(sampleWeightChannel.isPresent() ^ valueChannel == -1), (Object)"sampleWeightChannel is missing");
        return new ApproximateSumAccumulator(valueChannel, maskChannel, sampleWeightChannel, confidence);
    }

    public static Slice createIntermediate(long count, long samples, long sum, double variance) {
        Slice slice = Slices.allocate((int)32);
        slice.setLong(0, count);
        slice.setLong(8, samples);
        slice.setLong(16, sum);
        slice.setDouble(24, variance);
        return slice;
    }

    public static class ApproximateSumAccumulator
    extends SimpleAggregationFunction.SimpleAccumulator {
        private long sum;
        private double variance;
        private long count;
        private long samples;
        private final double confidence;

        public ApproximateSumAccumulator(int valueChannel, Optional<Integer> maskChannel, Optional<Integer> sampleWeightChannel, double confidence) {
            super(valueChannel, TupleInfo.SINGLE_VARBINARY, TupleInfo.SINGLE_VARBINARY, maskChannel, sampleWeightChannel);
            this.confidence = confidence;
        }

        @Override
        protected void processInput(Block block, Optional<Block> maskBlock, Optional<Block> sampleWeightBlock) {
            BlockCursor values = block.cursor();
            BlockCursor sampleWeights = ((Block)sampleWeightBlock.get()).cursor();
            BlockCursor masks = null;
            if (maskBlock.isPresent()) {
                masks = ((Block)maskBlock.get()).cursor();
            }
            for (int i = 0; i < block.getPositionCount(); ++i) {
                long weight;
                Preconditions.checkState((masks == null || masks.advanceNextPosition() ? 1 : 0) != 0, (Object)"failed to advance mask cursor");
                Preconditions.checkState((boolean)sampleWeights.advanceNextPosition(), (Object)"failed to advance weight cursor");
                Preconditions.checkState((boolean)values.advanceNextPosition(), (Object)"failed to advance values cursor");
                long l = weight = values.isNull() ? 0L : SimpleAggregationFunction.computeSampleWeight(masks, sampleWeights);
                if (weight > 0L) {
                    ++this.samples;
                }
                if (values.isNull() || weight <= 0L) continue;
                long value = values.getLong();
                int j = 0;
                while ((long)j < weight) {
                    ++this.count;
                    this.sum += value;
                    if (this.count > 1L) {
                        long t = this.count * value - this.sum;
                        this.variance += (double)(t * t) / ((double)this.count * (double)(this.count - 1L));
                    }
                    ++j;
                }
            }
        }

        @Override
        public void processIntermediate(Block block) {
            BlockCursor intermediates = block.cursor();
            for (int position = 0; position < block.getPositionCount(); ++position) {
                Preconditions.checkState((boolean)intermediates.advanceNextPosition(), (Object)"failed to advance intermediates cursor");
                Slice slice = intermediates.getSlice();
                long inputCount = slice.getLong(0);
                this.samples += slice.getLong(8);
                long inputSum = slice.getLong(16);
                double inputVariance = slice.getDouble(24);
                if (this.count > 0L && inputCount > 0L) {
                    double t = (double)inputCount / (double)this.count * (double)this.sum - (double)inputSum;
                    this.variance = inputVariance + t * t * (double)this.count / (double)(inputCount * (this.count + inputCount));
                }
                this.sum += inputSum;
                this.count += inputCount;
            }
        }

        @Override
        public void evaluateIntermediate(BlockBuilder out) {
            out.append(ApproximateLongSumAggregation.createIntermediate(this.count, this.samples, this.sum, this.variance));
        }

        @Override
        public void evaluateFinal(BlockBuilder out) {
            if (this.count == 0L) {
                out.appendNull();
                return;
            }
            out.append(ApproximateUtils.formatApproximateResult(this.sum, ApproximateUtils.sumError(this.samples, this.count, this.sum, this.variance), this.confidence, true));
        }
    }

    public static class ApproximateSumGroupedAccumulator
    extends SimpleAggregationFunction.SimpleGroupedAccumulator {
        private final LongBigArray counts = new LongBigArray();
        private final LongBigArray samples = new LongBigArray();
        private final LongBigArray sums = new LongBigArray();
        private final DoubleBigArray variances = new DoubleBigArray();
        private final double confidence;

        public ApproximateSumGroupedAccumulator(int valueChannel, Optional<Integer> maskChannel, Optional<Integer> sampleWeightChannel, double confidence) {
            super(valueChannel, TupleInfo.SINGLE_VARBINARY, TupleInfo.SINGLE_VARBINARY, maskChannel, sampleWeightChannel);
            this.confidence = confidence;
        }

        @Override
        public long getEstimatedSize() {
            return this.counts.sizeOf() + this.samples.sizeOf() + this.sums.sizeOf() + this.variances.sizeOf();
        }

        @Override
        protected void processInput(GroupByIdBlock groupIdsBlock, Block valuesBlock, Optional<Block> maskBlock, Optional<Block> sampleWeightBlock) {
            this.counts.ensureCapacity(groupIdsBlock.getGroupCount());
            this.samples.ensureCapacity(groupIdsBlock.getGroupCount());
            this.sums.ensureCapacity(groupIdsBlock.getGroupCount());
            this.variances.ensureCapacity(groupIdsBlock.getGroupCount());
            BlockCursor values = valuesBlock.cursor();
            BlockCursor sampleWeights = ((Block)sampleWeightBlock.get()).cursor();
            BlockCursor masks = null;
            if (maskBlock.isPresent()) {
                masks = ((Block)maskBlock.get()).cursor();
            }
            for (int position = 0; position < groupIdsBlock.getPositionCount(); ++position) {
                long weight;
                long groupId = groupIdsBlock.getGroupId(position);
                Preconditions.checkState((masks == null || masks.advanceNextPosition() ? 1 : 0) != 0, (Object)"failed to advance mask cursor");
                Preconditions.checkState((boolean)sampleWeights.advanceNextPosition(), (Object)"failed to advance weight cursor");
                Preconditions.checkState((boolean)values.advanceNextPosition(), (Object)"failed to advance values cursor");
                long l = weight = values.isNull() ? 0L : SimpleAggregationFunction.computeSampleWeight(masks, sampleWeights);
                if (weight > 0L) {
                    this.samples.increment(groupId);
                }
                if (values.isNull() || weight <= 0L) continue;
                long value = values.getLong();
                long count = this.counts.get(groupId);
                long sum = this.sums.get(groupId);
                double variance = this.variances.get(groupId);
                int j = 0;
                while ((long)j < weight) {
                    sum += value;
                    if (++count > 1L) {
                        long t = count * value - sum;
                        variance += (double)(t * t) / ((double)count * (double)(count - 1L));
                    }
                    ++j;
                }
                this.counts.set(groupId, count);
                this.sums.set(groupId, sum);
                this.variances.set(groupId, variance);
            }
        }

        @Override
        public void processIntermediate(GroupByIdBlock groupIdsBlock, Block block) {
            this.counts.ensureCapacity(groupIdsBlock.getGroupCount());
            this.samples.ensureCapacity(groupIdsBlock.getGroupCount());
            this.sums.ensureCapacity(groupIdsBlock.getGroupCount());
            this.variances.ensureCapacity(groupIdsBlock.getGroupCount());
            BlockCursor intermediates = block.cursor();
            for (int position = 0; position < groupIdsBlock.getPositionCount(); ++position) {
                Preconditions.checkState((boolean)intermediates.advanceNextPosition(), (Object)"failed to advance intermediates cursor");
                long groupId = groupIdsBlock.getGroupId(position);
                Slice slice = intermediates.getSlice();
                long inputCount = slice.getLong(0);
                long count = this.counts.get(groupId);
                this.samples.add(groupId, slice.getLong(8));
                long inputSum = slice.getLong(16);
                double inputVariance = slice.getDouble(24);
                if (count > 0L && inputCount > 0L) {
                    double t = (double)inputCount / (double)count * (double)this.sums.get(groupId) - (double)inputSum;
                    this.variances.set(groupId, inputVariance + t * t * (double)count / (double)(inputCount * (count + inputCount)));
                }
                this.sums.add(groupId, inputSum);
                this.counts.add(groupId, inputCount);
            }
        }

        @Override
        public void evaluateIntermediate(int groupId, BlockBuilder output) {
            output.append(ApproximateLongSumAggregation.createIntermediate(this.counts.get(groupId), this.samples.get(groupId), this.sums.get(groupId), this.variances.get(groupId)));
        }

        @Override
        public void evaluateFinal(int groupId, BlockBuilder output) {
            long count = this.counts.get(groupId);
            if (count == 0L) {
                output.appendNull();
                return;
            }
            output.append(ApproximateUtils.formatApproximateResult(this.sums.get(groupId), ApproximateUtils.sumError(this.samples.get(groupId), count, this.sums.get(groupId), this.variances.get(groupId)), this.confidence, true));
        }
    }
}

