/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.block.Block;
import com.facebook.presto.block.BlockBuilder;
import com.facebook.presto.block.BlockCursor;
import com.facebook.presto.operator.GroupByIdBlock;
import com.facebook.presto.operator.Page;
import com.facebook.presto.operator.aggregation.Accumulator;
import com.facebook.presto.operator.aggregation.AggregationFunction;
import com.facebook.presto.operator.aggregation.GroupedAccumulator;
import com.facebook.presto.operator.aggregation.SimpleAggregationFunction;
import com.facebook.presto.tuple.TupleInfo;
import com.facebook.presto.util.array.ObjectBigArray;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.BasicSliceInput;
import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.Slice;
import io.airlift.stats.QuantileDigest;
import java.io.DataInput;
import java.io.DataOutput;
import java.util.List;

public class ApproximatePercentileAggregation
implements AggregationFunction {
    private final TupleInfo.Type parameterType;

    public ApproximatePercentileAggregation(TupleInfo.Type parameterType) {
        this.parameterType = parameterType;
    }

    @Override
    public List<TupleInfo.Type> getParameterTypes() {
        return ImmutableList.of((Object)this.parameterType, (Object)TupleInfo.Type.DOUBLE);
    }

    @Override
    public TupleInfo getFinalTupleInfo() {
        return ApproximatePercentileAggregation.getOutputTupleInfo(this.parameterType);
    }

    @Override
    public TupleInfo getIntermediateTupleInfo() {
        return TupleInfo.SINGLE_VARBINARY;
    }

    @Override
    public boolean isDecomposable() {
        return true;
    }

    @Override
    public ApproximatePercentileGroupedAccumulator createGroupedAggregation(Optional<Integer> maskChannel, Optional<Integer> sampleWeightChannel, double confidence, int[] argumentChannels) {
        Preconditions.checkArgument((confidence == 1.0 ? 1 : 0) != 0, (Object)"approximate percentile does not support approximate queries");
        return new ApproximatePercentileGroupedAccumulator(argumentChannels[0], argumentChannels[1], this.parameterType, maskChannel, sampleWeightChannel);
    }

    @Override
    public GroupedAccumulator createGroupedIntermediateAggregation(double confidence) {
        Preconditions.checkArgument((confidence == 1.0 ? 1 : 0) != 0, (Object)"approximate percentile does not support approximate queries");
        return new ApproximatePercentileGroupedAccumulator(-1, -1, this.parameterType, (Optional<Integer>)Optional.absent(), (Optional<Integer>)Optional.absent());
    }

    @Override
    public ApproximatePercentileAccumulator createAggregation(Optional<Integer> maskChannel, Optional<Integer> sampleWeightChannel, double confidence, int ... argumentChannels) {
        Preconditions.checkArgument((confidence == 1.0 ? 1 : 0) != 0, (Object)"approximate percentile does not support approximate queries");
        return new ApproximatePercentileAccumulator(argumentChannels[0], argumentChannels[1], this.parameterType, maskChannel, sampleWeightChannel);
    }

    @Override
    public ApproximatePercentileAccumulator createIntermediateAggregation(double confidence) {
        Preconditions.checkArgument((confidence == 1.0 ? 1 : 0) != 0, (Object)"approximate percentile does not support approximate queries");
        return new ApproximatePercentileAccumulator(-1, -1, this.parameterType, (Optional<Integer>)Optional.absent(), (Optional<Integer>)Optional.absent());
    }

    private static TupleInfo getOutputTupleInfo(TupleInfo.Type parameterType) {
        if (parameterType == TupleInfo.Type.FIXED_INT_64) {
            return TupleInfo.SINGLE_LONG;
        }
        if (parameterType == TupleInfo.Type.DOUBLE) {
            return TupleInfo.SINGLE_DOUBLE;
        }
        throw new IllegalArgumentException("Expected parameter type to be FIXED_INT_64 or DOUBLE");
    }

    private static void addValue(QuantileDigest digest, BlockCursor values, TupleInfo.Type parameterType, long count) {
        long value;
        if (parameterType == TupleInfo.Type.FIXED_INT_64) {
            value = values.getLong();
        } else if (parameterType == TupleInfo.Type.DOUBLE) {
            value = ApproximatePercentileAggregation.doubleToSortableLong(values.getDouble());
        } else {
            throw new IllegalArgumentException("Expected parameter type to be FIXED_INT_64 or DOUBLE");
        }
        digest.add(value, count);
    }

    public static void evaluate(BlockBuilder out, TupleInfo.Type parameterType, QuantileDigest digest, double percentile) {
        if (digest.getCount() == 0.0) {
            out.appendNull();
        } else {
            Preconditions.checkState((percentile != -1.0 ? 1 : 0) != 0, (Object)"Percentile is missing");
            long value = digest.getQuantile(percentile);
            if (parameterType == TupleInfo.Type.FIXED_INT_64) {
                out.append(value);
            } else if (parameterType == TupleInfo.Type.DOUBLE) {
                out.append(ApproximatePercentileAggregation.longToDouble(value));
            } else {
                throw new IllegalArgumentException("Expected parameter type to be FIXED_INT_64 or DOUBLE");
            }
        }
    }

    private static double longToDouble(long value) {
        if (value < 0L) {
            value ^= Long.MAX_VALUE;
        }
        return Double.longBitsToDouble(value);
    }

    private static long doubleToSortableLong(double value) {
        long result = Double.doubleToRawLongBits(value);
        if (result < 0L) {
            result ^= Long.MAX_VALUE;
        }
        return result;
    }

    public static final class DigestAndPercentile {
        private final QuantileDigest digest;
        private double percentile = -1.0;

        public DigestAndPercentile(QuantileDigest digest) {
            this.digest = digest;
        }

        public QuantileDigest getDigest() {
            return this.digest;
        }

        public double getPercentile() {
            return this.percentile;
        }

        public void setPercentile(double percentile) {
            this.percentile = percentile;
        }
    }

    public static class ApproximatePercentileAccumulator
    implements Accumulator {
        private final int valueChannel;
        private final int percentileChannel;
        private final TupleInfo.Type parameterType;
        private final Optional<Integer> maskChannel;
        private final Optional<Integer> sampleWeightChannel;
        private final QuantileDigest digest = new QuantileDigest(0.01);
        private double percentile = -1.0;

        public ApproximatePercentileAccumulator(int valueChannel, int percentileChannel, TupleInfo.Type parameterType, Optional<Integer> maskChannel, Optional<Integer> sampleWeightChannel) {
            this.valueChannel = valueChannel;
            this.percentileChannel = percentileChannel;
            this.parameterType = parameterType;
            this.maskChannel = maskChannel;
            this.sampleWeightChannel = sampleWeightChannel;
        }

        @Override
        public TupleInfo getFinalTupleInfo() {
            return ApproximatePercentileAggregation.getOutputTupleInfo(this.parameterType);
        }

        @Override
        public TupleInfo getIntermediateTupleInfo() {
            return TupleInfo.SINGLE_VARBINARY;
        }

        @Override
        public void addInput(Page page) {
            Preconditions.checkArgument((this.valueChannel != -1 ? 1 : 0) != 0, (Object)"Raw input is not allowed for a final aggregation");
            BlockCursor values = page.getBlock(this.valueChannel).cursor();
            BlockCursor percentiles = page.getBlock(this.percentileChannel).cursor();
            BlockCursor masks = null;
            if (this.maskChannel.isPresent()) {
                masks = page.getBlock((Integer)this.maskChannel.get()).cursor();
            }
            BlockCursor sampleWeights = null;
            if (this.sampleWeightChannel.isPresent()) {
                sampleWeights = page.getBlock((Integer)this.sampleWeightChannel.get()).cursor();
            }
            for (int position = 0; position < page.getPositionCount(); ++position) {
                Preconditions.checkState((boolean)values.advanceNextPosition());
                Preconditions.checkState((boolean)percentiles.advanceNextPosition());
                Preconditions.checkState((masks == null || masks.advanceNextPosition() ? 1 : 0) != 0);
                Preconditions.checkState((sampleWeights == null || sampleWeights.advanceNextPosition() ? 1 : 0) != 0);
                long sampleWeight = SimpleAggregationFunction.computeSampleWeight(masks, sampleWeights);
                if (values.isNull() || sampleWeight <= 0L) continue;
                ApproximatePercentileAggregation.addValue(this.digest, values, this.parameterType, sampleWeight);
                if (percentiles.isNull()) continue;
                this.percentile = percentiles.getDouble();
            }
        }

        @Override
        public void addIntermediate(Block block) {
            Preconditions.checkArgument((this.valueChannel == -1 ? 1 : 0) != 0, (Object)"Intermediate input is only allowed for a final aggregation");
            BlockCursor intermediates = block.cursor();
            for (int position = 0; position < block.getPositionCount(); ++position) {
                Preconditions.checkState((boolean)intermediates.advanceNextPosition());
                if (intermediates.isNull()) continue;
                BasicSliceInput input = intermediates.getSlice().getInput();
                this.digest.merge(QuantileDigest.deserialize((DataInput)input));
                this.percentile = input.readDouble();
            }
        }

        @Override
        public final Block evaluateIntermediate() {
            BlockBuilder out = new BlockBuilder(this.getIntermediateTupleInfo());
            if (this.digest.getCount() == 0.0) {
                out.appendNull();
            } else {
                DynamicSliceOutput sliceOutput = new DynamicSliceOutput(this.digest.estimatedSerializedSizeInBytes() + 8);
                this.digest.serialize((DataOutput)sliceOutput);
                sliceOutput.appendDouble(this.percentile);
                Slice slice = sliceOutput.slice();
                out.append(slice);
            }
            return out.build();
        }

        @Override
        public final Block evaluateFinal() {
            BlockBuilder out = new BlockBuilder(this.getFinalTupleInfo());
            ApproximatePercentileAggregation.evaluate(out, this.parameterType, this.digest, this.percentile);
            return out.build();
        }
    }

    public static class ApproximatePercentileGroupedAccumulator
    implements GroupedAccumulator {
        private final int valueChannel;
        private final int percentileChannel;
        private final TupleInfo.Type parameterType;
        private final ObjectBigArray<DigestAndPercentile> digests = new ObjectBigArray();
        private final Optional<Integer> maskChannel;
        private final Optional<Integer> sampleWeightChannel;
        private long sizeOfValues;

        public ApproximatePercentileGroupedAccumulator(int valueChannel, int percentileChannel, TupleInfo.Type parameterType, Optional<Integer> maskChannel, Optional<Integer> sampleWeightChannel) {
            this.valueChannel = valueChannel;
            this.percentileChannel = percentileChannel;
            this.parameterType = parameterType;
            this.maskChannel = maskChannel;
            this.sampleWeightChannel = sampleWeightChannel;
        }

        @Override
        public long getEstimatedSize() {
            return this.digests.sizeOf() + this.sizeOfValues;
        }

        @Override
        public TupleInfo getFinalTupleInfo() {
            return ApproximatePercentileAggregation.getOutputTupleInfo(this.parameterType);
        }

        @Override
        public TupleInfo getIntermediateTupleInfo() {
            return TupleInfo.SINGLE_VARBINARY;
        }

        @Override
        public void addInput(GroupByIdBlock groupIdsBlock, Page page) {
            Preconditions.checkArgument((this.percentileChannel != -1 ? 1 : 0) != 0, (Object)"Raw input is not allowed for a final aggregation");
            this.digests.ensureCapacity(groupIdsBlock.getGroupCount());
            BlockCursor values = page.getBlock(this.valueChannel).cursor();
            BlockCursor percentiles = page.getBlock(this.percentileChannel).cursor();
            BlockCursor masks = null;
            if (this.maskChannel.isPresent()) {
                masks = page.getBlock((Integer)this.maskChannel.get()).cursor();
            }
            BlockCursor sampleWeights = null;
            if (this.sampleWeightChannel.isPresent()) {
                sampleWeights = page.getBlock((Integer)this.sampleWeightChannel.get()).cursor();
            }
            for (int position = 0; position < groupIdsBlock.getPositionCount(); ++position) {
                Preconditions.checkState((boolean)values.advanceNextPosition());
                Preconditions.checkState((boolean)percentiles.advanceNextPosition());
                Preconditions.checkState((masks == null || masks.advanceNextPosition() ? 1 : 0) != 0);
                Preconditions.checkState((sampleWeights == null || sampleWeights.advanceNextPosition() ? 1 : 0) != 0);
                long sampleWeight = SimpleAggregationFunction.computeSampleWeight(masks, sampleWeights);
                long groupId = groupIdsBlock.getGroupId(position);
                if (values.isNull() || sampleWeight <= 0L) continue;
                DigestAndPercentile currentValue = this.digests.get(groupId);
                if (currentValue == null) {
                    currentValue = new DigestAndPercentile(new QuantileDigest(0.01));
                    this.digests.set(groupId, currentValue);
                    this.sizeOfValues += (long)currentValue.getDigest().estimatedInMemorySizeInBytes();
                }
                this.sizeOfValues -= (long)currentValue.getDigest().estimatedInMemorySizeInBytes();
                ApproximatePercentileAggregation.addValue(currentValue.getDigest(), values, this.parameterType, sampleWeight);
                this.sizeOfValues += (long)currentValue.getDigest().estimatedInMemorySizeInBytes();
                if (percentiles.isNull()) continue;
                currentValue.setPercentile(percentiles.getDouble());
            }
            Preconditions.checkState((!values.advanceNextPosition() ? 1 : 0) != 0);
            Preconditions.checkState((!percentiles.advanceNextPosition() ? 1 : 0) != 0);
        }

        @Override
        public void addIntermediate(GroupByIdBlock groupIdsBlock, Block block) {
            Preconditions.checkArgument((this.percentileChannel == -1 ? 1 : 0) != 0, (Object)"Intermediate input is only allowed for a final aggregation");
            this.digests.ensureCapacity(groupIdsBlock.getGroupCount());
            BlockCursor intermediates = block.cursor();
            for (int position = 0; position < groupIdsBlock.getPositionCount(); ++position) {
                Preconditions.checkState((boolean)intermediates.advanceNextPosition());
                if (intermediates.isNull()) continue;
                long groupId = groupIdsBlock.getGroupId(position);
                DigestAndPercentile currentValue = this.digests.get(groupId);
                if (currentValue == null) {
                    currentValue = new DigestAndPercentile(new QuantileDigest(0.01));
                    this.digests.set(groupId, currentValue);
                    this.sizeOfValues += (long)currentValue.getDigest().estimatedInMemorySizeInBytes();
                }
                BasicSliceInput input = intermediates.getSlice().getInput();
                this.sizeOfValues -= (long)currentValue.getDigest().estimatedInMemorySizeInBytes();
                currentValue.getDigest().merge(QuantileDigest.deserialize((DataInput)input));
                this.sizeOfValues += (long)currentValue.getDigest().estimatedInMemorySizeInBytes();
                currentValue.setPercentile(input.readDouble());
            }
        }

        @Override
        public void evaluateIntermediate(int groupId, BlockBuilder output) {
            DigestAndPercentile currentValue = this.digests.get(groupId);
            if (currentValue == null || currentValue.getDigest().getCount() == 0.0) {
                output.appendNull();
            } else {
                DynamicSliceOutput sliceOutput = new DynamicSliceOutput(currentValue.getDigest().estimatedSerializedSizeInBytes() + 8);
                currentValue.getDigest().serialize((DataOutput)sliceOutput);
                sliceOutput.appendDouble(currentValue.getPercentile());
                Slice slice = sliceOutput.slice();
                output.append(slice);
            }
        }

        @Override
        public void evaluateFinal(int groupId, BlockBuilder output) {
            DigestAndPercentile currentValue = this.digests.get(groupId);
            if (currentValue == null || currentValue.getDigest().getCount() == 0.0) {
                output.appendNull();
            } else {
                ApproximatePercentileAggregation.evaluate(output, this.parameterType, currentValue.getDigest(), currentValue.getPercentile());
            }
        }
    }
}

