/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.google.common.base.Throwables;
import org.apache.commons.math3.distribution.NormalDistribution;
import org.apache.commons.math3.exception.OutOfRangeException;

public final class ApproximateUtils {
    private static final NormalDistribution NORMAL_DISTRIBUTION = new NormalDistribution();

    private ApproximateUtils() {
    }

    public static String formatApproximateResult(double mean, double error, double confidence, boolean integral) {
        double zScore;
        try {
            zScore = NORMAL_DISTRIBUTION.inverseCumulativeProbability((1.0 + confidence) / 2.0);
        }
        catch (OutOfRangeException e) {
            throw Throwables.propagate((Throwable)e);
        }
        StringBuilder builder = new StringBuilder();
        if (integral) {
            builder.append((long)mean);
        } else {
            builder.append(mean);
        }
        builder.append(" +/- ");
        if (integral) {
            builder.append((long)Math.ceil(zScore * error));
        } else {
            builder.append(zScore * error);
        }
        return builder.toString();
    }

    public static double countError(long samples, long count) {
        if (count == 0L) {
            return Double.POSITIVE_INFINITY;
        }
        double p = (double)samples / (double)count;
        double error = 1.0 / p * Math.sqrt((double)samples * (1.0 - p));
        return ApproximateUtils.conservativeError(error, p, samples);
    }

    public static double sumError(long samples, long count, double sum, double variance) {
        if (count == 0L) {
            return Double.POSITIVE_INFINITY;
        }
        double p = (double)samples / (double)count;
        double mean = sum / (double)count;
        double error = 1.0 / p * Math.sqrt(variance / (double)count + (1.0 - p) * mean * mean);
        return ApproximateUtils.conservativeError(error, p, samples);
    }

    private static double conservativeError(double error, double p, double samples) {
        if (p < 0.01 && samples < 100.0) {
            return Double.POSITIVE_INFINITY;
        }
        return error;
    }
}

