/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.block.Block;
import com.facebook.presto.block.BlockBuilder;
import com.facebook.presto.block.BlockCursor;
import com.facebook.presto.operator.GroupByIdBlock;
import com.facebook.presto.operator.aggregation.Accumulator;
import com.facebook.presto.operator.aggregation.GroupedAccumulator;
import com.facebook.presto.operator.aggregation.SimpleAggregationFunction;
import com.facebook.presto.tuple.TupleInfo;
import com.facebook.presto.util.array.ByteBigArray;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;

public class BooleanMaxAggregation
extends SimpleAggregationFunction {
    public static final BooleanMaxAggregation BOOLEAN_MAX = new BooleanMaxAggregation();

    public BooleanMaxAggregation() {
        super(TupleInfo.SINGLE_BOOLEAN, TupleInfo.SINGLE_BOOLEAN, TupleInfo.Type.BOOLEAN);
    }

    @Override
    protected GroupedAccumulator createGroupedAccumulator(Optional<Integer> maskChannel, Optional<Integer> sampleWeightChannel, double confidence, int valueChannel) {
        Preconditions.checkArgument((confidence == 1.0 ? 1 : 0) != 0, (Object)"max does not support approximate queries");
        return new BooleanMinGroupedAccumulator(valueChannel);
    }

    @Override
    protected Accumulator createAccumulator(Optional<Integer> maskChannel, Optional<Integer> sampleWeightChannel, double confidence, int valueChannel) {
        Preconditions.checkArgument((confidence == 1.0 ? 1 : 0) != 0, (Object)"max does not support approximate queries");
        return new BooleanMaxAccumulator(valueChannel);
    }

    public static class BooleanMaxAccumulator
    extends SimpleAggregationFunction.SimpleAccumulator {
        private boolean notNull;
        private boolean max;

        public BooleanMaxAccumulator(int valueChannel) {
            super(valueChannel, TupleInfo.SINGLE_BOOLEAN, TupleInfo.SINGLE_BOOLEAN, (Optional<Integer>)Optional.absent(), (Optional<Integer>)Optional.absent());
        }

        @Override
        protected void processInput(Block block, Optional<Block> maskBlock, Optional<Block> sampleWeightBlock) {
            BlockCursor values = block.cursor();
            for (int position = 0; position < block.getPositionCount(); ++position) {
                Preconditions.checkState((boolean)values.advanceNextPosition());
                if (values.isNull()) continue;
                this.notNull = true;
                if (!values.getBoolean()) continue;
                this.max = true;
            }
        }

        @Override
        public void evaluateFinal(BlockBuilder out) {
            if (this.notNull) {
                out.append(this.max);
            } else {
                out.appendNull();
            }
        }
    }

    public static class BooleanMinGroupedAccumulator
    extends SimpleAggregationFunction.SimpleGroupedAccumulator {
        private static final byte NULL_VALUE = 0;
        private static final byte TRUE_VALUE = 1;
        private static final byte FALSE_VALUE = -1;
        private final ByteBigArray maxValues = new ByteBigArray();

        public BooleanMinGroupedAccumulator(int valueChannel) {
            super(valueChannel, TupleInfo.SINGLE_BOOLEAN, TupleInfo.SINGLE_BOOLEAN, (Optional<Integer>)Optional.absent(), (Optional<Integer>)Optional.absent());
        }

        @Override
        public long getEstimatedSize() {
            return this.maxValues.sizeOf();
        }

        @Override
        protected void processInput(GroupByIdBlock groupIdsBlock, Block valuesBlock, Optional<Block> maskBlock, Optional<Block> sampleWeightBlock) {
            this.maxValues.ensureCapacity(groupIdsBlock.getGroupCount());
            BlockCursor values = valuesBlock.cursor();
            for (int position = 0; position < groupIdsBlock.getPositionCount(); ++position) {
                Preconditions.checkState((boolean)values.advanceNextPosition());
                if (values.isNull()) continue;
                long groupId = groupIdsBlock.getGroupId(position);
                if (values.getBoolean()) {
                    this.maxValues.set(groupId, (byte)1);
                    continue;
                }
                if (this.maxValues.get(groupId) != 0) continue;
                this.maxValues.set(groupId, (byte)-1);
            }
        }

        @Override
        public void evaluateFinal(int groupId, BlockBuilder output) {
            byte value = this.maxValues.get(groupId);
            if (value == 0) {
                output.appendNull();
            } else {
                output.append(value == 1);
            }
        }
    }
}

