/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.block.Block;
import com.facebook.presto.block.BlockBuilder;
import com.facebook.presto.block.BlockCursor;
import com.facebook.presto.operator.GroupByIdBlock;
import com.facebook.presto.operator.Page;
import com.facebook.presto.operator.aggregation.Accumulator;
import com.facebook.presto.operator.aggregation.AggregationFunction;
import com.facebook.presto.operator.aggregation.GroupedAccumulator;
import com.facebook.presto.operator.aggregation.PoissonizedBlock;
import com.facebook.presto.serde.PagesSerde;
import com.facebook.presto.tuple.TupleInfo;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import io.airlift.slice.BasicSliceInput;
import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.SliceInput;
import io.airlift.slice.SliceOutput;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.commons.math3.random.RandomDataGenerator;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;

public class BootstrappedAggregation
implements AggregationFunction {
    private static final int SAMPLES = 100;
    private final AggregationFunction function;

    public BootstrappedAggregation(AggregationFunction function) {
        this.function = (AggregationFunction)Preconditions.checkNotNull((Object)function, (Object)"function is null");
        Preconditions.checkArgument((function.getFinalTupleInfo().equals(TupleInfo.SINGLE_LONG) || function.getFinalTupleInfo().equals(TupleInfo.SINGLE_DOUBLE) ? 1 : 0) != 0, (Object)"bootstrap only supports functions that output a number");
    }

    @Override
    public List<TupleInfo.Type> getParameterTypes() {
        return this.function.getParameterTypes();
    }

    @Override
    public TupleInfo getFinalTupleInfo() {
        return TupleInfo.SINGLE_VARBINARY;
    }

    @Override
    public TupleInfo getIntermediateTupleInfo() {
        return TupleInfo.SINGLE_VARBINARY;
    }

    @Override
    public boolean isDecomposable() {
        return this.function.isDecomposable();
    }

    @Override
    public Accumulator createAggregation(Optional<Integer> maskChannel, Optional<Integer> sampleWeightChannel, double confidence, int ... argumentChannels) {
        Preconditions.checkArgument((boolean)sampleWeightChannel.isPresent(), (Object)"sample weight must be present for bootstrapping");
        return this.createDeterministicAggregation(maskChannel, (Integer)sampleWeightChannel.get(), confidence, ThreadLocalRandom.current().nextLong(), argumentChannels);
    }

    @Override
    public Accumulator createIntermediateAggregation(double confidence) {
        return this.createDeterministicIntermediateAggregation(confidence, ThreadLocalRandom.current().nextLong());
    }

    @Override
    public GroupedAccumulator createGroupedAggregation(Optional<Integer> maskChannel, Optional<Integer> sampleWeightChannel, double confidence, int ... argumentChannels) {
        Preconditions.checkArgument((boolean)sampleWeightChannel.isPresent(), (Object)"sample weight must be present for bootstrapping");
        return this.createDeterministicGroupedAggregation(maskChannel, (Integer)sampleWeightChannel.get(), confidence, ThreadLocalRandom.current().nextLong(), argumentChannels);
    }

    @Override
    public GroupedAccumulator createGroupedIntermediateAggregation(double confidence) {
        return this.createDeterministicGroupedIntermediateAggregation(confidence, ThreadLocalRandom.current().nextLong());
    }

    @VisibleForTesting
    public Accumulator createDeterministicAggregation(Optional<Integer> maskChannel, int sampleWeightChannel, double confidence, long seed, int ... argumentChannels) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 0; i < 100; ++i) {
            builder.add((Object)this.function.createAggregation(maskChannel, (Optional<Integer>)Optional.of((Object)sampleWeightChannel), 1.0, argumentChannels));
        }
        return new BootstrappedAccumulator((List<Accumulator>)builder.build(), sampleWeightChannel, confidence, seed);
    }

    @VisibleForTesting
    public Accumulator createDeterministicIntermediateAggregation(double confidence, long seed) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 0; i < 100; ++i) {
            builder.add((Object)this.function.createIntermediateAggregation(1.0));
        }
        return new BootstrappedAccumulator((List<Accumulator>)builder.build(), -1, confidence, seed);
    }

    @VisibleForTesting
    public GroupedAccumulator createDeterministicGroupedAggregation(Optional<Integer> maskChannel, int sampleWeightChannel, double confidence, long seed, int ... argumentChannels) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 0; i < 100; ++i) {
            builder.add((Object)this.function.createGroupedAggregation(maskChannel, (Optional<Integer>)Optional.of((Object)sampleWeightChannel), 1.0, argumentChannels));
        }
        return new BootstrappedGroupedAccumulator((List<GroupedAccumulator>)builder.build(), sampleWeightChannel, confidence, seed);
    }

    @VisibleForTesting
    public GroupedAccumulator createDeterministicGroupedIntermediateAggregation(double confidence, long seed) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 0; i < 100; ++i) {
            builder.add((Object)this.function.createGroupedIntermediateAggregation(1.0));
        }
        return new BootstrappedGroupedAccumulator((List<GroupedAccumulator>)builder.build(), -1, confidence, seed);
    }

    private static String formatApproximateOutput(DescriptiveStatistics statistics, double confidence) {
        StringBuilder sb = new StringBuilder();
        double p = 100.0 * (1.0 + confidence) / 2.0;
        double upper = statistics.getPercentile(p);
        double lower = statistics.getPercentile(100.0 - p);
        sb.append((upper + lower) / 2.0);
        sb.append(" +/- ");
        double error = (upper - lower) / 2.0;
        Preconditions.checkState((error >= 0.0 ? 1 : 0) != 0, (Object)"error is negative");
        sb.append(error);
        return sb.toString();
    }

    public static class BootstrappedGroupedAccumulator
    extends AbstractBootstrappedAccumulator
    implements GroupedAccumulator {
        private final List<GroupedAccumulator> accumulators;

        public BootstrappedGroupedAccumulator(List<GroupedAccumulator> accumulators, int sampleWeightChannel, double confidence, long seed) {
            super(sampleWeightChannel, confidence, seed);
            this.accumulators = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(accumulators, (Object)"accumulators is null")));
            Preconditions.checkArgument((accumulators.size() > 1 ? 1 : 0) != 0, (Object)"accumulators size is less than 2");
        }

        @Override
        public long getEstimatedSize() {
            long size = 0L;
            for (GroupedAccumulator accumulator : this.accumulators) {
                size += accumulator.getEstimatedSize();
            }
            return size;
        }

        @Override
        public TupleInfo getFinalTupleInfo() {
            return TupleInfo.SINGLE_VARBINARY;
        }

        @Override
        public TupleInfo getIntermediateTupleInfo() {
            return TupleInfo.SINGLE_VARBINARY;
        }

        @Override
        public void addInput(GroupByIdBlock groupIdsBlock, Page page) {
            Block[] blocks = Arrays.copyOf(page.getBlocks(), page.getChannelCount());
            for (int i = 0; i < this.accumulators.size(); ++i) {
                blocks[this.sampleWeightChannel] = this.resampleWeightBlock(page.getBlock(this.sampleWeightChannel));
                this.accumulators.get(i).addInput(groupIdsBlock, new Page(blocks));
            }
        }

        @Override
        public void addIntermediate(GroupByIdBlock groupIdsBlock, Block block) {
            BlockCursor cursor = block.cursor();
            Preconditions.checkArgument((boolean)cursor.advanceNextPosition());
            BasicSliceInput sliceInput = new BasicSliceInput(cursor.getSlice());
            Page page = (Page)Iterators.getOnlyElement(PagesSerde.readPages((SliceInput)sliceInput));
            Preconditions.checkArgument((page.getChannelCount() == this.accumulators.size() ? 1 : 0) != 0, (Object)"number of blocks does not match accumulators");
            for (int i = 0; i < page.getChannelCount(); ++i) {
                this.accumulators.get(i).addIntermediate(groupIdsBlock, page.getBlock(i));
            }
        }

        @Override
        public void evaluateIntermediate(int groupId, BlockBuilder output) {
            Block[] blocks = new Block[this.accumulators.size()];
            int sizeEstimate = 64 * this.accumulators.size();
            for (int i = 0; i < this.accumulators.size(); ++i) {
                BlockBuilder builder = new BlockBuilder(this.accumulators.get(i).getIntermediateTupleInfo());
                this.accumulators.get(i).evaluateIntermediate(groupId, builder);
                blocks[i] = builder.build();
                sizeEstimate = (int)((long)sizeEstimate + blocks[i].getDataSize().toBytes());
            }
            DynamicSliceOutput sliceOutput = new DynamicSliceOutput(sizeEstimate);
            PagesSerde.writePages((SliceOutput)sliceOutput, new Page(blocks));
            output.append(sliceOutput.slice());
        }

        @Override
        public void evaluateFinal(int groupId, BlockBuilder output) {
            DescriptiveStatistics statistics = new DescriptiveStatistics();
            for (int i = 0; i < this.accumulators.size(); ++i) {
                BlockBuilder builder = new BlockBuilder(this.accumulators.get(i).getFinalTupleInfo());
                this.accumulators.get(i).evaluateFinal(groupId, builder);
                BlockCursor cursor = builder.build().cursor();
                Preconditions.checkArgument((boolean)cursor.advanceNextPosition(), (Object)"accumulator returned no results");
                statistics.addValue(BootstrappedGroupedAccumulator.getNumeric(cursor));
            }
            output.append(BootstrappedAggregation.formatApproximateOutput(statistics, this.confidence));
        }
    }

    public static class BootstrappedAccumulator
    extends AbstractBootstrappedAccumulator
    implements Accumulator {
        private final List<Accumulator> accumulators;

        public BootstrappedAccumulator(List<Accumulator> accumulators, int sampleWeightChannel, double confidence, long seed) {
            super(sampleWeightChannel, confidence, seed);
            this.accumulators = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(accumulators, (Object)"accumulators is null")));
            Preconditions.checkArgument((accumulators.size() > 1 ? 1 : 0) != 0, (Object)"accumulators size is less than 2");
        }

        @Override
        public TupleInfo getFinalTupleInfo() {
            return TupleInfo.SINGLE_VARBINARY;
        }

        @Override
        public TupleInfo getIntermediateTupleInfo() {
            return TupleInfo.SINGLE_VARBINARY;
        }

        @Override
        public void addInput(Page page) {
            Block[] blocks = Arrays.copyOf(page.getBlocks(), page.getChannelCount());
            for (int i = 0; i < this.accumulators.size(); ++i) {
                blocks[this.sampleWeightChannel] = this.resampleWeightBlock(page.getBlock(this.sampleWeightChannel));
                this.accumulators.get(i).addInput(new Page(blocks));
            }
        }

        @Override
        public void addIntermediate(Block block) {
            BlockCursor cursor = block.cursor();
            Preconditions.checkArgument((boolean)cursor.advanceNextPosition());
            BasicSliceInput sliceInput = new BasicSliceInput(cursor.getSlice());
            Page page = (Page)Iterators.getOnlyElement(PagesSerde.readPages((SliceInput)sliceInput));
            Preconditions.checkArgument((page.getChannelCount() == this.accumulators.size() ? 1 : 0) != 0, (Object)"number of blocks does not match accumulators");
            for (int i = 0; i < page.getChannelCount(); ++i) {
                this.accumulators.get(i).addIntermediate(page.getBlock(i));
            }
        }

        @Override
        public Block evaluateIntermediate() {
            Block[] blocks = new Block[this.accumulators.size()];
            int sizeEstimate = 64 * this.accumulators.size();
            for (int i = 0; i < this.accumulators.size(); ++i) {
                blocks[i] = this.accumulators.get(i).evaluateIntermediate();
                sizeEstimate = (int)((long)sizeEstimate + blocks[i].getDataSize().toBytes());
            }
            DynamicSliceOutput output = new DynamicSliceOutput(sizeEstimate);
            PagesSerde.writePages((SliceOutput)output, new Page(blocks));
            BlockBuilder builder = new BlockBuilder(TupleInfo.SINGLE_VARBINARY);
            builder.append(output.slice());
            return builder.build();
        }

        @Override
        public Block evaluateFinal() {
            DescriptiveStatistics statistics = new DescriptiveStatistics();
            for (int i = 0; i < this.accumulators.size(); ++i) {
                BlockCursor cursor = this.accumulators.get(i).evaluateFinal().cursor();
                Preconditions.checkArgument((boolean)cursor.advanceNextPosition(), (Object)"accumulator returned no results");
                statistics.addValue(BootstrappedAccumulator.getNumeric(cursor));
            }
            BlockBuilder builder = new BlockBuilder(TupleInfo.SINGLE_VARBINARY);
            builder.append(BootstrappedAggregation.formatApproximateOutput(statistics, this.confidence));
            return builder.build();
        }
    }

    public static abstract class AbstractBootstrappedAccumulator {
        protected final int sampleWeightChannel;
        protected final double confidence;
        private final RandomDataGenerator rand = new RandomDataGenerator();

        public AbstractBootstrappedAccumulator(int sampleWeightChannel, double confidence, long seed) {
            this.sampleWeightChannel = sampleWeightChannel;
            this.confidence = confidence;
            this.rand.reSeed(seed);
        }

        protected Block resampleWeightBlock(Block block) {
            return new PoissonizedBlock(block, this.rand.nextLong(0L, 0x7FFFFFFFFFFFFFFEL));
        }

        protected static double getNumeric(BlockCursor cursor) {
            if (cursor.getTupleInfo().equals(TupleInfo.SINGLE_DOUBLE)) {
                return cursor.getDouble();
            }
            if (cursor.getTupleInfo().equals(TupleInfo.SINGLE_LONG)) {
                return cursor.getLong();
            }
            throw new AssertionError((Object)"expected a numeric cursor");
        }
    }
}

