/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.block.Block;
import com.facebook.presto.block.BlockBuilder;
import com.facebook.presto.block.BlockCursor;
import com.facebook.presto.operator.GroupByIdBlock;
import com.facebook.presto.operator.aggregation.Accumulator;
import com.facebook.presto.operator.aggregation.GroupedAccumulator;
import com.facebook.presto.operator.aggregation.SimpleAggregationFunction;
import com.facebook.presto.tuple.TupleInfo;
import com.facebook.presto.util.array.BooleanBigArray;
import com.facebook.presto.util.array.DoubleBigArray;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;

public class DoubleMaxAggregation
extends SimpleAggregationFunction {
    public static final DoubleMaxAggregation DOUBLE_MAX = new DoubleMaxAggregation();

    public DoubleMaxAggregation() {
        super(TupleInfo.SINGLE_DOUBLE, TupleInfo.SINGLE_DOUBLE, TupleInfo.Type.DOUBLE);
    }

    @Override
    protected GroupedAccumulator createGroupedAccumulator(Optional<Integer> maskChannel, Optional<Integer> sampleWeightChannel, double confidence, int valueChannel) {
        Preconditions.checkArgument((confidence == 1.0 ? 1 : 0) != 0, (Object)"max does not support approximate queries");
        return new DoubleMaxGroupedAccumulator(valueChannel);
    }

    @Override
    protected Accumulator createAccumulator(Optional<Integer> maskChannel, Optional<Integer> sampleWeightChannel, double confidence, int valueChannel) {
        Preconditions.checkArgument((confidence == 1.0 ? 1 : 0) != 0, (Object)"max does not support approximate queries");
        return new DoubleMaxAccumulator(valueChannel);
    }

    public static class DoubleMaxAccumulator
    extends SimpleAggregationFunction.SimpleAccumulator {
        private boolean notNull;
        private double max = Double.NEGATIVE_INFINITY;

        public DoubleMaxAccumulator(int valueChannel) {
            super(valueChannel, TupleInfo.SINGLE_DOUBLE, TupleInfo.SINGLE_DOUBLE, (Optional<Integer>)Optional.absent(), (Optional<Integer>)Optional.absent());
        }

        @Override
        protected void processInput(Block block, Optional<Block> maskBlock, Optional<Block> sampleWeightBlock) {
            BlockCursor values = block.cursor();
            for (int position = 0; position < block.getPositionCount(); ++position) {
                Preconditions.checkState((boolean)values.advanceNextPosition());
                if (values.isNull()) continue;
                this.notNull = true;
                this.max = Math.max(this.max, values.getDouble());
            }
        }

        @Override
        public void evaluateFinal(BlockBuilder out) {
            if (this.notNull) {
                out.append(this.max);
            } else {
                out.appendNull();
            }
        }
    }

    public static class DoubleMaxGroupedAccumulator
    extends SimpleAggregationFunction.SimpleGroupedAccumulator {
        private final BooleanBigArray notNull = new BooleanBigArray();
        private final DoubleBigArray maxValues = new DoubleBigArray(Double.NEGATIVE_INFINITY);

        public DoubleMaxGroupedAccumulator(int valueChannel) {
            super(valueChannel, TupleInfo.SINGLE_DOUBLE, TupleInfo.SINGLE_DOUBLE, (Optional<Integer>)Optional.absent(), (Optional<Integer>)Optional.absent());
        }

        @Override
        public long getEstimatedSize() {
            return this.notNull.sizeOf() + this.maxValues.sizeOf();
        }

        @Override
        protected void processInput(GroupByIdBlock groupIdsBlock, Block valuesBlock, Optional<Block> maskBlock, Optional<Block> sampleWeightBlock) {
            this.notNull.ensureCapacity(groupIdsBlock.getGroupCount());
            this.maxValues.ensureCapacity(groupIdsBlock.getGroupCount(), Double.NEGATIVE_INFINITY);
            BlockCursor values = valuesBlock.cursor();
            for (int position = 0; position < groupIdsBlock.getPositionCount(); ++position) {
                Preconditions.checkState((boolean)values.advanceNextPosition());
                long groupId = groupIdsBlock.getGroupId(position);
                if (values.isNull()) continue;
                this.notNull.set(groupId, true);
                double value = values.getDouble();
                value = Math.max(value, this.maxValues.get(groupId));
                this.maxValues.set(groupId, value);
            }
            Preconditions.checkState((!values.advanceNextPosition() ? 1 : 0) != 0);
        }

        @Override
        public void evaluateFinal(int groupId, BlockBuilder output) {
            if (this.notNull.get(groupId)) {
                double value = this.maxValues.get(groupId);
                output.append(value);
            } else {
                output.appendNull();
            }
        }
    }
}

