/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.block.Block;
import com.facebook.presto.block.BlockBuilder;
import com.facebook.presto.block.BlockCursor;
import com.facebook.presto.operator.GroupByIdBlock;
import com.facebook.presto.operator.aggregation.Accumulator;
import com.facebook.presto.operator.aggregation.GroupedAccumulator;
import com.facebook.presto.operator.aggregation.SimpleAggregationFunction;
import com.facebook.presto.tuple.TupleInfo;
import com.facebook.presto.util.array.BooleanBigArray;
import com.facebook.presto.util.array.DoubleBigArray;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;

public class DoubleSumAggregation
extends SimpleAggregationFunction {
    public static final DoubleSumAggregation DOUBLE_SUM = new DoubleSumAggregation();

    public DoubleSumAggregation() {
        super(TupleInfo.SINGLE_DOUBLE, TupleInfo.SINGLE_DOUBLE, TupleInfo.Type.DOUBLE);
    }

    @Override
    protected GroupedAccumulator createGroupedAccumulator(Optional<Integer> maskChannel, Optional<Integer> sampleWeightChannel, double confidence, int valueChannel) {
        Preconditions.checkArgument((confidence == 1.0 ? 1 : 0) != 0, (Object)"sum does not support approximate queries");
        return new DoubleSumGroupedAccumulator(valueChannel, maskChannel, sampleWeightChannel);
    }

    @Override
    protected Accumulator createAccumulator(Optional<Integer> maskChannel, Optional<Integer> sampleWeightChannel, double confidence, int valueChannel) {
        Preconditions.checkArgument((confidence == 1.0 ? 1 : 0) != 0, (Object)"sum does not support approximate queries");
        return new DoubleSumAccumulator(valueChannel, maskChannel, sampleWeightChannel);
    }

    public static class DoubleSumAccumulator
    extends SimpleAggregationFunction.SimpleAccumulator {
        private boolean notNull;
        private double sum;

        public DoubleSumAccumulator(int valueChannel, Optional<Integer> maskChannel, Optional<Integer> sampleWeightChannel) {
            super(valueChannel, TupleInfo.SINGLE_DOUBLE, TupleInfo.SINGLE_DOUBLE, maskChannel, sampleWeightChannel);
        }

        @Override
        protected void processInput(Block block, Optional<Block> maskBlock, Optional<Block> sampleWeightBlock) {
            BlockCursor intermediates = block.cursor();
            BlockCursor masks = null;
            if (maskBlock.isPresent()) {
                masks = ((Block)maskBlock.get()).cursor();
            }
            BlockCursor sampleWeights = null;
            if (sampleWeightBlock.isPresent()) {
                sampleWeights = ((Block)sampleWeightBlock.get()).cursor();
            }
            for (int position = 0; position < block.getPositionCount(); ++position) {
                Preconditions.checkState((boolean)intermediates.advanceNextPosition());
                Preconditions.checkState((masks == null || masks.advanceNextPosition() ? 1 : 0) != 0);
                Preconditions.checkState((sampleWeights == null || sampleWeights.advanceNextPosition() ? 1 : 0) != 0);
                long sampleWeight = SimpleAggregationFunction.computeSampleWeight(masks, sampleWeights);
                if (intermediates.isNull() || sampleWeight <= 0L) continue;
                this.notNull = true;
                this.sum += (double)sampleWeight * intermediates.getDouble();
            }
        }

        @Override
        public void evaluateFinal(BlockBuilder out) {
            if (this.notNull) {
                out.append(this.sum);
            } else {
                out.appendNull();
            }
        }
    }

    public static class DoubleSumGroupedAccumulator
    extends SimpleAggregationFunction.SimpleGroupedAccumulator {
        private final BooleanBigArray notNull = new BooleanBigArray();
        private final DoubleBigArray sums = new DoubleBigArray();

        public DoubleSumGroupedAccumulator(int valueChannel, Optional<Integer> maskChannel, Optional<Integer> sampleWeightChannel) {
            super(valueChannel, TupleInfo.SINGLE_DOUBLE, TupleInfo.SINGLE_DOUBLE, maskChannel, sampleWeightChannel);
        }

        @Override
        public long getEstimatedSize() {
            return this.notNull.sizeOf() + this.sums.sizeOf();
        }

        @Override
        protected void processInput(GroupByIdBlock groupIdsBlock, Block valuesBlock, Optional<Block> maskBlock, Optional<Block> sampleWeightBlock) {
            this.notNull.ensureCapacity(groupIdsBlock.getGroupCount());
            this.sums.ensureCapacity(groupIdsBlock.getGroupCount());
            BlockCursor values = valuesBlock.cursor();
            BlockCursor masks = null;
            if (maskBlock.isPresent()) {
                masks = ((Block)maskBlock.get()).cursor();
            }
            BlockCursor sampleWeights = null;
            if (sampleWeightBlock.isPresent()) {
                sampleWeights = ((Block)sampleWeightBlock.get()).cursor();
            }
            for (int position = 0; position < groupIdsBlock.getPositionCount(); ++position) {
                Preconditions.checkState((boolean)values.advanceNextPosition());
                Preconditions.checkState((masks == null || masks.advanceNextPosition() ? 1 : 0) != 0);
                Preconditions.checkState((sampleWeights == null || sampleWeights.advanceNextPosition() ? 1 : 0) != 0);
                long groupId = groupIdsBlock.getGroupId(position);
                long sampleWeight = SimpleAggregationFunction.computeSampleWeight(masks, sampleWeights);
                if (values.isNull() || sampleWeight <= 0L) continue;
                this.notNull.set(groupId, true);
                double value = values.getDouble();
                this.sums.add(groupId, (double)sampleWeight * value);
            }
            Preconditions.checkState((!values.advanceNextPosition() ? 1 : 0) != 0);
        }

        @Override
        public void evaluateFinal(int groupId, BlockBuilder output) {
            if (this.notNull.get(groupId)) {
                double value = this.sums.get(groupId);
                output.append(value);
            } else {
                output.appendNull();
            }
        }
    }
}

