/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.byteCode.DynamicClassLoader;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;

public final class IsolatedClass {
    private IsolatedClass() {
    }

    public static <T> Class<? extends T> isolateClass(Class<T> publicBaseClass, Class<? extends T> implementationClass, Class<?> ... additionalClasses) {
        DynamicClassLoader dynamicClassLoader = new DynamicClassLoader(publicBaseClass.getClassLoader());
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)implementationClass.getName(), (Object)IsolatedClass.getByteCode(implementationClass));
        for (Class<?> additionalClass : additionalClasses) {
            builder.put((Object)additionalClass.getName(), (Object)IsolatedClass.getByteCode(additionalClass));
        }
        Map<String, Class<?>> isolatedClasses = dynamicClassLoader.defineClasses((Map<String, byte[]>)builder.build());
        Class<?> isolatedClass = isolatedClasses.get(implementationClass.getName());
        Preconditions.checkArgument((isolatedClass != null ? 1 : 0) != 0, (String)"Could load class %s", (Object[])new Object[]{implementationClass.getName()});
        Preconditions.checkArgument((boolean)publicBaseClass.isAssignableFrom(isolatedClass), (String)"Error isolating class %s, newly loaded class is not a sub type of %s", (Object[])new Object[]{implementationClass.getName(), publicBaseClass.getName()});
        Preconditions.checkState((isolatedClass != implementationClass ? 1 : 0) != 0, (Object)"Isolation failed");
        return isolatedClass.asSubclass(publicBaseClass);
    }

    private static byte[] getByteCode(Class<?> clazz) {
        InputStream stream = clazz.getClassLoader().getResourceAsStream(clazz.getName().replace('.', '/') + ".class");
        Preconditions.checkArgument((stream != null ? 1 : 0) != 0, (String)"Could not obtain byte code for class %s", (Object[])new Object[]{clazz.getName()});
        try {
            return ByteStreams.toByteArray((InputStream)stream);
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

