/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.block.Block;
import com.facebook.presto.block.BlockBuilder;
import com.facebook.presto.block.BlockCursor;
import com.facebook.presto.operator.GroupByIdBlock;
import com.facebook.presto.operator.aggregation.Accumulator;
import com.facebook.presto.operator.aggregation.GroupedAccumulator;
import com.facebook.presto.operator.aggregation.SimpleAggregationFunction;
import com.facebook.presto.tuple.TupleInfo;
import com.facebook.presto.util.array.BooleanBigArray;
import com.facebook.presto.util.array.LongBigArray;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;

public class LongMinAggregation
extends SimpleAggregationFunction {
    public static final LongMinAggregation LONG_MIN = new LongMinAggregation();

    public LongMinAggregation() {
        super(TupleInfo.SINGLE_LONG, TupleInfo.SINGLE_LONG, TupleInfo.Type.FIXED_INT_64);
    }

    @Override
    protected GroupedAccumulator createGroupedAccumulator(Optional<Integer> maskChannel, Optional<Integer> sampleWeightChannel, double confidence, int valueChannel) {
        Preconditions.checkArgument((confidence == 1.0 ? 1 : 0) != 0, (Object)"min does not support approximate queries");
        return new LongMinGroupedAccumulator(valueChannel);
    }

    @Override
    protected Accumulator createAccumulator(Optional<Integer> maskChannel, Optional<Integer> sampleWeightChannel, double confidence, int valueChannel) {
        Preconditions.checkArgument((confidence == 1.0 ? 1 : 0) != 0, (Object)"min does not support approximate queries");
        return new LongMinAccumulator(valueChannel);
    }

    public static class LongMinAccumulator
    extends SimpleAggregationFunction.SimpleAccumulator {
        private boolean notNull;
        private long min = Long.MAX_VALUE;

        public LongMinAccumulator(int valueChannel) {
            super(valueChannel, TupleInfo.SINGLE_LONG, TupleInfo.SINGLE_LONG, (Optional<Integer>)Optional.absent(), (Optional<Integer>)Optional.absent());
        }

        @Override
        protected void processInput(Block block, Optional<Block> maskBlock, Optional<Block> sampleWeightBlock) {
            BlockCursor values = block.cursor();
            for (int position = 0; position < block.getPositionCount(); ++position) {
                Preconditions.checkState((boolean)values.advanceNextPosition());
                if (values.isNull()) continue;
                this.notNull = true;
                this.min = Math.min(this.min, values.getLong());
            }
        }

        @Override
        public void evaluateFinal(BlockBuilder out) {
            if (this.notNull) {
                out.append(this.min);
            } else {
                out.appendNull();
            }
        }
    }

    public static class LongMinGroupedAccumulator
    extends SimpleAggregationFunction.SimpleGroupedAccumulator {
        private final BooleanBigArray notNull = new BooleanBigArray();
        private final LongBigArray minValues = new LongBigArray(Long.MAX_VALUE);

        public LongMinGroupedAccumulator(int valueChannel) {
            super(valueChannel, TupleInfo.SINGLE_LONG, TupleInfo.SINGLE_LONG, (Optional<Integer>)Optional.absent(), (Optional<Integer>)Optional.absent());
        }

        @Override
        public long getEstimatedSize() {
            return this.notNull.sizeOf() + this.minValues.sizeOf();
        }

        @Override
        protected void processInput(GroupByIdBlock groupIdsBlock, Block valuesBlock, Optional<Block> maskBlock, Optional<Block> sampleWeightBlock) {
            this.notNull.ensureCapacity(groupIdsBlock.getGroupCount());
            this.minValues.ensureCapacity(groupIdsBlock.getGroupCount(), Long.MAX_VALUE);
            BlockCursor values = valuesBlock.cursor();
            for (int position = 0; position < groupIdsBlock.getPositionCount(); ++position) {
                Preconditions.checkState((boolean)values.advanceNextPosition());
                long groupId = groupIdsBlock.getGroupId(position);
                if (values.isNull()) continue;
                this.notNull.set(groupId, true);
                long value = values.getLong();
                value = Math.min(value, this.minValues.get(groupId));
                this.minValues.set(groupId, value);
            }
            Preconditions.checkState((!values.advanceNextPosition() ? 1 : 0) != 0);
        }

        @Override
        public void evaluateFinal(int groupId, BlockBuilder output) {
            if (this.notNull.get(groupId)) {
                long value = this.minValues.get(groupId);
                output.append(value);
            } else {
                output.appendNull();
            }
        }
    }
}

