/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.block.Block;
import com.facebook.presto.block.BlockBuilder;
import com.facebook.presto.block.BlockCursor;
import com.facebook.presto.operator.GroupByIdBlock;
import com.facebook.presto.operator.aggregation.Accumulator;
import com.facebook.presto.operator.aggregation.GroupedAccumulator;
import com.facebook.presto.operator.aggregation.SimpleAggregationFunction;
import com.facebook.presto.tuple.TupleInfo;
import com.facebook.presto.util.array.BooleanBigArray;
import com.facebook.presto.util.array.LongBigArray;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;

public class LongSumAggregation
extends SimpleAggregationFunction {
    public static final LongSumAggregation LONG_SUM = new LongSumAggregation();

    public LongSumAggregation() {
        super(TupleInfo.SINGLE_LONG, TupleInfo.SINGLE_LONG, TupleInfo.Type.FIXED_INT_64);
    }

    @Override
    protected GroupedAccumulator createGroupedAccumulator(Optional<Integer> maskChannel, Optional<Integer> sampleWeightChannel, double confidence, int valueChannel) {
        Preconditions.checkArgument((confidence == 1.0 ? 1 : 0) != 0, (Object)"sum does not support approximate queries");
        return new LongSumGroupedAccumulator(valueChannel, maskChannel, sampleWeightChannel);
    }

    @Override
    protected Accumulator createAccumulator(Optional<Integer> maskChannel, Optional<Integer> sampleWeightChannel, double confidence, int valueChannel) {
        Preconditions.checkArgument((confidence == 1.0 ? 1 : 0) != 0, (Object)"sum does not support approximate queries");
        return new LongSumAccumulator(valueChannel, maskChannel, sampleWeightChannel);
    }

    public static class LongSumAccumulator
    extends SimpleAggregationFunction.SimpleAccumulator {
        private boolean notNull;
        private long sum;

        public LongSumAccumulator(int valueChannel, Optional<Integer> maskChannel, Optional<Integer> sampleWeightChannel) {
            super(valueChannel, TupleInfo.SINGLE_LONG, TupleInfo.SINGLE_LONG, maskChannel, sampleWeightChannel);
        }

        @Override
        protected void processInput(Block block, Optional<Block> maskBlock, Optional<Block> sampleWeightBlock) {
            BlockCursor values = block.cursor();
            BlockCursor masks = null;
            if (maskBlock.isPresent()) {
                masks = ((Block)maskBlock.get()).cursor();
            }
            BlockCursor sampleWeights = null;
            if (sampleWeightBlock.isPresent()) {
                sampleWeights = ((Block)sampleWeightBlock.get()).cursor();
            }
            for (int position = 0; position < block.getPositionCount(); ++position) {
                Preconditions.checkState((boolean)values.advanceNextPosition());
                Preconditions.checkState((masks == null || masks.advanceNextPosition() ? 1 : 0) != 0);
                Preconditions.checkState((sampleWeights == null || sampleWeights.advanceNextPosition() ? 1 : 0) != 0);
                long sampleWeight = SimpleAggregationFunction.computeSampleWeight(masks, sampleWeights);
                if (values.isNull() || sampleWeight <= 0L) continue;
                this.notNull = true;
                this.sum += sampleWeight * values.getLong();
            }
        }

        @Override
        public void evaluateFinal(BlockBuilder out) {
            if (this.notNull) {
                out.append(this.sum);
            } else {
                out.appendNull();
            }
        }
    }

    public static class LongSumGroupedAccumulator
    extends SimpleAggregationFunction.SimpleGroupedAccumulator {
        private final BooleanBigArray notNull = new BooleanBigArray();
        private final LongBigArray sums = new LongBigArray();

        public LongSumGroupedAccumulator(int valueChannel, Optional<Integer> maskChannel, Optional<Integer> sampleWeightChannel) {
            super(valueChannel, TupleInfo.SINGLE_LONG, TupleInfo.SINGLE_LONG, maskChannel, sampleWeightChannel);
        }

        @Override
        public long getEstimatedSize() {
            return this.notNull.sizeOf() + this.sums.sizeOf();
        }

        @Override
        protected void processInput(GroupByIdBlock groupIdsBlock, Block valuesBlock, Optional<Block> maskBlock, Optional<Block> sampleWeightBlock) {
            this.notNull.ensureCapacity(groupIdsBlock.getGroupCount());
            this.sums.ensureCapacity(groupIdsBlock.getGroupCount());
            BlockCursor values = valuesBlock.cursor();
            BlockCursor masks = null;
            if (maskBlock.isPresent()) {
                masks = ((Block)maskBlock.get()).cursor();
            }
            BlockCursor sampleWeights = null;
            if (sampleWeightBlock.isPresent()) {
                sampleWeights = ((Block)sampleWeightBlock.get()).cursor();
            }
            for (int position = 0; position < groupIdsBlock.getPositionCount(); ++position) {
                Preconditions.checkState((boolean)values.advanceNextPosition());
                Preconditions.checkState((masks == null || masks.advanceNextPosition() ? 1 : 0) != 0);
                Preconditions.checkState((sampleWeights == null || sampleWeights.advanceNextPosition() ? 1 : 0) != 0);
                long groupId = groupIdsBlock.getGroupId(position);
                long sampleWeight = SimpleAggregationFunction.computeSampleWeight(masks, sampleWeights);
                if (values.isNull() || sampleWeight <= 0L) continue;
                this.notNull.set(groupId, true);
                long value = values.getLong();
                this.sums.add(groupId, sampleWeight * value);
            }
            Preconditions.checkState((!values.advanceNextPosition() ? 1 : 0) != 0);
        }

        @Override
        public void evaluateFinal(int groupId, BlockBuilder output) {
            if (this.notNull.get(groupId)) {
                long value = this.sums.get(groupId);
                output.append(value);
            } else {
                output.appendNull();
            }
        }
    }
}

