/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.block.Block;
import com.facebook.presto.block.BlockBuilder;
import com.facebook.presto.block.BlockCursor;
import com.facebook.presto.block.RandomAccessBlock;
import com.facebook.presto.serde.BlockEncoding;
import com.facebook.presto.tuple.Tuple;
import com.facebook.presto.tuple.TupleInfo;
import com.google.common.base.Preconditions;
import io.airlift.slice.Slice;
import io.airlift.units.DataSize;
import org.apache.commons.math3.random.RandomDataGenerator;

class PoissonizedBlock
implements Block {
    private final Block delegate;
    private final long seed;

    public PoissonizedBlock(Block delegate, long seed) {
        this.delegate = delegate;
        this.seed = seed;
    }

    @Override
    public TupleInfo getTupleInfo() {
        return TupleInfo.SINGLE_LONG;
    }

    @Override
    public int getPositionCount() {
        return this.delegate.getPositionCount();
    }

    @Override
    public DataSize getDataSize() {
        return this.delegate.getDataSize();
    }

    @Override
    public BlockCursor cursor() {
        return new PoissonizedBlockCursor(this.delegate.cursor(), this.seed);
    }

    @Override
    public BlockEncoding getEncoding() {
        throw new UnsupportedOperationException("Poissonized blocks cannot be serialized");
    }

    @Override
    public Block getRegion(int positionOffset, int length) {
        throw new UnsupportedOperationException("getRegion for poissonized block is not supported");
    }

    @Override
    public RandomAccessBlock toRandomAccessBlock() {
        throw new UnsupportedOperationException("Random access to poissonized block is not supported");
    }

    public static class PoissonizedBlockCursor
    implements BlockCursor {
        private final RandomDataGenerator rand = new RandomDataGenerator();
        private final BlockCursor delegate;
        private long currentValue;

        private PoissonizedBlockCursor(BlockCursor delegate, long seed) {
            Preconditions.checkArgument((boolean)delegate.getTupleInfo().equals(TupleInfo.SINGLE_LONG), (Object)"delegate must be a cursor of longs");
            this.delegate = delegate;
            this.rand.reSeed(seed);
        }

        @Override
        public TupleInfo getTupleInfo() {
            return TupleInfo.SINGLE_LONG;
        }

        @Override
        public int getRemainingPositions() {
            return this.delegate.getRemainingPositions();
        }

        @Override
        public boolean isValid() {
            return this.delegate.isValid();
        }

        @Override
        public boolean isFinished() {
            return this.delegate.isFinished();
        }

        @Override
        public boolean advanceNextPosition() {
            boolean advanced = this.delegate.advanceNextPosition();
            if (advanced) {
                this.currentValue = this.rand.nextPoisson((double)this.delegate.getLong());
            }
            return advanced;
        }

        @Override
        public boolean advanceToPosition(int position) {
            boolean advanced = false;
            while (this.getPosition() < position && (advanced = this.advanceNextPosition())) {
            }
            return advanced;
        }

        @Override
        public Block getRegionAndAdvance(int length) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Tuple getTuple() {
            return TupleInfo.SINGLE_LONG.builder().append(this.currentValue).build();
        }

        @Override
        public boolean getBoolean() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long getLong() {
            return this.currentValue;
        }

        @Override
        public double getDouble() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Slice getSlice() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isNull() {
            Preconditions.checkState((!this.delegate.isNull() ? 1 : 0) != 0, (Object)"delegate to poissonized cursor returned a null row");
            return false;
        }

        @Override
        public int getPosition() {
            return this.delegate.getPosition();
        }

        @Override
        public boolean currentTupleEquals(Tuple value) {
            return value.getTupleInfo().equals(TupleInfo.SINGLE_LONG) && value.getLong() == this.currentValue;
        }

        @Override
        public int getRawOffset() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Slice getRawSlice() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void appendTupleTo(BlockBuilder blockBuilder) {
            blockBuilder.append(this.currentValue);
        }
    }
}

