/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.block.Block;
import com.facebook.presto.block.BlockBuilder;
import com.facebook.presto.block.BlockCursor;
import com.facebook.presto.operator.GroupByIdBlock;
import com.facebook.presto.operator.aggregation.Accumulator;
import com.facebook.presto.operator.aggregation.GroupedAccumulator;
import com.facebook.presto.operator.aggregation.SimpleAggregationFunction;
import com.facebook.presto.tuple.TupleInfo;
import com.facebook.presto.util.array.ObjectBigArray;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import io.airlift.slice.Slice;

public class VarBinaryMinAggregation
extends SimpleAggregationFunction {
    public static final VarBinaryMinAggregation VAR_BINARY_MIN = new VarBinaryMinAggregation();

    public VarBinaryMinAggregation() {
        super(TupleInfo.SINGLE_VARBINARY, TupleInfo.SINGLE_VARBINARY, TupleInfo.Type.VARIABLE_BINARY);
    }

    @Override
    protected GroupedAccumulator createGroupedAccumulator(Optional<Integer> maskChannel, Optional<Integer> sampleWeightChannel, double confidence, int valueChannel) {
        Preconditions.checkArgument((confidence == 1.0 ? 1 : 0) != 0, (Object)"min does not support approximate queries");
        return new VarBinaryGroupedAccumulator(valueChannel);
    }

    @Override
    protected Accumulator createAccumulator(Optional<Integer> maskChannel, Optional<Integer> sampleWeightChannel, double confidence, int valueChannel) {
        Preconditions.checkArgument((confidence == 1.0 ? 1 : 0) != 0, (Object)"min does not support approximate queries");
        return new VarBinaryMinAccumulator(valueChannel);
    }

    private static Slice min(Slice a, Slice b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        return a.compareTo(b) < 0 ? a : b;
    }

    public static class VarBinaryMinAccumulator
    extends SimpleAggregationFunction.SimpleAccumulator {
        private Slice min;

        public VarBinaryMinAccumulator(int valueChannel) {
            super(valueChannel, TupleInfo.SINGLE_VARBINARY, TupleInfo.SINGLE_VARBINARY, (Optional<Integer>)Optional.absent(), (Optional<Integer>)Optional.absent());
        }

        @Override
        protected void processInput(Block block, Optional<Block> maskBlock, Optional<Block> sampleWeightBlock) {
            BlockCursor values = block.cursor();
            for (int position = 0; position < block.getPositionCount(); ++position) {
                Preconditions.checkState((boolean)values.advanceNextPosition());
                if (values.isNull()) continue;
                this.min = VarBinaryMinAggregation.min(this.min, values.getSlice());
            }
        }

        @Override
        public void evaluateFinal(BlockBuilder out) {
            if (this.min != null) {
                out.append(this.min);
            } else {
                out.appendNull();
            }
        }
    }

    public static class VarBinaryGroupedAccumulator
    extends SimpleAggregationFunction.SimpleGroupedAccumulator {
        private final ObjectBigArray<Slice> minValues = new ObjectBigArray();
        private long sizeOfValues;

        public VarBinaryGroupedAccumulator(int valueChannel) {
            super(valueChannel, TupleInfo.SINGLE_VARBINARY, TupleInfo.SINGLE_VARBINARY, (Optional<Integer>)Optional.absent(), (Optional<Integer>)Optional.absent());
        }

        @Override
        public long getEstimatedSize() {
            return this.minValues.sizeOf() + this.sizeOfValues;
        }

        @Override
        protected void processInput(GroupByIdBlock groupIdsBlock, Block valuesBlock, Optional<Block> maskBlock, Optional<Block> sampleWeightBlock) {
            this.minValues.ensureCapacity(groupIdsBlock.getGroupCount());
            BlockCursor values = valuesBlock.cursor();
            for (int position = 0; position < groupIdsBlock.getPositionCount(); ++position) {
                Preconditions.checkState((boolean)values.advanceNextPosition());
                if (values.isNull()) continue;
                long groupId = groupIdsBlock.getGroupId(position);
                Slice value = values.getSlice();
                Slice currentValue = this.minValues.get(groupId);
                if (currentValue != null && value.compareTo(currentValue) >= 0) continue;
                this.minValues.set(groupId, value);
                if (currentValue != null) {
                    this.sizeOfValues -= (long)currentValue.length();
                }
                this.sizeOfValues += (long)value.length();
            }
            Preconditions.checkState((!values.advanceNextPosition() ? 1 : 0) != 0);
        }

        @Override
        public void evaluateFinal(int groupId, BlockBuilder output) {
            Slice value = this.minValues.get(groupId);
            if (value == null) {
                output.appendNull();
            } else {
                output.append(value);
            }
        }
    }
}

