/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.serde;

import com.facebook.presto.block.Block;
import com.facebook.presto.block.BlockIterable;
import com.facebook.presto.serde.BlockEncoding;
import com.facebook.presto.serde.BlockEncodings;
import com.facebook.presto.serde.BlocksFileStats;
import com.facebook.presto.serde.EncodedBlockIterable;
import com.facebook.presto.tuple.TupleInfo;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import io.airlift.slice.BasicSliceInput;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceInput;
import io.airlift.units.DataSize;
import java.util.Iterator;

public class BlocksFileReader
implements BlockIterable {
    private final BlockEncoding blockEncoding;
    private final Slice blocksSlice;
    private final BlockIterable blockIterable;
    private final BlocksFileStats stats;

    public static BlocksFileReader readBlocks(Slice slice) {
        return new BlocksFileReader(slice);
    }

    public BlocksFileReader(Slice slice) {
        Preconditions.checkNotNull((Object)slice, (Object)"slice is null");
        int footerLength = slice.getInt(slice.length() - 4);
        int footerOffset = slice.length() - footerLength - 4;
        Slice footerSlice = slice.slice(footerOffset, footerLength);
        BasicSliceInput input = footerSlice.getInput();
        this.blockEncoding = BlockEncodings.readBlockEncoding((SliceInput)input);
        this.stats = BlocksFileStats.deserialize((SliceInput)input);
        this.blocksSlice = slice.slice(0, footerOffset);
        this.blockIterable = new EncodedBlockIterable(this.blockEncoding, this.blocksSlice, Ints.checkedCast((long)this.stats.getRowCount()));
    }

    @Override
    public TupleInfo getTupleInfo() {
        return this.blockEncoding.getTupleInfo();
    }

    @Override
    public Optional<DataSize> getDataSize() {
        return this.blockIterable.getDataSize();
    }

    @Override
    public Optional<Integer> getPositionCount() {
        return this.blockIterable.getPositionCount();
    }

    public BlockEncoding getEncoding() {
        return this.blockEncoding;
    }

    public BlocksFileStats getStats() {
        return this.stats;
    }

    @Override
    public Iterator<Block> iterator() {
        return this.blockIterable.iterator();
    }
}

