/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.serde;

import com.facebook.presto.block.Block;
import com.facebook.presto.block.BlockUtils;
import com.facebook.presto.serde.BlockEncoding;
import com.facebook.presto.serde.BlockEncodings;
import com.facebook.presto.serde.BlocksFileEncoding;
import com.facebook.presto.serde.BlocksFileStats;
import com.facebook.presto.serde.Encoder;
import com.facebook.presto.tuple.Tuple;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.io.OutputSupplier;
import io.airlift.slice.OutputStreamSliceOutput;
import io.airlift.slice.SliceOutput;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class BlocksFileWriter
implements Closeable {
    private final BlocksFileEncoding encoding;
    private final OutputSupplier<? extends OutputStream> outputSupplier;
    private final StatsBuilder statsBuilder = new StatsBuilder();
    private Encoder encoder;
    private SliceOutput sliceOutput;
    private boolean closed;

    public static void writeBlocks(BlocksFileEncoding encoding, OutputSupplier<? extends OutputStream> sliceOutput, Block ... blocks) {
        BlocksFileWriter.writeBlocks(encoding, sliceOutput, (Iterable<? extends Block>)ImmutableList.copyOf((Object[])blocks));
    }

    public static void writeBlocks(BlocksFileEncoding encoding, OutputSupplier<? extends OutputStream> sliceOutput, Iterable<? extends Block> blocks) {
        BlocksFileWriter.writeBlocks(encoding, sliceOutput, blocks.iterator());
    }

    public static void writeBlocks(BlocksFileEncoding encoding, OutputSupplier<? extends OutputStream> sliceOutput, Iterator<? extends Block> blocks) {
        Preconditions.checkNotNull(sliceOutput, (Object)"sliceOutput is null");
        BlocksFileWriter fileWriter = new BlocksFileWriter(encoding, sliceOutput);
        while (blocks.hasNext()) {
            fileWriter.append(BlockUtils.toTupleIterable(blocks.next()));
        }
        fileWriter.close();
    }

    public BlocksFileWriter(BlocksFileEncoding encoding, OutputSupplier<? extends OutputStream> outputSupplier) {
        Preconditions.checkNotNull((Object)((Object)encoding), (Object)"encoding is null");
        Preconditions.checkNotNull(outputSupplier, (Object)"outputSupplier is null");
        this.encoding = encoding;
        this.outputSupplier = outputSupplier;
    }

    public BlocksFileWriter append(Iterable<Tuple> tuples) {
        Preconditions.checkNotNull(tuples, (Object)"tuples is null");
        if (!Iterables.isEmpty(tuples)) {
            if (this.encoder == null) {
                this.open();
            }
            this.statsBuilder.process(tuples);
            this.encoder.append(tuples);
        }
        return this;
    }

    private void open() {
        try {
            OutputStream outputStream = (OutputStream)this.outputSupplier.getOutput();
            this.sliceOutput = outputStream instanceof SliceOutput ? (SliceOutput)outputStream : new OutputStreamSliceOutput(outputStream);
            this.encoder = this.encoding.createBlocksWriter(this.sliceOutput);
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (this.encoder == null) {
            this.createEmptyFile();
            return;
        }
        BlockEncoding blockEncoding = this.encoder.finish();
        int startingIndex = this.sliceOutput.size();
        BlockEncodings.writeBlockEncoding(this.sliceOutput, blockEncoding);
        BlocksFileStats.serialize(this.statsBuilder.build(), this.sliceOutput);
        int footerSize = this.sliceOutput.size() - startingIndex;
        Preconditions.checkState((footerSize > 0 ? 1 : 0) != 0);
        this.sliceOutput.writeInt(footerSize);
        try {
            this.sliceOutput.close();
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private void createEmptyFile() {
        try {
            ((OutputStream)this.outputSupplier.getOutput()).close();
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private static class StatsBuilder {
        private static final int MAX_UNIQUE_COUNT = 1000;
        private long rowCount;
        private long runsCount;
        private Tuple lastTuple;
        private final Set<Tuple> set = new HashSet<Tuple>(1000);

        private StatsBuilder() {
        }

        public void process(Iterable<Tuple> tuples) {
            Preconditions.checkNotNull(tuples, (Object)"tuples is null");
            for (Tuple tuple : tuples) {
                if (this.lastTuple == null) {
                    this.lastTuple = tuple;
                    if (this.set.size() < 1000) {
                        this.set.add(this.lastTuple);
                    }
                } else if (!tuple.equals(this.lastTuple)) {
                    ++this.runsCount;
                    this.lastTuple = tuple;
                    if (this.set.size() < 1000) {
                        this.set.add(this.lastTuple);
                    }
                }
                ++this.rowCount;
            }
        }

        public BlocksFileStats build() {
            return new BlocksFileStats(this.rowCount, this.runsCount + 1L, this.rowCount / (this.runsCount + 1L), this.set.size() == 1000 ? Integer.MAX_VALUE : this.set.size());
        }
    }
}

