/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.serde;

import com.facebook.presto.block.dictionary.Dictionary;
import com.facebook.presto.serde.BlockEncoding;
import com.facebook.presto.serde.DictionaryBlockEncoding;
import com.facebook.presto.serde.Encoder;
import com.facebook.presto.tuple.Tuple;
import com.facebook.presto.tuple.TupleInfo;
import com.facebook.presto.tuple.Tuples;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;

public class DictionaryEncoder
implements Encoder {
    private final Encoder idWriter;
    private TupleInfo tupleInfo;
    private Dictionary.DictionaryBuilder dictionaryBuilder;
    private boolean finished;

    public DictionaryEncoder(Encoder idWriter) {
        this.idWriter = (Encoder)Preconditions.checkNotNull((Object)idWriter, (Object)"idWriter is null");
    }

    @Override
    public Encoder append(Iterable<Tuple> tuples) {
        Preconditions.checkNotNull(tuples, (Object)"tuples is null");
        Preconditions.checkState((!this.finished ? 1 : 0) != 0, (Object)"already finished");
        Iterable idTuples = Iterables.transform(tuples, (Function)new Function<Tuple, Tuple>(){

            public Tuple apply(Tuple tuple) {
                if (DictionaryEncoder.this.tupleInfo == null) {
                    DictionaryEncoder.this.tupleInfo = tuple.getTupleInfo();
                    DictionaryEncoder.this.dictionaryBuilder = new Dictionary.DictionaryBuilder(DictionaryEncoder.this.tupleInfo);
                }
                long id = DictionaryEncoder.this.dictionaryBuilder.getId(tuple);
                return Tuples.createTuple(id);
            }
        });
        this.idWriter.append(idTuples);
        return this;
    }

    @Override
    public BlockEncoding finish() {
        Preconditions.checkState((this.tupleInfo != null ? 1 : 0) != 0, (Object)"nothing appended");
        Preconditions.checkState((!this.finished ? 1 : 0) != 0, (Object)"already finished");
        this.finished = true;
        return new DictionaryBlockEncoding(this.dictionaryBuilder.build(), this.idWriter.finish());
    }
}

