/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.serde;

import com.facebook.presto.block.rle.RunLengthEncodedBlock;
import com.facebook.presto.serde.BlockEncoding;
import com.facebook.presto.serde.Encoder;
import com.facebook.presto.serde.RunLengthBlockEncoding;
import com.facebook.presto.tuple.Tuple;
import com.google.common.base.Preconditions;
import io.airlift.slice.SliceOutput;

public class RunLengthEncoder
implements Encoder {
    private final SliceOutput sliceOutput;
    private boolean finished;
    private int tupleCount = -1;
    private Tuple lastTuple;
    private RunLengthBlockEncoding encoding;

    public RunLengthEncoder(SliceOutput sliceOutput) {
        this.sliceOutput = (SliceOutput)Preconditions.checkNotNull((Object)sliceOutput, (Object)"sliceOutput is null");
    }

    @Override
    public Encoder append(Iterable<Tuple> tuples) {
        Preconditions.checkNotNull(tuples, (Object)"tuples is null");
        Preconditions.checkState((!this.finished ? 1 : 0) != 0, (Object)"already finished");
        for (Tuple tuple : tuples) {
            if (this.encoding == null) {
                this.encoding = new RunLengthBlockEncoding(tuple.getTupleInfo());
                this.tupleCount = 1;
                this.lastTuple = tuple;
                continue;
            }
            if (!tuple.equals(this.lastTuple)) {
                this.writeBlock();
                this.lastTuple = tuple;
            }
            ++this.tupleCount;
        }
        return this;
    }

    private void writeBlock() {
        RunLengthEncodedBlock block = new RunLengthEncodedBlock(this.lastTuple, this.tupleCount);
        this.encoding.writeBlock(this.sliceOutput, block);
        this.tupleCount = 0;
    }

    @Override
    public BlockEncoding finish() {
        Preconditions.checkState((this.encoding != null ? 1 : 0) != 0, (Object)"nothing appended");
        Preconditions.checkState((!this.finished ? 1 : 0) != 0, (Object)"already finished");
        this.finished = true;
        this.writeBlock();
        return this.encoding;
    }
}

