/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.serde;

import com.facebook.presto.block.Block;
import com.facebook.presto.block.snappy.SnappyBlock;
import com.facebook.presto.serde.BlockEncoding;
import com.facebook.presto.serde.TupleInfoSerde;
import com.facebook.presto.tuple.TupleInfo;
import com.google.common.base.Preconditions;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceInput;
import io.airlift.slice.SliceOutput;

public class SnappyBlockEncoding
implements BlockEncoding {
    private final TupleInfo tupleInfo;

    public SnappyBlockEncoding(SliceInput input) {
        Preconditions.checkNotNull((Object)input, (Object)"input is null");
        this.tupleInfo = TupleInfoSerde.readTupleInfo(input);
    }

    public SnappyBlockEncoding(TupleInfo tupleInfo) {
        Preconditions.checkNotNull((Object)tupleInfo, (Object)"tupleInfo is null");
        this.tupleInfo = tupleInfo;
    }

    @Override
    public TupleInfo getTupleInfo() {
        return this.tupleInfo;
    }

    @Override
    public void writeBlock(SliceOutput sliceOutput, Block block) {
        SnappyBlock snappyBlock = (SnappyBlock)block;
        Preconditions.checkArgument((boolean)block.getTupleInfo().equals(this.tupleInfo), (Object)"Invalid tuple info");
        Slice slice = snappyBlock.getCompressedSlice();
        sliceOutput.appendInt(slice.length()).appendInt(snappyBlock.getPositionCount()).writeBytes(slice);
    }

    @Override
    public Block readBlock(SliceInput sliceInput) {
        int blockSize = sliceInput.readInt();
        int tupleCount = sliceInput.readInt();
        Slice block = sliceInput.readSlice(blockSize);
        return new SnappyBlock(tupleCount, this.tupleInfo, block);
    }

    public static void serialize(SliceOutput output, SnappyBlockEncoding encoding) {
        TupleInfoSerde.writeTupleInfo(output, encoding.getTupleInfo());
    }
}

