/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.serde;

import com.facebook.presto.block.snappy.SnappyBlock;
import com.facebook.presto.serde.BlockEncoding;
import com.facebook.presto.serde.Encoder;
import com.facebook.presto.serde.SnappyBlockEncoding;
import com.facebook.presto.tuple.Tuple;
import com.google.common.base.Preconditions;
import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;
import io.airlift.slice.Slices;
import io.airlift.units.DataSize;
import java.util.Arrays;
import org.iq80.snappy.Snappy;

public class SnappyEncoder
implements Encoder {
    public static final int MAX_UNCOMPRESSED_BLOCK_SIZE = (int)new DataSize(1.0, DataSize.Unit.MEGABYTE).toBytes();
    private final SliceOutput sliceOutput;
    private final DynamicSliceOutput buffer = new DynamicSliceOutput(MAX_UNCOMPRESSED_BLOCK_SIZE);
    private SnappyBlockEncoding encoding;
    private boolean finished;
    private int tupleCount;

    public SnappyEncoder(SliceOutput sliceOutput) {
        this.sliceOutput = (SliceOutput)Preconditions.checkNotNull((Object)sliceOutput, (Object)"sliceOutput is null");
    }

    @Override
    public Encoder append(Iterable<Tuple> tuples) {
        Preconditions.checkNotNull(tuples, (Object)"tuples is null");
        Preconditions.checkState((!this.finished ? 1 : 0) != 0, (Object)"already finished");
        for (Tuple tuple : tuples) {
            if (this.encoding == null) {
                this.encoding = new SnappyBlockEncoding(tuple.getTupleInfo());
            }
            tuple.writeTo((SliceOutput)this.buffer);
            ++this.tupleCount;
            if (this.buffer.size() < MAX_UNCOMPRESSED_BLOCK_SIZE) continue;
            this.flushBlock();
        }
        return this;
    }

    @Override
    public BlockEncoding finish() {
        Preconditions.checkState((this.encoding != null ? 1 : 0) != 0, (Object)"nothing appended");
        Preconditions.checkState((!this.finished ? 1 : 0) != 0, (Object)"already finished");
        this.finished = true;
        this.flushBlock();
        return this.encoding;
    }

    private void flushBlock() {
        if (this.buffer.size() > 0) {
            Slice slice = this.buffer.slice();
            byte[] compressedBytes = new byte[Snappy.maxCompressedLength((int)slice.length())];
            int actualLength = Snappy.compress((byte[])slice.getBytes(), (int)0, (int)slice.length(), (byte[])compressedBytes, (int)0);
            SnappyBlock block = new SnappyBlock(this.tupleCount, this.encoding.getTupleInfo(), Slices.wrappedBuffer((byte[])Arrays.copyOf(compressedBytes, actualLength)));
            this.encoding.writeBlock(this.sliceOutput, block);
            this.buffer.reset();
            this.tupleCount = 0;
        }
    }
}

