/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.serde;

import com.facebook.presto.block.Block;
import com.facebook.presto.block.uncompressed.UncompressedBlock;
import com.facebook.presto.serde.BlockEncoding;
import com.facebook.presto.serde.TupleInfoSerde;
import com.facebook.presto.tuple.TupleInfo;
import com.google.common.base.Preconditions;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceInput;
import io.airlift.slice.SliceOutput;

public class UncompressedBlockEncoding
implements BlockEncoding {
    private final TupleInfo tupleInfo;

    public UncompressedBlockEncoding(TupleInfo tupleInfo) {
        Preconditions.checkNotNull((Object)tupleInfo, (Object)"tupleInfo is null");
        this.tupleInfo = tupleInfo;
    }

    public UncompressedBlockEncoding(SliceInput input) {
        Preconditions.checkNotNull((Object)input, (Object)"input is null");
        this.tupleInfo = TupleInfoSerde.readTupleInfo(input);
    }

    @Override
    public TupleInfo getTupleInfo() {
        return this.tupleInfo;
    }

    @Override
    public void writeBlock(SliceOutput sliceOutput, Block block) {
        UncompressedBlock uncompressedBlock = (UncompressedBlock)block;
        Preconditions.checkArgument((boolean)block.getTupleInfo().equals(this.tupleInfo), (Object)"Invalid tuple info");
        UncompressedBlockEncoding.writeUncompressedBlock(sliceOutput, uncompressedBlock.getPositionCount(), uncompressedBlock.getSlice());
    }

    @Override
    public Block readBlock(SliceInput sliceInput) {
        int blockSize = sliceInput.readInt();
        int tupleCount = sliceInput.readInt();
        Slice block = sliceInput.readSlice(blockSize);
        return new UncompressedBlock(tupleCount, this.tupleInfo, block);
    }

    private static void writeUncompressedBlock(SliceOutput destination, int tupleCount, Slice slice) {
        destination.appendInt(slice.length()).appendInt(tupleCount).writeBytes(slice);
    }

    public static void serialize(SliceOutput output, UncompressedBlockEncoding encoding) {
        TupleInfoSerde.writeTupleInfo(output, encoding.tupleInfo);
    }
}

