/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.serde;

import com.facebook.presto.block.uncompressed.UncompressedBlock;
import com.facebook.presto.serde.BlockEncoding;
import com.facebook.presto.serde.Encoder;
import com.facebook.presto.serde.UncompressedBlockEncoding;
import com.facebook.presto.tuple.Tuple;
import com.google.common.base.Preconditions;
import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;
import io.airlift.units.DataSize;

public class UncompressedEncoder
implements Encoder {
    private static final int MAX_BLOCK_SIZE = (int)new DataSize(64.0, DataSize.Unit.KILOBYTE).toBytes();
    private final SliceOutput sliceOutput;
    private final DynamicSliceOutput buffer = new DynamicSliceOutput(MAX_BLOCK_SIZE);
    private UncompressedBlockEncoding encoding;
    private boolean finished;
    private int tupleCount;

    public UncompressedEncoder(SliceOutput sliceOutput) {
        this.sliceOutput = (SliceOutput)Preconditions.checkNotNull((Object)sliceOutput, (Object)"sliceOutput is null");
    }

    @Override
    public Encoder append(Iterable<Tuple> tuples) {
        Preconditions.checkNotNull(tuples, (Object)"tuples is null");
        Preconditions.checkState((!this.finished ? 1 : 0) != 0, (Object)"already finished");
        for (Tuple tuple : tuples) {
            if (this.encoding == null) {
                this.encoding = new UncompressedBlockEncoding(tuple.getTupleInfo());
            }
            tuple.writeTo((SliceOutput)this.buffer);
            ++this.tupleCount;
            if (this.buffer.size() < MAX_BLOCK_SIZE) continue;
            this.writeBlock();
        }
        return this;
    }

    @Override
    public BlockEncoding finish() {
        Preconditions.checkState((this.encoding != null ? 1 : 0) != 0, (Object)"nothing appended");
        Preconditions.checkState((!this.finished ? 1 : 0) != 0, (Object)"already finished");
        this.finished = true;
        if (this.buffer.size() > 0) {
            this.writeBlock();
        }
        return this.encoding;
    }

    private void writeBlock() {
        Slice slice = this.buffer.slice();
        UncompressedBlock block = new UncompressedBlock(this.tupleCount, this.encoding.getTupleInfo(), slice);
        this.encoding.writeBlock(this.sliceOutput, block);
        this.buffer.reset();
        this.tupleCount = 0;
    }
}

