/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.split;

import com.facebook.presto.spi.HostAddress;
import com.facebook.presto.spi.Split;
import com.facebook.presto.tuple.TupleInfo;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.net.URI;
import java.util.List;

public class RemoteSplit
implements Split {
    private final URI location;
    private final List<TupleInfo> tupleInfos;

    @JsonCreator
    public RemoteSplit(@JsonProperty(value="location") URI location, @JsonProperty(value="tupleInfos") List<TupleInfo> tupleInfos) {
        Preconditions.checkNotNull((Object)location, (Object)"location is null");
        Preconditions.checkNotNull(tupleInfos, (Object)"tupleInfos is null");
        this.location = location;
        this.tupleInfos = ImmutableList.copyOf(tupleInfos);
    }

    @JsonProperty
    public URI getLocation() {
        return this.location;
    }

    @JsonProperty
    public List<TupleInfo> getTupleInfos() {
        return this.tupleInfos;
    }

    public Object getInfo() {
        return this;
    }

    public boolean isRemotelyAccessible() {
        return true;
    }

    public List<HostAddress> getAddresses() {
        return ImmutableList.of();
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("location", (Object)this.location).add("tupleInfos", this.tupleInfos).toString();
    }
}

