/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.split;

import com.facebook.presto.spi.ConnectorSplitManager;
import com.facebook.presto.spi.Partition;
import com.facebook.presto.spi.PartitionResult;
import com.facebook.presto.spi.SplitSource;
import com.facebook.presto.spi.TableHandle;
import com.facebook.presto.spi.TupleDomain;
import com.google.common.base.Optional;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class SplitManager {
    private final Set<ConnectorSplitManager> splitManagers = Sets.newSetFromMap(new ConcurrentHashMap());

    @Inject
    public SplitManager(Set<ConnectorSplitManager> splitManagers) {
        this.splitManagers.addAll(splitManagers);
    }

    public void addConnectorSplitManager(ConnectorSplitManager connectorSplitManager) {
        this.splitManagers.add(connectorSplitManager);
    }

    public PartitionResult getPartitions(TableHandle table, Optional<TupleDomain> tupleDomain) {
        return this.getConnectorSplitManager(table).getPartitions(table, (TupleDomain)tupleDomain.or((Object)TupleDomain.all()));
    }

    public SplitSource getPartitionSplits(TableHandle handle, List<Partition> partitions) {
        ConnectorSplitManager connectorSplitManager = this.getConnectorSplitManager(handle);
        return connectorSplitManager.getPartitionSplits(handle, partitions);
    }

    private ConnectorSplitManager getConnectorSplitManager(TableHandle handle) {
        for (ConnectorSplitManager connectorSplitManager : this.splitManagers) {
            if (!connectorSplitManager.canHandle(handle)) continue;
            return connectorSplitManager;
        }
        throw new IllegalArgumentException("No split manager for " + handle);
    }
}

