/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql;

import com.facebook.presto.operator.scalar.MathFunctions;
import com.google.common.base.Charsets;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.nio.charset.Charset;

public final class Casts {
    private static final Slice TRUE = Slices.copiedBuffer((String)"true", (Charset)Charsets.US_ASCII);
    private static final Slice FALSE = Slices.copiedBuffer((String)"false", (Charset)Charsets.US_ASCII);

    private Casts() {
    }

    public static Object toBoolean(Object value) {
        try {
            if (value instanceof Boolean) {
                return value;
            }
            if (value instanceof Long) {
                return (Long)value != 0L;
            }
            if (value instanceof Double) {
                return (Double)value != 0.0;
            }
            if (value instanceof Slice) {
                String stringValue = ((Slice)value).toString(Charsets.UTF_8).toLowerCase();
                if (stringValue.equals("t") || stringValue.equals("true") || stringValue.equals("1")) {
                    return true;
                }
                if (stringValue.equals("f") || stringValue.equals("false") || stringValue.equals("0")) {
                    return false;
                }
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        if (value instanceof Slice) {
            value = "'" + ((Slice)value).toString(Charsets.UTF_8) + "'";
        }
        throw new IllegalArgumentException(String.format("Cannot cast %s to BOOLEAN", value));
    }

    public static Object toLong(Object value) {
        try {
            if (value instanceof Long) {
                return value;
            }
            if (value instanceof Boolean) {
                return (Boolean)value != false ? 1L : 0L;
            }
            if (value instanceof Slice) {
                String stringValue = ((Slice)value).toString(Charsets.UTF_8);
                return Long.parseLong(stringValue);
            }
            if (value instanceof Double) {
                return (long)MathFunctions.round((Double)value);
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        if (value instanceof Slice) {
            value = "'" + ((Slice)value).toString(Charsets.UTF_8) + "'";
        }
        throw new IllegalArgumentException(String.format("Cannot cast %s to BIGINT", value));
    }

    public static Object toSlice(Object value) {
        try {
            if (value instanceof Slice) {
                return value;
            }
            if (value instanceof Long || value instanceof Double) {
                return Slices.copiedBuffer((String)value.toString(), (Charset)Charsets.US_ASCII);
            }
            if (value instanceof Boolean) {
                return (Boolean)value != false ? TRUE : FALSE;
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        throw new IllegalArgumentException(String.format("Cannot cast %s to VARCHAR", value));
    }

    public static Object toDouble(Object value) {
        try {
            if (value instanceof Double) {
                return value;
            }
            if (value instanceof Boolean) {
                return (Boolean)value != false ? 1.0 : 0.0;
            }
            if (value instanceof Long) {
                return ((Long)value).doubleValue();
            }
            if (value instanceof Slice) {
                String stringValue = ((Slice)value).toString(Charsets.UTF_8);
                return Double.parseDouble(stringValue);
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        if (value instanceof Slice) {
            value = "'" + ((Slice)value).toString(Charsets.UTF_8) + "'";
        }
        throw new IllegalArgumentException(String.format("Cannot cast %s to DOUBLE", value));
    }
}

