/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql;

import com.facebook.presto.sql.planner.DependencyExtractor;
import com.facebook.presto.sql.planner.DeterminismEvaluator;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.tree.BooleanLiteral;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.IsNullPredicate;
import com.facebook.presto.sql.tree.LogicalBinaryExpression;
import com.facebook.presto.sql.tree.QualifiedNameReference;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public final class ExpressionUtils {
    private ExpressionUtils() {
    }

    public static List<Expression> extractConjuncts(Expression expression) {
        if (expression instanceof LogicalBinaryExpression && ((LogicalBinaryExpression)expression).getType() == LogicalBinaryExpression.Type.AND) {
            LogicalBinaryExpression and = (LogicalBinaryExpression)expression;
            return ImmutableList.builder().addAll(ExpressionUtils.extractConjuncts(and.getLeft())).addAll(ExpressionUtils.extractConjuncts(and.getRight())).build();
        }
        return ImmutableList.of((Object)expression);
    }

    public static List<Expression> extractDisjuncts(Expression expression) {
        if (expression instanceof LogicalBinaryExpression && ((LogicalBinaryExpression)expression).getType() == LogicalBinaryExpression.Type.OR) {
            LogicalBinaryExpression or = (LogicalBinaryExpression)expression;
            return ImmutableList.builder().addAll(ExpressionUtils.extractDisjuncts(or.getLeft())).addAll(ExpressionUtils.extractDisjuncts(or.getRight())).build();
        }
        return ImmutableList.of((Object)expression);
    }

    public static Expression and(Expression ... expressions) {
        return ExpressionUtils.and(Arrays.asList(expressions));
    }

    public static Expression and(Iterable<Expression> expressions) {
        return ExpressionUtils.binaryExpression(LogicalBinaryExpression.Type.AND, expressions);
    }

    public static Expression or(Expression ... expressions) {
        return ExpressionUtils.or(Arrays.asList(expressions));
    }

    public static Expression or(Iterable<Expression> expressions) {
        return ExpressionUtils.binaryExpression(LogicalBinaryExpression.Type.OR, expressions);
    }

    public static Expression binaryExpression(LogicalBinaryExpression.Type type, Iterable<Expression> expressions) {
        Preconditions.checkNotNull((Object)type, (Object)"type is null");
        Preconditions.checkNotNull(expressions, (Object)"expressions is null");
        Preconditions.checkArgument((!Iterables.isEmpty(expressions) ? 1 : 0) != 0, (Object)"expressions is empty");
        Iterator<Expression> iterator = expressions.iterator();
        Expression result = iterator.next();
        while (iterator.hasNext()) {
            result = new LogicalBinaryExpression(type, result, iterator.next());
        }
        return result;
    }

    public static Expression combineConjuncts(Expression ... expressions) {
        return ExpressionUtils.combineConjuncts(Arrays.asList(expressions));
    }

    public static Expression combineConjuncts(Iterable<Expression> expressions) {
        return ExpressionUtils.combineConjunctsWithDefault(expressions, (Expression)BooleanLiteral.TRUE_LITERAL);
    }

    public static Expression combineConjunctsWithDefault(Iterable<Expression> expressions, Expression emptyDefault) {
        Preconditions.checkNotNull(expressions, (Object)"expressions is null");
        expressions = Iterables.concat((Iterable)Iterables.transform(expressions, (Function)new Function<Expression, Iterable<Expression>>(){

            public Iterable<Expression> apply(Expression expression) {
                return ExpressionUtils.extractConjuncts(expression);
            }
        }));
        expressions = Iterables.filter((Iterable)expressions, (Predicate)Predicates.not((Predicate)Predicates.equalTo((Object)BooleanLiteral.TRUE_LITERAL)));
        expressions = ExpressionUtils.removeDuplicates(expressions);
        return Iterables.isEmpty(expressions) ? emptyDefault : ExpressionUtils.and(expressions);
    }

    public static Expression combineDisjuncts(Expression ... expressions) {
        return ExpressionUtils.combineDisjuncts(Arrays.asList(expressions));
    }

    public static Expression combineDisjuncts(Iterable<Expression> expressions) {
        return ExpressionUtils.combineDisjunctsWithDefault(expressions, (Expression)BooleanLiteral.FALSE_LITERAL);
    }

    public static Expression combineDisjunctsWithDefault(Iterable<Expression> expressions, Expression emptyDefault) {
        Preconditions.checkNotNull(expressions, (Object)"expressions is null");
        expressions = Iterables.concat((Iterable)Iterables.transform(expressions, (Function)new Function<Expression, Iterable<Expression>>(){

            public Iterable<Expression> apply(Expression expression) {
                return ExpressionUtils.extractDisjuncts(expression);
            }
        }));
        expressions = Iterables.filter((Iterable)expressions, (Predicate)Predicates.not((Predicate)Predicates.equalTo((Object)BooleanLiteral.FALSE_LITERAL)));
        expressions = ExpressionUtils.removeDuplicates(expressions);
        return Iterables.isEmpty(expressions) ? emptyDefault : ExpressionUtils.or(expressions);
    }

    public static Function<Symbol, QualifiedNameReference> symbolToQualifiedNameReference() {
        return new Function<Symbol, QualifiedNameReference>(){

            public QualifiedNameReference apply(Symbol symbol) {
                return new QualifiedNameReference(symbol.toQualifiedName());
            }
        };
    }

    public static Expression stripNonDeterministicConjuncts(Expression expression) {
        return ExpressionUtils.combineConjuncts(Iterables.filter(ExpressionUtils.extractConjuncts(expression), DeterminismEvaluator.deterministic()));
    }

    public static Function<Expression, Expression> expressionOrNullSymbols(final Predicate<Symbol> nullSymbolScope) {
        return new Function<Expression, Expression>(){

            public Expression apply(Expression expression) {
                Iterable symbols = Iterables.filter(DependencyExtractor.extractUnique(expression), (Predicate)nullSymbolScope);
                if (Iterables.isEmpty((Iterable)symbols)) {
                    return expression;
                }
                ImmutableList.Builder nullConjuncts = ImmutableList.builder();
                for (Symbol symbol : symbols) {
                    nullConjuncts.add((Object)new IsNullPredicate((Expression)new QualifiedNameReference(symbol.toQualifiedName())));
                }
                return ExpressionUtils.or(expression, ExpressionUtils.and((Iterable<Expression>)nullConjuncts.build()));
            }
        };
    }

    private static Iterable<Expression> removeDuplicates(Iterable<Expression> expressions) {
        Iterable nonDeterministicDisjuncts = Iterables.filter(expressions, (Predicate)Predicates.not(DeterminismEvaluator.deterministic()));
        ImmutableSet deterministicDisjuncts = ImmutableSet.copyOf((Iterable)Iterables.filter(expressions, DeterminismEvaluator.deterministic()));
        return Iterables.concat((Iterable)nonDeterministicDisjuncts, (Iterable)deterministicDisjuncts);
    }
}

