/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.analyzer;

import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.sql.analyzer.AggregateExtractor;
import com.facebook.presto.sql.analyzer.FieldOrExpression;
import com.facebook.presto.sql.analyzer.SemanticErrorCode;
import com.facebook.presto.sql.analyzer.SemanticException;
import com.facebook.presto.sql.analyzer.TupleDescriptor;
import com.facebook.presto.sql.analyzer.WindowFunctionExtractor;
import com.facebook.presto.sql.tree.ArithmeticExpression;
import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.BetweenPredicate;
import com.facebook.presto.sql.tree.Cast;
import com.facebook.presto.sql.tree.CoalesceExpression;
import com.facebook.presto.sql.tree.ComparisonExpression;
import com.facebook.presto.sql.tree.CurrentTime;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Extract;
import com.facebook.presto.sql.tree.FrameBound;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.IfExpression;
import com.facebook.presto.sql.tree.InListExpression;
import com.facebook.presto.sql.tree.InPredicate;
import com.facebook.presto.sql.tree.IsNotNullPredicate;
import com.facebook.presto.sql.tree.IsNullPredicate;
import com.facebook.presto.sql.tree.LikePredicate;
import com.facebook.presto.sql.tree.Literal;
import com.facebook.presto.sql.tree.LogicalBinaryExpression;
import com.facebook.presto.sql.tree.NegativeExpression;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NotExpression;
import com.facebook.presto.sql.tree.NullIfExpression;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.QualifiedNameReference;
import com.facebook.presto.sql.tree.SearchedCaseExpression;
import com.facebook.presto.sql.tree.SimpleCaseExpression;
import com.facebook.presto.sql.tree.SortItem;
import com.facebook.presto.sql.tree.WhenClause;
import com.facebook.presto.sql.tree.Window;
import com.facebook.presto.sql.tree.WindowFrame;
import com.facebook.presto.util.IterableTransformer;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;
import javax.annotation.Nullable;

public class AggregationAnalyzer {
    private final List<Integer> fieldIndexes;
    private final List<Expression> expressions;
    private final Metadata metadata;
    private final TupleDescriptor tupleDescriptor;

    public AggregationAnalyzer(List<FieldOrExpression> groupByExpressions, Metadata metadata, TupleDescriptor tupleDescriptor) {
        Preconditions.checkNotNull(groupByExpressions, (Object)"groupByExpressions is null");
        Preconditions.checkNotNull((Object)metadata, (Object)"metadata is null");
        Preconditions.checkNotNull((Object)tupleDescriptor, (Object)"tupleDescriptor is null");
        this.tupleDescriptor = tupleDescriptor;
        this.metadata = metadata;
        this.expressions = IterableTransformer.on(groupByExpressions).select(FieldOrExpression.isExpressionPredicate()).transform(FieldOrExpression.expressionGetter()).list();
        ImmutableList.Builder fields = ImmutableList.builder();
        fields.addAll(IterableTransformer.on(groupByExpressions).select(FieldOrExpression.isFieldReferencePredicate()).transform(FieldOrExpression.fieldIndexGetter()).all());
        for (Expression expression : Iterables.filter(this.expressions, (Predicate)Predicates.instanceOf(QualifiedNameReference.class))) {
            QualifiedName name = ((QualifiedNameReference)expression).getName();
            List<Integer> fieldIndexes = tupleDescriptor.resolveFieldIndexes(name);
            Preconditions.checkState((fieldIndexes.size() <= 1 ? 1 : 0) != 0, (String)"Found more than one field for name '%s': %s", (Object[])new Object[]{name, fieldIndexes});
            if (fieldIndexes.size() != 1) continue;
            fields.add(Iterables.getOnlyElement(fieldIndexes));
        }
        this.fieldIndexes = fields.build();
    }

    public boolean analyze(int fieldIndex) {
        return Iterables.any(this.fieldIndexes, (Predicate)Predicates.equalTo((Object)fieldIndex));
    }

    public void analyze(Expression expression) {
        Visitor visitor = new Visitor();
        if (!visitor.process((Node)expression, null).booleanValue()) {
            throw new SemanticException(SemanticErrorCode.MUST_BE_AGGREGATE_OR_GROUP_BY, (Node)expression, "'%s' must be an aggregate expression or appear in GROUP BY clause", expression);
        }
    }

    private class Visitor
    extends AstVisitor<Boolean, Void> {
        private Visitor() {
        }

        private Predicate<Expression> isConstantPredicate() {
            return new Predicate<Expression>(){

                public boolean apply(Expression input) {
                    return Visitor.this.process((Node)input, null);
                }
            };
        }

        protected Boolean visitExpression(Expression node, Void context) {
            throw new UnsupportedOperationException("aggregation analysis not yet implemented for: " + node.getClass().getName());
        }

        protected Boolean visitCast(Cast node, Void context) {
            return this.process((Node)node.getExpression(), context);
        }

        protected Boolean visitCoalesceExpression(CoalesceExpression node, Void context) {
            return Iterables.all((Iterable)node.getOperands(), this.isConstantPredicate());
        }

        protected Boolean visitNullIfExpression(NullIfExpression node, Void context) {
            return this.process((Node)node.getFirst(), context) != false && this.process((Node)node.getSecond(), context) != false;
        }

        protected Boolean visitExtract(Extract node, Void context) {
            return this.process((Node)node.getExpression(), context);
        }

        protected Boolean visitBetweenPredicate(BetweenPredicate node, Void context) {
            return this.process((Node)node.getMin(), context) != false && this.process((Node)node.getValue(), context) != false && this.process((Node)node.getMax(), context) != false;
        }

        protected Boolean visitCurrentTime(CurrentTime node, Void context) {
            return true;
        }

        protected Boolean visitArithmeticExpression(ArithmeticExpression node, Void context) {
            return Iterables.all((Iterable)ImmutableList.of((Object)node.getLeft(), (Object)node.getRight()), this.isConstantPredicate());
        }

        protected Boolean visitComparisonExpression(ComparisonExpression node, Void context) {
            return Iterables.all((Iterable)ImmutableList.of((Object)node.getLeft(), (Object)node.getRight()), this.isConstantPredicate());
        }

        protected Boolean visitLiteral(Literal node, Void context) {
            return true;
        }

        protected Boolean visitIsNotNullPredicate(IsNotNullPredicate node, Void context) {
            return this.process((Node)node.getValue(), context);
        }

        protected Boolean visitIsNullPredicate(IsNullPredicate node, Void context) {
            return this.process((Node)node.getValue(), context);
        }

        protected Boolean visitLikePredicate(LikePredicate node, Void context) {
            return this.process((Node)node.getValue(), context) != false && this.process((Node)node.getPattern(), context) != false;
        }

        protected Boolean visitInListExpression(InListExpression node, Void context) {
            return Iterables.all((Iterable)node.getValues(), this.isConstantPredicate());
        }

        protected Boolean visitInPredicate(InPredicate node, Void context) {
            return this.process((Node)node.getValue(), context) != false && this.process((Node)node.getValueList(), context) != false;
        }

        protected Boolean visitFunctionCall(FunctionCall node, Void context) {
            if (!node.getWindow().isPresent() && AggregationAnalyzer.this.metadata.isAggregationFunction(node.getName())) {
                AggregateExtractor aggregateExtractor = new AggregateExtractor(AggregationAnalyzer.this.metadata);
                WindowFunctionExtractor windowExtractor = new WindowFunctionExtractor();
                for (Expression argument : node.getArguments()) {
                    aggregateExtractor.process((Node)argument, null);
                    windowExtractor.process((Node)argument, null);
                }
                if (!aggregateExtractor.getAggregates().isEmpty()) {
                    throw new SemanticException(SemanticErrorCode.NESTED_AGGREGATION, (Node)node, "Cannot nest aggregations inside aggregation '%s': %s", node.getName(), aggregateExtractor.getAggregates());
                }
                if (!windowExtractor.getWindowFunctions().isEmpty()) {
                    throw new SemanticException(SemanticErrorCode.NESTED_WINDOW, (Node)node, "Cannot nest window functions inside aggregation '%s': %s", node.getName(), windowExtractor.getWindowFunctions());
                }
                return true;
            }
            if (node.getWindow().isPresent() && !this.process((Node)node.getWindow().get(), context).booleanValue()) {
                return false;
            }
            return Iterables.all((Iterable)node.getArguments(), this.isConstantPredicate());
        }

        public Boolean visitWindow(Window node, Void context) {
            for (Expression expression : node.getPartitionBy()) {
                if (this.process((Node)expression, context).booleanValue()) continue;
                throw new SemanticException(SemanticErrorCode.MUST_BE_AGGREGATE_OR_GROUP_BY, (Node)expression, "PARTITION BY expression '%s' must be an aggregate expression or appear in GROUP BY clause", expression);
            }
            for (SortItem sortItem : node.getOrderBy()) {
                Expression expression = sortItem.getSortKey();
                if (this.process((Node)expression, context).booleanValue()) continue;
                throw new SemanticException(SemanticErrorCode.MUST_BE_AGGREGATE_OR_GROUP_BY, (Node)expression, "ORDER BY expression '%s' must be an aggregate expression or appear in GROUP BY clause", expression);
            }
            if (node.getFrame().isPresent()) {
                this.process((Node)node.getFrame().get(), context);
            }
            return true;
        }

        public Boolean visitWindowFrame(WindowFrame node, Void context) {
            Expression endValue;
            Optional start = node.getStart().getValue();
            if (start.isPresent() && !this.process((Node)start.get(), context).booleanValue()) {
                throw new SemanticException(SemanticErrorCode.MUST_BE_AGGREGATE_OR_GROUP_BY, (Node)start.get(), "Window frame start must be an aggregate expression or appear in GROUP BY clause", new Object[0]);
            }
            if (node.getEnd().isPresent() && ((FrameBound)node.getEnd().get()).getValue().isPresent() && !this.process((Node)(endValue = (Expression)((FrameBound)node.getEnd().get()).getValue().get()), context).booleanValue()) {
                throw new SemanticException(SemanticErrorCode.MUST_BE_AGGREGATE_OR_GROUP_BY, (Node)endValue, "Window frame end must be an aggregate expression or appear in GROUP BY clause", new Object[0]);
            }
            return true;
        }

        protected Boolean visitQualifiedNameReference(QualifiedNameReference node, Void context) {
            QualifiedName name = node.getName();
            List<Integer> indexes = AggregationAnalyzer.this.tupleDescriptor.resolveFieldIndexes(name);
            Preconditions.checkState((!indexes.isEmpty() ? 1 : 0) != 0, (String)"No fields for name '%s'", (Object[])new Object[]{name});
            Preconditions.checkState((indexes.size() <= 1 ? 1 : 0) != 0, (String)"Found more than one field for name '%s': %s", (Object[])new Object[]{name, indexes});
            return AggregationAnalyzer.this.fieldIndexes.contains(Iterables.getOnlyElement(indexes));
        }

        protected Boolean visitNegativeExpression(NegativeExpression node, Void context) {
            return this.process((Node)node.getValue(), context);
        }

        protected Boolean visitNotExpression(NotExpression node, Void context) {
            return this.process((Node)node.getValue(), context);
        }

        protected Boolean visitLogicalBinaryExpression(LogicalBinaryExpression node, Void context) {
            return Iterables.all((Iterable)ImmutableList.of((Object)node.getLeft(), (Object)node.getRight()), this.isConstantPredicate());
        }

        protected Boolean visitIfExpression(IfExpression node, Void context) {
            ImmutableList.Builder expressions = ImmutableList.builder().add((Object)node.getCondition()).add((Object)node.getTrueValue());
            if (node.getFalseValue().isPresent()) {
                expressions.add(node.getFalseValue().get());
            }
            return Iterables.all((Iterable)expressions.build(), this.isConstantPredicate());
        }

        protected Boolean visitSimpleCaseExpression(SimpleCaseExpression node, Void context) {
            if (!this.process((Node)node.getOperand(), context).booleanValue()) {
                return false;
            }
            for (WhenClause whenClause : node.getWhenClauses()) {
                if (this.process((Node)whenClause.getOperand(), context).booleanValue() && this.process((Node)whenClause.getResult(), context).booleanValue()) continue;
                return false;
            }
            if (node.getDefaultValue() != null && !this.process((Node)node.getDefaultValue(), context).booleanValue()) {
                return false;
            }
            return true;
        }

        protected Boolean visitSearchedCaseExpression(SearchedCaseExpression node, Void context) {
            for (WhenClause whenClause : node.getWhenClauses()) {
                if (this.process((Node)whenClause.getOperand(), context).booleanValue() && this.process((Node)whenClause.getResult(), context).booleanValue()) continue;
                return false;
            }
            if (node.getDefaultValue() != null && !this.process((Node)node.getDefaultValue(), context).booleanValue()) {
                return false;
            }
            return true;
        }

        public Boolean process(Node node, @Nullable Void context) {
            if (Iterables.any((Iterable)AggregationAnalyzer.this.expressions, (Predicate)Predicates.equalTo((Object)node))) {
                return true;
            }
            return (Boolean)super.process(node, (Object)context);
        }
    }
}

