/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.analyzer;

import com.facebook.presto.metadata.FunctionInfo;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.sql.analyzer.Analysis;
import com.facebook.presto.sql.analyzer.AnalysisContext;
import com.facebook.presto.sql.analyzer.Field;
import com.facebook.presto.sql.analyzer.QueryExplainer;
import com.facebook.presto.sql.analyzer.SemanticErrorCode;
import com.facebook.presto.sql.analyzer.SemanticException;
import com.facebook.presto.sql.analyzer.Session;
import com.facebook.presto.sql.analyzer.StatementAnalyzer;
import com.facebook.presto.sql.analyzer.TupleDescriptor;
import com.facebook.presto.sql.analyzer.Type;
import com.facebook.presto.sql.tree.ArithmeticExpression;
import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.BetweenPredicate;
import com.facebook.presto.sql.tree.BooleanLiteral;
import com.facebook.presto.sql.tree.Cast;
import com.facebook.presto.sql.tree.CoalesceExpression;
import com.facebook.presto.sql.tree.ComparisonExpression;
import com.facebook.presto.sql.tree.CurrentTime;
import com.facebook.presto.sql.tree.DateLiteral;
import com.facebook.presto.sql.tree.DoubleLiteral;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Extract;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.IfExpression;
import com.facebook.presto.sql.tree.InListExpression;
import com.facebook.presto.sql.tree.InPredicate;
import com.facebook.presto.sql.tree.IntervalLiteral;
import com.facebook.presto.sql.tree.IsNotNullPredicate;
import com.facebook.presto.sql.tree.IsNullPredicate;
import com.facebook.presto.sql.tree.LikePredicate;
import com.facebook.presto.sql.tree.LogicalBinaryExpression;
import com.facebook.presto.sql.tree.LongLiteral;
import com.facebook.presto.sql.tree.NegativeExpression;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NotExpression;
import com.facebook.presto.sql.tree.NullIfExpression;
import com.facebook.presto.sql.tree.NullLiteral;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.QualifiedNameReference;
import com.facebook.presto.sql.tree.SearchedCaseExpression;
import com.facebook.presto.sql.tree.SimpleCaseExpression;
import com.facebook.presto.sql.tree.SortItem;
import com.facebook.presto.sql.tree.StringLiteral;
import com.facebook.presto.sql.tree.SubqueryExpression;
import com.facebook.presto.sql.tree.TimeLiteral;
import com.facebook.presto.sql.tree.TimestampLiteral;
import com.facebook.presto.sql.tree.WhenClause;
import com.facebook.presto.sql.tree.Window;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ExpressionAnalyzer {
    private final Analysis analysis;
    private final Session session;
    private final Metadata metadata;
    private final boolean experimentalSyntaxEnabled;
    private final Map<QualifiedName, Integer> resolvedNames = new HashMap<QualifiedName, Integer>();
    private final IdentityHashMap<FunctionCall, FunctionInfo> resolvedFunctions = new IdentityHashMap();
    private final IdentityHashMap<Expression, Type> subExpressionTypes = new IdentityHashMap();
    private final Set<InPredicate> subqueryInPredicates = Collections.newSetFromMap(new IdentityHashMap());

    public ExpressionAnalyzer(Analysis analysis, Session session, Metadata metadata, boolean experimentalSyntaxEnabled) {
        this.analysis = (Analysis)Preconditions.checkNotNull((Object)analysis, (Object)"analysis is null");
        this.session = (Session)Preconditions.checkNotNull((Object)session, (Object)"session is null");
        this.metadata = (Metadata)Preconditions.checkNotNull((Object)metadata, (Object)"metadata is null");
        this.experimentalSyntaxEnabled = experimentalSyntaxEnabled;
    }

    public Map<QualifiedName, Integer> getResolvedNames() {
        return this.resolvedNames;
    }

    public IdentityHashMap<FunctionCall, FunctionInfo> getResolvedFunctions() {
        return this.resolvedFunctions;
    }

    public IdentityHashMap<Expression, Type> getSubExpressionTypes() {
        return this.subExpressionTypes;
    }

    public Set<InPredicate> getSubqueryInPredicates() {
        return this.subqueryInPredicates;
    }

    public Type analyze(Expression expression, TupleDescriptor tupleDescriptor, AnalysisContext context) {
        Visitor visitor = new Visitor(tupleDescriptor);
        return (Type)((Object)expression.accept((AstVisitor)visitor, (Object)context));
    }

    public static Predicate<Type> sameTypePredicate(final Type type) {
        return new Predicate<Type>(){

            public boolean apply(Type input) {
                return ExpressionAnalyzer.sameType(type, input);
            }
        };
    }

    public static boolean sameType(Type type1, Type type2) {
        return type1 == type2 || type1 == Type.NULL || type2 == Type.NULL;
    }

    public static boolean isBooleanOrNull(Type type) {
        return type == Type.BOOLEAN || type == Type.NULL;
    }

    public static boolean isNumericOrNull(Type type) {
        return Type.isNumeric(type) || type == Type.NULL;
    }

    public static boolean isStringTypeOrNull(Type type) {
        return type == Type.VARCHAR || type == Type.NULL;
    }

    private class Visitor
    extends AstVisitor<Type, AnalysisContext> {
        private final TupleDescriptor tupleDescriptor;

        private Visitor(TupleDescriptor tupleDescriptor) {
            this.tupleDescriptor = (TupleDescriptor)Preconditions.checkNotNull((Object)tupleDescriptor, (Object)"tupleDescriptor is null");
        }

        protected Type visitCurrentTime(CurrentTime node, AnalysisContext context) {
            if (node.getType() != CurrentTime.Type.TIMESTAMP) {
                throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)node, "%s not yet supported", node.getType().getName());
            }
            if (node.getPrecision() != null) {
                throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)node, "non-default precision not yet supported", new Object[0]);
            }
            ExpressionAnalyzer.this.subExpressionTypes.put(node, Type.BIGINT);
            return Type.BIGINT;
        }

        protected Type visitQualifiedNameReference(QualifiedNameReference node, AnalysisContext context) {
            List<Integer> matches = this.tupleDescriptor.resolveFieldIndexes(node.getName());
            if (matches.isEmpty()) {
                throw new SemanticException(SemanticErrorCode.MISSING_ATTRIBUTE, (Node)node, "Column '%s' cannot be resolved", node.getName());
            }
            if (matches.size() > 1) {
                throw new SemanticException(SemanticErrorCode.AMBIGUOUS_ATTRIBUTE, (Node)node, "Column '%s' is ambiguous", node.getName());
            }
            int fieldIndex = (Integer)Iterables.getOnlyElement(matches);
            Field field = this.tupleDescriptor.getFields().get(fieldIndex);
            ExpressionAnalyzer.this.resolvedNames.put(node.getName(), fieldIndex);
            ExpressionAnalyzer.this.subExpressionTypes.put(node, field.getType());
            return field.getType();
        }

        protected Type visitNotExpression(NotExpression node, AnalysisContext context) {
            Type value = (Type)((Object)this.process((Node)node.getValue(), context));
            if (value != Type.BOOLEAN) {
                throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)node.getValue(), "Value of logical NOT expression must evaluate to a BOOLEAN (actual: %s)", new Object[]{value});
            }
            ExpressionAnalyzer.this.subExpressionTypes.put(node, Type.BOOLEAN);
            return Type.BOOLEAN;
        }

        protected Type visitLogicalBinaryExpression(LogicalBinaryExpression node, AnalysisContext context) {
            Type left = (Type)((Object)this.process((Node)node.getLeft(), context));
            if (left != Type.BOOLEAN) {
                throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)node.getLeft(), "Left side of logical expression must evaluate to a BOOLEAN (actual: %s)", new Object[]{left});
            }
            Type right = (Type)((Object)this.process((Node)node.getRight(), context));
            if (right != Type.BOOLEAN) {
                throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)node.getRight(), "Right side of logical expression must evaluate to a BOOLEAN (actual: %s)", new Object[]{right});
            }
            ExpressionAnalyzer.this.subExpressionTypes.put(node, Type.BOOLEAN);
            return Type.BOOLEAN;
        }

        protected Type visitComparisonExpression(ComparisonExpression node, AnalysisContext context) {
            Type right;
            Type left = (Type)((Object)this.process((Node)node.getLeft(), context));
            if (!(left == (right = (Type)((Object)this.process((Node)node.getRight(), context))) || Type.isNumeric(left) && Type.isNumeric(right))) {
                throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)node, "Types are not comparable with '%s': %s vs %s", new Object[]{node.getType().getValue(), left, right});
            }
            ExpressionAnalyzer.this.subExpressionTypes.put(node, Type.BOOLEAN);
            return Type.BOOLEAN;
        }

        protected Type visitIsNullPredicate(IsNullPredicate node, AnalysisContext context) {
            this.process((Node)node.getValue(), context);
            ExpressionAnalyzer.this.subExpressionTypes.put(node, Type.BOOLEAN);
            return Type.BOOLEAN;
        }

        protected Type visitIsNotNullPredicate(IsNotNullPredicate node, AnalysisContext context) {
            this.process((Node)node.getValue(), context);
            ExpressionAnalyzer.this.subExpressionTypes.put(node, Type.BOOLEAN);
            return Type.BOOLEAN;
        }

        protected Type visitNullIfExpression(NullIfExpression node, AnalysisContext context) {
            Type second;
            Type first = (Type)((Object)this.process((Node)node.getFirst(), context));
            if (!(first == (second = (Type)((Object)this.process((Node)node.getSecond(), context))) || Type.isNumeric(first) && Type.isNumeric(second))) {
                throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)node, "Types are not comparable with nullif: %s vs %s", new Object[]{first, second});
            }
            ExpressionAnalyzer.this.subExpressionTypes.put(node, first);
            return first;
        }

        protected Type visitIfExpression(IfExpression node, AnalysisContext context) {
            Type condition = (Type)((Object)this.process((Node)node.getCondition(), context));
            if (!ExpressionAnalyzer.isBooleanOrNull(condition)) {
                throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)node, "IF condition must be a boolean type: %s", new Object[]{condition});
            }
            Type first = (Type)((Object)this.process((Node)node.getTrueValue(), context));
            if (!node.getFalseValue().isPresent()) {
                ExpressionAnalyzer.this.subExpressionTypes.put(node, first);
                return first;
            }
            Type second = (Type)((Object)this.process((Node)node.getFalseValue().get(), context));
            if (!ExpressionAnalyzer.sameType(first, second)) {
                throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)node, "Result types for IF must be the same: %s vs %s", new Object[]{first, second});
            }
            Type type = first != Type.NULL ? first : second;
            ExpressionAnalyzer.this.subExpressionTypes.put(node, type);
            return type;
        }

        protected Type visitSearchedCaseExpression(SearchedCaseExpression node, AnalysisContext context) {
            for (WhenClause whenClause : node.getWhenClauses()) {
                Type whenOperand = (Type)((Object)this.process((Node)whenClause.getOperand(), context));
                if (ExpressionAnalyzer.isBooleanOrNull(whenOperand)) continue;
                throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)node, "WHEN clause must be a boolean type: %s", new Object[]{whenOperand});
            }
            ArrayList<Type> types = new ArrayList<Type>();
            for (WhenClause whenClause : node.getWhenClauses()) {
                types.add((Type)((Object)this.process((Node)whenClause.getResult(), context)));
            }
            if (node.getDefaultValue() != null) {
                types.add((Type)((Object)this.process((Node)node.getDefaultValue(), context)));
            }
            Type type = this.getSingleType((Node)node, "clauses", types);
            ExpressionAnalyzer.this.subExpressionTypes.put(node, type);
            return type;
        }

        protected Type visitSimpleCaseExpression(SimpleCaseExpression node, AnalysisContext context) {
            Type operand = (Type)((Object)this.process((Node)node.getOperand(), context));
            for (WhenClause whenClause : node.getWhenClauses()) {
                Type whenOperand = (Type)((Object)this.process((Node)whenClause.getOperand(), context));
                if (ExpressionAnalyzer.sameType(operand, whenOperand)) continue;
                throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)node, "CASE operand type does not match WHEN clause operand type: %s vs %s", new Object[]{operand, whenOperand});
            }
            ArrayList<Type> types = new ArrayList<Type>();
            for (WhenClause whenClause : node.getWhenClauses()) {
                types.add((Type)((Object)this.process((Node)whenClause.getResult(), context)));
            }
            if (node.getDefaultValue() != null) {
                types.add((Type)((Object)this.process((Node)node.getDefaultValue(), context)));
            }
            Type type = this.getSingleType((Node)node, "clauses", types);
            ExpressionAnalyzer.this.subExpressionTypes.put(node, type);
            return type;
        }

        protected Type visitCoalesceExpression(CoalesceExpression node, AnalysisContext context) {
            ArrayList<Type> operandTypes = new ArrayList<Type>();
            for (Expression expression : node.getOperands()) {
                operandTypes.add((Type)((Object)this.process((Node)expression, context)));
            }
            Type type = this.getSingleType((Node)node, "operands", operandTypes);
            ExpressionAnalyzer.this.subExpressionTypes.put(node, type);
            return type;
        }

        private Type getSingleType(Node node, String subTypeName, List<Type> subTypes) {
            Type firstOperand;
            if (!Iterables.all((Iterable)(subTypes = ImmutableList.copyOf((Iterable)Iterables.filter(subTypes, (Predicate)Predicates.not((Predicate)Predicates.equalTo((Object)((Object)Type.NULL)))))), ExpressionAnalyzer.sameTypePredicate(firstOperand = (Type)((Object)Iterables.get((Iterable)subTypes, (int)0))))) {
                throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, node, "All %s must be the same type: %s", subTypeName, subTypes);
            }
            return firstOperand;
        }

        protected Type visitNegativeExpression(NegativeExpression node, AnalysisContext context) {
            Type type = (Type)((Object)this.process((Node)node.getValue(), context));
            if (!Type.isNumeric(type)) {
                throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)node.getValue(), "Value of negative operator must be numeric (actual: %s)", new Object[]{type});
            }
            ExpressionAnalyzer.this.subExpressionTypes.put(node, type);
            return type;
        }

        protected Type visitArithmeticExpression(ArithmeticExpression node, AnalysisContext context) {
            Type left = (Type)((Object)this.process((Node)node.getLeft(), context));
            Type right = (Type)((Object)this.process((Node)node.getRight(), context));
            if (!Type.isNumeric(left)) {
                throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)node.getLeft(), "Left side of '%s' must be numeric (actual: %s)", new Object[]{node.getType().getValue(), left});
            }
            if (!Type.isNumeric(right)) {
                throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)node.getRight(), "Right side of '%s' must be numeric (actual: %s)", new Object[]{node.getType().getValue(), right});
            }
            if (left == Type.BIGINT && right == Type.BIGINT) {
                ExpressionAnalyzer.this.subExpressionTypes.put(node, Type.BIGINT);
                return Type.BIGINT;
            }
            ExpressionAnalyzer.this.subExpressionTypes.put(node, Type.DOUBLE);
            return Type.DOUBLE;
        }

        protected Type visitLikePredicate(LikePredicate node, AnalysisContext context) {
            Type escape;
            Type value = (Type)((Object)this.process((Node)node.getValue(), context));
            if (value != Type.VARCHAR && value != Type.NULL) {
                throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)node.getValue(), "Left side of LIKE expression must be a STRING (actual: %s)", new Object[]{value});
            }
            Type pattern = (Type)((Object)this.process((Node)node.getPattern(), context));
            if (pattern != Type.VARCHAR && pattern != Type.NULL) {
                throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)node.getValue(), "Pattern for LIKE expression must be a STRING (actual: %s)", new Object[]{pattern});
            }
            if (node.getEscape() != null && (escape = (Type)((Object)this.process((Node)node.getEscape(), context))) != Type.VARCHAR && escape != Type.NULL) {
                throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)node.getValue(), "Escape for LIKE expression must be a STRING (actual: %s)", new Object[]{escape});
            }
            ExpressionAnalyzer.this.subExpressionTypes.put(node, Type.BOOLEAN);
            return Type.BOOLEAN;
        }

        protected Type visitStringLiteral(StringLiteral node, AnalysisContext context) {
            ExpressionAnalyzer.this.subExpressionTypes.put(node, Type.VARCHAR);
            return Type.VARCHAR;
        }

        protected Type visitLongLiteral(LongLiteral node, AnalysisContext context) {
            ExpressionAnalyzer.this.subExpressionTypes.put(node, Type.BIGINT);
            return Type.BIGINT;
        }

        protected Type visitDoubleLiteral(DoubleLiteral node, AnalysisContext context) {
            ExpressionAnalyzer.this.subExpressionTypes.put(node, Type.DOUBLE);
            return Type.DOUBLE;
        }

        protected Type visitBooleanLiteral(BooleanLiteral node, AnalysisContext context) {
            ExpressionAnalyzer.this.subExpressionTypes.put(node, Type.BOOLEAN);
            return Type.BOOLEAN;
        }

        protected Type visitDateLiteral(DateLiteral node, AnalysisContext context) {
            ExpressionAnalyzer.this.subExpressionTypes.put(node, Type.BIGINT);
            return Type.BIGINT;
        }

        protected Type visitTimeLiteral(TimeLiteral node, AnalysisContext context) {
            ExpressionAnalyzer.this.subExpressionTypes.put(node, Type.BIGINT);
            return Type.BIGINT;
        }

        protected Type visitTimestampLiteral(TimestampLiteral node, AnalysisContext context) {
            ExpressionAnalyzer.this.subExpressionTypes.put(node, Type.BIGINT);
            return Type.BIGINT;
        }

        protected Type visitIntervalLiteral(IntervalLiteral node, AnalysisContext context) {
            ExpressionAnalyzer.this.subExpressionTypes.put(node, Type.BIGINT);
            return Type.BIGINT;
        }

        protected Type visitNullLiteral(NullLiteral node, AnalysisContext context) {
            ExpressionAnalyzer.this.subExpressionTypes.put(node, Type.NULL);
            return Type.NULL;
        }

        protected Type visitFunctionCall(FunctionCall node, AnalysisContext context) {
            if (node.getWindow().isPresent()) {
                for (Expression expression : ((Window)node.getWindow().get()).getPartitionBy()) {
                    this.process((Node)expression, context);
                }
                for (SortItem sortItem : ((Window)node.getWindow().get()).getOrderBy()) {
                    this.process((Node)sortItem.getSortKey(), context);
                }
            }
            ImmutableList.Builder argumentTypes = ImmutableList.builder();
            for (Expression expression : node.getArguments()) {
                argumentTypes.add(this.process((Node)expression, context));
            }
            FunctionInfo function = ExpressionAnalyzer.this.metadata.getFunction(node.getName(), (List<Type>)argumentTypes.build(), context.isApproximate());
            ExpressionAnalyzer.this.resolvedFunctions.put(node, function);
            ExpressionAnalyzer.this.subExpressionTypes.put(node, function.getReturnType());
            return function.getReturnType();
        }

        protected Type visitExtract(Extract node, AnalysisContext context) {
            Type type = (Type)((Object)this.process((Node)node.getExpression(), context));
            if (type != Type.BIGINT) {
                throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)node.getExpression(), "Type of argument to extract must be LONG (actual %s)", new Object[]{type});
            }
            ExpressionAnalyzer.this.subExpressionTypes.put(node, Type.BIGINT);
            return Type.BIGINT;
        }

        protected Type visitBetweenPredicate(BetweenPredicate node, AnalysisContext context) {
            Type value = (Type)((Object)this.process((Node)node.getValue(), context));
            Type min = (Type)((Object)this.process((Node)node.getMin(), context));
            Type max = (Type)((Object)this.process((Node)node.getMax(), context));
            if (ExpressionAnalyzer.isStringTypeOrNull(value) && ExpressionAnalyzer.isStringTypeOrNull(min) && ExpressionAnalyzer.isStringTypeOrNull(max)) {
                ExpressionAnalyzer.this.subExpressionTypes.put(node, Type.BOOLEAN);
                return Type.BOOLEAN;
            }
            if (ExpressionAnalyzer.isNumericOrNull(value) && ExpressionAnalyzer.isNumericOrNull(min) && ExpressionAnalyzer.isNumericOrNull(max)) {
                ExpressionAnalyzer.this.subExpressionTypes.put(node, Type.BOOLEAN);
                return Type.BOOLEAN;
            }
            throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)node.getValue(), "Between value, min and max must be the same type (value: %s, min: %s, max: %s)", new Object[]{value, min, max});
        }

        public Type visitCast(Cast node, AnalysisContext context) {
            Type type;
            this.process((Node)node.getExpression(), context);
            switch (node.getType()) {
                case "BOOLEAN": {
                    type = Type.BOOLEAN;
                    break;
                }
                case "DOUBLE": {
                    type = Type.DOUBLE;
                    break;
                }
                case "BIGINT": {
                    type = Type.BIGINT;
                    break;
                }
                case "VARCHAR": {
                    type = Type.VARCHAR;
                    break;
                }
                default: {
                    throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)node, "Cannot cast to type: " + node.getType(), new Object[0]);
                }
            }
            ExpressionAnalyzer.this.subExpressionTypes.put(node, type);
            return type;
        }

        protected Type visitInPredicate(InPredicate node, AnalysisContext context) {
            Type valueType = (Type)((Object)this.process((Node)node.getValue(), context));
            Type listType = (Type)((Object)this.process((Node)node.getValueList(), context));
            if (node.getValueList() instanceof SubqueryExpression) {
                ExpressionAnalyzer.this.subqueryInPredicates.add(node);
            }
            if (valueType == Type.NULL) {
                ExpressionAnalyzer.this.subExpressionTypes.put(node, Type.NULL);
            } else if (!(valueType == listType || Type.isNumeric(valueType) && Type.isNumeric(listType))) {
                throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)node, "Types are not comparable for 'IN': %s vs %s", new Object[]{valueType, listType});
            }
            ExpressionAnalyzer.this.subExpressionTypes.put(node, Type.BOOLEAN);
            return Type.BOOLEAN;
        }

        protected Type visitInListExpression(InListExpression node, AnalysisContext context) {
            ArrayList<Type> types = new ArrayList<Type>();
            for (Expression value : node.getValues()) {
                types.add((Type)((Object)this.process((Node)value, context)));
            }
            Type type = this.getSingleType((Node)node, "values", types);
            ExpressionAnalyzer.this.subExpressionTypes.put(node, type);
            return type;
        }

        protected Type visitSubqueryExpression(SubqueryExpression node, AnalysisContext context) {
            StatementAnalyzer analyzer = new StatementAnalyzer(ExpressionAnalyzer.this.analysis, ExpressionAnalyzer.this.metadata, ExpressionAnalyzer.this.session, ExpressionAnalyzer.this.experimentalSyntaxEnabled, (Optional<QueryExplainer>)Optional.absent());
            TupleDescriptor descriptor = (TupleDescriptor)analyzer.process((Node)node.getQuery(), context);
            if (descriptor.getFields().size() != 1) {
                throw new SemanticException(SemanticErrorCode.MULTIPLE_FIELDS_FROM_SCALAR_SUBQUERY, (Node)node, "Subquery expression must produce only one field. Found %s", descriptor.getFields().size());
            }
            Type type = ((Field)Iterables.getOnlyElement(descriptor.getFields())).getType();
            ExpressionAnalyzer.this.subExpressionTypes.put(node, type);
            return type;
        }

        protected Type visitExpression(Expression node, AnalysisContext context) {
            throw new UnsupportedOperationException("not yet implemented: " + node.getClass().getName());
        }
    }
}

