/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.analyzer;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import javax.annotation.Nullable;

public class Session {
    public static final String DEFAULT_CATALOG = "default";
    public static final String DEFAULT_SCHEMA = "default";
    private final String user;
    private final String source;
    private final String remoteUserAddress;
    private final String userAgent;
    private final String catalog;
    private final String schema;
    private final long startTime;

    public Session(@Nullable String user, String source, String catalog, String schema, String remoteUserAddress, String userAgent) {
        this(user, source, catalog, schema, remoteUserAddress, userAgent, System.currentTimeMillis());
    }

    @JsonCreator
    public Session(@JsonProperty(value="user") @Nullable String user, @JsonProperty(value="source") String source, @JsonProperty(value="catalog") String catalog, @JsonProperty(value="schema") String schema, @JsonProperty(value="remoteUserAddress") String remoteUserAddress, @JsonProperty(value="userAgent") String userAgent, @JsonProperty(value="startTime") long startTime) {
        this.user = user;
        this.source = source;
        this.catalog = (String)Preconditions.checkNotNull((Object)catalog, (Object)"catalog is null");
        this.schema = (String)Preconditions.checkNotNull((Object)schema, (Object)"schema is null");
        this.remoteUserAddress = remoteUserAddress;
        this.userAgent = userAgent;
        this.startTime = startTime;
    }

    @JsonProperty
    @Nullable
    public String getUser() {
        return this.user;
    }

    @JsonProperty
    public String getSource() {
        return this.source;
    }

    @JsonProperty
    public String getCatalog() {
        return this.catalog;
    }

    @JsonProperty
    public String getSchema() {
        return this.schema;
    }

    @JsonProperty
    public String getRemoteUserAddress() {
        return this.remoteUserAddress;
    }

    @JsonProperty
    public String getUserAgent() {
        return this.userAgent;
    }

    @JsonProperty
    public long getStartTime() {
        return this.startTime;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("user", (Object)this.user).add("source", (Object)this.source).add("remoteUserAddress", (Object)this.remoteUserAddress).add("userAgent", (Object)this.userAgent).add("catalog", (Object)this.catalog).add("schema", (Object)this.schema).add("startTime", this.startTime).toString();
    }
}

