/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.analyzer;

import com.facebook.presto.sql.analyzer.Field;
import com.facebook.presto.sql.analyzer.Optionals;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.util.IterableTransformer;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.List;
import java.util.Set;

public class TupleDescriptor {
    private final List<Field> fields;

    public TupleDescriptor(Field ... fields) {
        this(Arrays.asList(fields));
    }

    public TupleDescriptor(List<Field> fields) {
        Preconditions.checkNotNull(fields, (Object)"fields is null");
        this.fields = ImmutableList.copyOf(fields);
    }

    public List<Field> getFields() {
        return this.fields;
    }

    public Set<QualifiedName> getRelationAliases() {
        return IterableTransformer.on(this.fields).transform(Field.relationAliasGetter()).select(Optionals.isPresentPredicate()).transform(Optionals.optionalGetter()).set();
    }

    public boolean canResolve(QualifiedName name) {
        return Iterables.any(this.fields, Field.canResolvePredicate(name));
    }

    public List<Field> resolveFieldsWithPrefix(Optional<QualifiedName> prefix) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Field field : this.fields) {
            if (!field.matchesPrefix(prefix)) continue;
            builder.add((Object)field);
        }
        return builder.build();
    }

    public List<Integer> resolveFieldIndexesWithPrefix(Optional<QualifiedName> prefix) {
        ImmutableList.Builder builder = ImmutableList.builder();
        int index = 0;
        for (Field field : this.fields) {
            if (field.matchesPrefix(prefix)) {
                builder.add((Object)index);
            }
            ++index;
        }
        return builder.build();
    }

    public List<Integer> resolveFieldIndexes(QualifiedName name) {
        ImmutableList.Builder fields = ImmutableList.builder();
        for (int index = 0; index < this.fields.size(); ++index) {
            Field field = this.fields.get(index);
            if (!field.canResolve(name)) continue;
            fields.add((Object)index);
        }
        return fields.build();
    }

    public Predicate<QualifiedName> canResolvePredicate() {
        return new Predicate<QualifiedName>(){

            public boolean apply(QualifiedName input) {
                return TupleDescriptor.this.canResolve(input);
            }
        };
    }

    public String toString() {
        return this.fields.toString();
    }
}

