/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.analyzer;

import com.facebook.presto.spi.ColumnType;
import com.facebook.presto.tuple.TupleInfo;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import javax.annotation.Nullable;

public enum Type {
    BIGINT(TupleInfo.Type.FIXED_INT_64),
    DOUBLE(TupleInfo.Type.DOUBLE),
    VARCHAR(TupleInfo.Type.VARIABLE_BINARY),
    BOOLEAN(TupleInfo.Type.BOOLEAN),
    NULL(null);

    private final TupleInfo.Type rawType;

    private Type(TupleInfo.Type rawType) {
        this.rawType = rawType;
    }

    @Nullable
    public TupleInfo.Type getRawType() {
        return this.rawType;
    }

    public ColumnType getColumnType() {
        Preconditions.checkState((this.rawType != null ? 1 : 0) != 0, (Object)"no column type for null");
        return this.rawType.toColumnType();
    }

    public String getName() {
        return this.rawType == null ? "null" : this.rawType.getName();
    }

    public String toString() {
        return this.getName();
    }

    public static Type fromRaw(ColumnType type) {
        return Type.fromRaw(TupleInfo.Type.fromColumnType(type));
    }

    public static Type fromRaw(TupleInfo.Type raw) {
        for (Type type : Type.values()) {
            if (type.getRawType() != raw) continue;
            return type;
        }
        throw new IllegalArgumentException("Can't map raw type to Type: " + raw);
    }

    public static Function<Type, TupleInfo.Type> toRaw() {
        return new Function<Type, TupleInfo.Type>(){

            public TupleInfo.Type apply(Type input) {
                return input.getRawType();
            }
        };
    }

    public static boolean isNumeric(Type type) {
        return type == BIGINT || type == DOUBLE;
    }

    public static Function<Type, String> nameGetter() {
        return new Function<Type, String>(){

            public String apply(Type type) {
                return type.getName();
            }
        };
    }
}

