/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.gen;

import com.facebook.presto.block.BlockBuilder;
import com.facebook.presto.block.BlockCursor;
import com.facebook.presto.byteCode.Access;
import com.facebook.presto.byteCode.Block;
import com.facebook.presto.byteCode.ClassDefinition;
import com.facebook.presto.byteCode.ClassInfoLoader;
import com.facebook.presto.byteCode.CompilerContext;
import com.facebook.presto.byteCode.DynamicClassLoader;
import com.facebook.presto.byteCode.FieldDefinition;
import com.facebook.presto.byteCode.LocalVariableDefinition;
import com.facebook.presto.byteCode.MethodDefinition;
import com.facebook.presto.byteCode.NamedParameterDefinition;
import com.facebook.presto.byteCode.OpCodes;
import com.facebook.presto.byteCode.ParameterizedType;
import com.facebook.presto.byteCode.SmartClassWriter;
import com.facebook.presto.byteCode.control.ForLoop;
import com.facebook.presto.byteCode.control.IfStatement;
import com.facebook.presto.byteCode.instruction.LabelNode;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.operator.AbstractFilterAndProjectOperator;
import com.facebook.presto.operator.AbstractScanFilterAndProjectOperator;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.operator.Page;
import com.facebook.presto.operator.PageBuilder;
import com.facebook.presto.operator.SourceOperator;
import com.facebook.presto.operator.SourceOperatorFactory;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.RecordCursor;
import com.facebook.presto.split.DataStreamProvider;
import com.facebook.presto.sql.analyzer.Session;
import com.facebook.presto.sql.analyzer.Type;
import com.facebook.presto.sql.gen.BootstrapFunctionBinder;
import com.facebook.presto.sql.gen.ByteCodeExpressionVisitor;
import com.facebook.presto.sql.gen.Operations;
import com.facebook.presto.sql.gen.TypedByteCodeNode;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Input;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.tuple.TupleInfo;
import com.facebook.presto.tuple.TupleReadable;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Ordering;
import com.google.common.io.Files;
import io.airlift.log.Logger;
import io.airlift.slice.Slice;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Inject;
import org.objectweb.asm.ClassVisitor;
import org.weakref.jmx.Managed;

public class ExpressionCompiler {
    private static final Logger log = Logger.get(ExpressionCompiler.class);
    private static final AtomicLong CLASS_ID = new AtomicLong();
    private static final boolean DUMP_BYTE_CODE_TREE = false;
    private static final boolean DUMP_BYTE_CODE_RAW = false;
    private static final boolean RUN_ASM_VERIFIER = false;
    private static final AtomicReference<String> DUMP_CLASS_FILES_TO = new AtomicReference();
    private final Method bootstrapMethod;
    private final BootstrapFunctionBinder bootstrapFunctionBinder;
    private final LoadingCache<OperatorCacheKey, FilterAndProjectOperatorFactoryFactory> operatorFactories = CacheBuilder.newBuilder().maximumSize(1000L).build((CacheLoader)new CacheLoader<OperatorCacheKey, FilterAndProjectOperatorFactoryFactory>(){

        public FilterAndProjectOperatorFactoryFactory load(OperatorCacheKey key) throws Exception {
            return ExpressionCompiler.this.internalCompileFilterAndProjectOperator(key.getFilter(), key.getProjections(), key.getInputTypes(), key.getOutputTypes());
        }
    });
    private final LoadingCache<OperatorCacheKey, ScanFilterAndProjectOperatorFactoryFactory> sourceOperatorFactories = CacheBuilder.newBuilder().maximumSize(1000L).build((CacheLoader)new CacheLoader<OperatorCacheKey, ScanFilterAndProjectOperatorFactoryFactory>(){

        public ScanFilterAndProjectOperatorFactoryFactory load(OperatorCacheKey key) throws Exception {
            return ExpressionCompiler.this.internalCompileScanFilterAndProjectOperator(key.getSourceId(), key.getFilter(), key.getProjections(), key.getInputTypes(), key.getOutputTypes());
        }
    });
    private final AtomicLong generatedClasses = new AtomicLong();

    @Inject
    public ExpressionCompiler(Metadata metadata) {
        this.bootstrapFunctionBinder = new BootstrapFunctionBinder((Metadata)Preconditions.checkNotNull((Object)metadata, (Object)"metadata is null"));
        try {
            ClassDefinition classDefinition = new ClassDefinition(new CompilerContext(null), Access.a(Access.PUBLIC, Access.FINAL), ParameterizedType.typeFromPathName("Bootstrap" + CLASS_ID.incrementAndGet()), ParameterizedType.type(Object.class), new ParameterizedType[0]);
            FieldDefinition bootstrapField = classDefinition.declareField(Access.a(Access.PUBLIC, Access.STATIC, Access.FINAL), "BOOTSTRAP", ParameterizedType.type(AtomicReference.class, BootstrapFunctionBinder.class));
            classDefinition.getClassInitializer().getBody().newObject(AtomicReference.class).dup().invokeConstructor(AtomicReference.class, new Class[0]).putStaticField(bootstrapField);
            classDefinition.declareMethod(new CompilerContext(null), Access.a(Access.PUBLIC, Access.STATIC), "bootstrap", ParameterizedType.type(CallSite.class), NamedParameterDefinition.arg("lookup", MethodHandles.Lookup.class), NamedParameterDefinition.arg("name", String.class), NamedParameterDefinition.arg("type", MethodType.class), NamedParameterDefinition.arg("bindingId", Long.TYPE)).getBody().comment("return BOOTSTRAP.get().bootstrap(name, type, bindingId);").getStaticField(bootstrapField).invokeVirtual(AtomicReference.class, "get", Object.class, new Class[0]).checkCast(BootstrapFunctionBinder.class).getVariable("name").getVariable("type").getVariable("bindingId").invokeVirtual(BootstrapFunctionBinder.class, "bootstrap", CallSite.class, String.class, MethodType.class, Long.TYPE).retObject();
            Class<Object> bootstrapClass = this.defineClass(classDefinition, Object.class, new DynamicClassLoader());
            AtomicReference bootstrapReference = (AtomicReference)bootstrapClass.getField("BOOTSTRAP").get(null);
            bootstrapReference.set(this.bootstrapFunctionBinder);
            this.bootstrapMethod = bootstrapClass.getMethod("bootstrap", MethodHandles.Lookup.class, String.class, MethodType.class, Long.TYPE);
        }
        catch (ReflectiveOperationException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Managed
    public long getGeneratedClasses() {
        return this.generatedClasses.get();
    }

    @Managed
    public long getCachedFilterAndProjectOperators() {
        return this.operatorFactories.size();
    }

    @Managed
    public long getCachedScanFilterAndProjectOperators() {
        return this.sourceOperatorFactories.size();
    }

    public OperatorFactory compileFilterAndProjectOperator(int operatorId, Expression filter, List<Expression> projections, Map<Input, Type> inputTypes, List<Type> outputTypes) {
        return ((FilterAndProjectOperatorFactoryFactory)this.operatorFactories.getUnchecked((Object)new OperatorCacheKey(filter, projections, inputTypes, outputTypes, null))).create(operatorId);
    }

    private DynamicClassLoader createClassLoader() {
        return new DynamicClassLoader(this.bootstrapMethod.getDeclaringClass().getClassLoader());
    }

    @VisibleForTesting
    public FilterAndProjectOperatorFactoryFactory internalCompileFilterAndProjectOperator(Expression filter, List<Expression> projections, Map<Input, Type> inputTypes, List<Type> outputTypes) {
        Constructor constructor;
        DynamicClassLoader classLoader = this.createClassLoader();
        TypedOperatorClass typedOperatorClass = this.compileFilterAndProjectOperator(filter, projections, inputTypes, outputTypes, classLoader);
        try {
            constructor = typedOperatorClass.getOperatorClass().getConstructor(OperatorContext.class, Iterable.class);
        }
        catch (NoSuchMethodException e) {
            throw Throwables.propagate((Throwable)e);
        }
        FilterAndProjectOperatorFactoryFactory operatorFactoryFactory = new FilterAndProjectOperatorFactoryFactory(constructor, typedOperatorClass.getTupleInfos());
        return operatorFactoryFactory;
    }

    private TypedOperatorClass compileFilterAndProjectOperator(Expression filter, List<Expression> projections, Map<Input, Type> inputTypes, List<Type> outputTypes, DynamicClassLoader classLoader) {
        ClassDefinition classDefinition = new ClassDefinition(new CompilerContext(this.bootstrapMethod), Access.a(Access.PUBLIC, Access.FINAL), ParameterizedType.typeFromPathName("FilterAndProjectOperator_" + CLASS_ID.incrementAndGet()), ParameterizedType.type(AbstractFilterAndProjectOperator.class), new ParameterizedType[0]);
        FieldDefinition sessionField = classDefinition.declareField(Access.a(Access.PRIVATE, Access.FINAL), "session", Session.class);
        classDefinition.declareConstructor(new CompilerContext(this.bootstrapMethod), Access.a(Access.PUBLIC), NamedParameterDefinition.arg("operatorContext", OperatorContext.class), NamedParameterDefinition.arg("tupleInfos", ParameterizedType.type(Iterable.class, TupleInfo.class))).getBody().comment("super(operatorContext, tupleInfos);").pushThis().getVariable("operatorContext").getVariable("tupleInfos").invokeConstructor(AbstractFilterAndProjectOperator.class, OperatorContext.class, Iterable.class).comment("this.session = operatorContext.getSession();").pushThis().getVariable("operatorContext").invokeVirtual(OperatorContext.class, "getSession", Session.class, new Class[0]).putField(sessionField).ret();
        this.generateFilterAndProjectRowOriented(classDefinition, projections, inputTypes);
        this.generateFilterMethod(classDefinition, filter, inputTypes, true);
        this.generateFilterMethod(classDefinition, filter, inputTypes, false);
        ArrayList<TupleInfo> tupleInfos = new ArrayList<TupleInfo>();
        int projectionIndex = 0;
        for (int i = 0; i < projections.size(); ++i) {
            Type outputType = outputTypes.get(i);
            Preconditions.checkArgument((outputType != Type.NULL ? 1 : 0) != 0, (Object)"NULL output type is not supported");
            tupleInfos.add(new TupleInfo(outputType.getRawType()));
            Expression projection = projections.get(i);
            Class<?> type = this.generateProjectMethod(classDefinition, "project_" + projectionIndex, projection, inputTypes, true);
            this.generateProjectMethod(classDefinition, "project_" + projectionIndex, projection, inputTypes, false);
            if (type == Boolean.TYPE) {
                Preconditions.checkState((outputType == Type.BOOLEAN ? 1 : 0) != 0);
            } else if (type == Long.TYPE) {
                Preconditions.checkState((outputType == Type.BIGINT ? 1 : 0) != 0);
            } else if (type == Double.TYPE) {
                Preconditions.checkState((outputType == Type.DOUBLE ? 1 : 0) != 0);
            } else if (type == Slice.class) {
                Preconditions.checkState((outputType == Type.VARCHAR ? 1 : 0) != 0);
            } else if (type != Void.TYPE) {
                throw new IllegalStateException("Type " + type.getName() + "can be output");
            }
            ++projectionIndex;
        }
        classDefinition.declareMethod(new CompilerContext(this.bootstrapMethod), Access.a(Access.PUBLIC), "toString", ParameterizedType.type(String.class), new NamedParameterDefinition[0]).getBody().push(Objects.toStringHelper((String)classDefinition.getType().getJavaClassName()).add("filter", (Object)filter).add("projections", projections).toString()).retObject();
        Class<Operator> filterAndProjectClass = this.defineClass(classDefinition, Operator.class, classLoader);
        return new TypedOperatorClass(filterAndProjectClass, tupleInfos);
    }

    public SourceOperatorFactory compileScanFilterAndProjectOperator(int operatorId, PlanNodeId sourceId, DataStreamProvider dataStreamProvider, List<ColumnHandle> columns, Expression filter, List<Expression> projections, Map<Input, Type> inputTypes, List<Type> outputTypes) {
        return ((ScanFilterAndProjectOperatorFactoryFactory)this.sourceOperatorFactories.getUnchecked((Object)new OperatorCacheKey(filter, projections, inputTypes, outputTypes, sourceId))).create(operatorId, dataStreamProvider, columns);
    }

    @VisibleForTesting
    public ScanFilterAndProjectOperatorFactoryFactory internalCompileScanFilterAndProjectOperator(PlanNodeId sourceId, Expression filter, List<Expression> projections, Map<Input, Type> inputTypes, List<Type> outputTypes) {
        Constructor<SourceOperator> constructor;
        DynamicClassLoader classLoader = this.createClassLoader();
        TypedOperatorClass typedOperatorClass = this.compileScanFilterAndProjectOperator(filter, projections, inputTypes, outputTypes, classLoader);
        try {
            constructor = typedOperatorClass.getOperatorClass().asSubclass(SourceOperator.class).getConstructor(OperatorContext.class, PlanNodeId.class, DataStreamProvider.class, Iterable.class, Iterable.class);
        }
        catch (NoSuchMethodException e) {
            throw Throwables.propagate((Throwable)e);
        }
        ScanFilterAndProjectOperatorFactoryFactory operatorFactoryFactory = new ScanFilterAndProjectOperatorFactoryFactory(constructor, sourceId, typedOperatorClass.getTupleInfos());
        return operatorFactoryFactory;
    }

    private TypedOperatorClass compileScanFilterAndProjectOperator(Expression filter, List<Expression> projections, Map<Input, Type> inputTypes, List<Type> outputTypes, DynamicClassLoader classLoader) {
        ClassDefinition classDefinition = new ClassDefinition(new CompilerContext(this.bootstrapMethod), Access.a(Access.PUBLIC, Access.FINAL), ParameterizedType.typeFromPathName("ScanFilterAndProjectOperator_" + CLASS_ID.incrementAndGet()), ParameterizedType.type(AbstractScanFilterAndProjectOperator.class), new ParameterizedType[0]);
        FieldDefinition sessionField = classDefinition.declareField(Access.a(Access.PRIVATE, Access.FINAL), "session", Session.class);
        classDefinition.declareConstructor(new CompilerContext(this.bootstrapMethod), Access.a(Access.PUBLIC), NamedParameterDefinition.arg("operatorContext", OperatorContext.class), NamedParameterDefinition.arg("sourceId", PlanNodeId.class), NamedParameterDefinition.arg("dataStreamProvider", DataStreamProvider.class), NamedParameterDefinition.arg("columns", ParameterizedType.type(Iterable.class, ColumnHandle.class)), NamedParameterDefinition.arg("tupleInfos", ParameterizedType.type(Iterable.class, TupleInfo.class))).getBody().comment("super(operatorContext, sourceId, dataStreamProvider, columns, tupleInfos);").pushThis().getVariable("operatorContext").getVariable("sourceId").getVariable("dataStreamProvider").getVariable("columns").getVariable("tupleInfos").invokeConstructor(AbstractScanFilterAndProjectOperator.class, OperatorContext.class, PlanNodeId.class, DataStreamProvider.class, Iterable.class, Iterable.class).comment("this.session = operatorContext.getSession();").pushThis().getVariable("operatorContext").invokeVirtual(OperatorContext.class, "getSession", Session.class, new Class[0]).putField(sessionField).ret();
        this.generateFilterAndProjectRowOriented(classDefinition, projections, inputTypes);
        this.generateFilterAndProjectCursorMethod(classDefinition, projections);
        this.generateFilterMethod(classDefinition, filter, inputTypes, true);
        this.generateFilterMethod(classDefinition, filter, inputTypes, false);
        ArrayList<TupleInfo> tupleInfos = new ArrayList<TupleInfo>();
        int projectionIndex = 0;
        for (int i = 0; i < projections.size(); ++i) {
            Type outputType = outputTypes.get(i);
            Preconditions.checkArgument((outputType != Type.NULL ? 1 : 0) != 0, (Object)"NULL output type is not supported");
            tupleInfos.add(new TupleInfo(outputType.getRawType()));
            Expression projection = projections.get(i);
            Class<?> type = this.generateProjectMethod(classDefinition, "project_" + projectionIndex, projection, inputTypes, true);
            this.generateProjectMethod(classDefinition, "project_" + projectionIndex, projection, inputTypes, false);
            if (type == Boolean.TYPE) {
                Preconditions.checkState((outputType == Type.BOOLEAN ? 1 : 0) != 0);
            } else if (type == Long.TYPE) {
                Preconditions.checkState((outputType == Type.BIGINT ? 1 : 0) != 0);
            } else if (type == Double.TYPE) {
                Preconditions.checkState((outputType == Type.DOUBLE ? 1 : 0) != 0);
            } else if (type == Slice.class) {
                Preconditions.checkState((outputType == Type.VARCHAR ? 1 : 0) != 0);
            } else if (type != Void.TYPE) {
                throw new IllegalStateException("Type " + type.getName() + "can be output");
            }
            ++projectionIndex;
        }
        classDefinition.declareMethod(new CompilerContext(this.bootstrapMethod), Access.a(Access.PUBLIC), "toString", ParameterizedType.type(String.class), new NamedParameterDefinition[0]).getBody().push(Objects.toStringHelper((String)classDefinition.getType().getJavaClassName()).add("filter", (Object)filter).add("projections", projections).toString()).retObject();
        Class<SourceOperator> filterAndProjectClass = this.defineClass(classDefinition, SourceOperator.class, classLoader);
        return new TypedOperatorClass(filterAndProjectClass, tupleInfos);
    }

    private void generateFilterAndProjectRowOriented(ClassDefinition classDefinition, List<Expression> projections, Map<Input, Type> inputTypes) {
        MethodDefinition filterAndProjectMethod = classDefinition.declareMethod(new CompilerContext(this.bootstrapMethod), Access.a(Access.PUBLIC), "filterAndProjectRowOriented", ParameterizedType.type(Void.TYPE), NamedParameterDefinition.arg("page", Page.class), NamedParameterDefinition.arg("pageBuilder", PageBuilder.class));
        CompilerContext compilerContext = filterAndProjectMethod.getCompilerContext();
        LocalVariableDefinition positionVariable = compilerContext.declareVariable(Integer.TYPE, "position");
        LocalVariableDefinition rowsVariable = compilerContext.declareVariable(Integer.TYPE, "rows");
        filterAndProjectMethod.getBody().comment("int rows = page.getPositionCount();").getVariable("page").invokeVirtual(Page.class, "getPositionCount", Integer.TYPE, new Class[0]).putVariable(rowsVariable);
        ArrayList<LocalVariableDefinition> cursorVariables = new ArrayList<LocalVariableDefinition>();
        int channels = inputTypes.isEmpty() ? 0 : (Integer)Ordering.natural().max(Iterables.transform(inputTypes.keySet(), (Function)Input.channelGetter())) + 1;
        for (int i = 0; i < channels; ++i) {
            LocalVariableDefinition cursorVariable = compilerContext.declareVariable(BlockCursor.class, "cursor_" + i);
            cursorVariables.add(cursorVariable);
            filterAndProjectMethod.getBody().comment("BlockCursor %s = page.getBlock(%s).cursor();", cursorVariable.getName(), i).getVariable("page").push(i).invokeVirtual(Page.class, "getBlock", com.facebook.presto.block.Block.class, Integer.TYPE).invokeInterface(com.facebook.presto.block.Block.class, "cursor", BlockCursor.class, new Class[0]).putVariable(cursorVariable);
        }
        ForLoop.ForLoopBuilder forLoop = ForLoop.forLoopBuilder(compilerContext).comment("for (position = 0; position < rows; position++)", new Object[0]).initialize(new Block(compilerContext).putVariable(positionVariable, 0)).condition(new Block(compilerContext).getVariable(positionVariable).getVariable(rowsVariable).invokeStatic(Operations.class, "lessThan", Boolean.TYPE, Integer.TYPE, Integer.TYPE)).update(new Block(compilerContext).incrementVariable(positionVariable, (byte)1));
        Block forLoopBody = new Block(compilerContext);
        for (LocalVariableDefinition cursorVariable : cursorVariables) {
            forLoopBody.comment("checkState(%s.advanceNextPosition());", cursorVariable.getName()).getVariable(cursorVariable).invokeInterface(BlockCursor.class, "advanceNextPosition", Boolean.TYPE, new Class[0]).invokeStatic(Preconditions.class, "checkState", Void.TYPE, Boolean.TYPE);
        }
        IfStatement.IfStatementBuilder ifStatement = new IfStatement.IfStatementBuilder(compilerContext).comment("if (filter(cursors...)", new Object[0]);
        Block condition = new Block(compilerContext);
        condition.pushThis();
        for (int channel = 0; channel < channels; ++channel) {
            condition.getVariable("cursor_" + channel);
        }
        condition.invokeVirtual(classDefinition.getType(), "filter", ParameterizedType.type(Boolean.TYPE), Collections.nCopies(channels, ParameterizedType.type(TupleReadable.class)));
        ifStatement.condition(condition);
        Block trueBlock = new Block(compilerContext);
        if (projections.isEmpty()) {
            trueBlock.comment("pageBuilder.declarePosition()").getVariable("pageBuilder").invokeVirtual(PageBuilder.class, "declarePosition", Void.TYPE, new Class[0]);
        } else {
            for (int projectionIndex = 0; projectionIndex < projections.size(); ++projectionIndex) {
                trueBlock.comment("project_%s(cursors..., pageBuilder.getBlockBuilder(%s))", projectionIndex, projectionIndex);
                trueBlock.pushThis();
                for (int channel = 0; channel < channels; ++channel) {
                    trueBlock.getVariable("cursor_" + channel);
                }
                trueBlock.getVariable("pageBuilder").push(projectionIndex).invokeVirtual(PageBuilder.class, "getBlockBuilder", BlockBuilder.class, Integer.TYPE);
                trueBlock.invokeVirtual(classDefinition.getType(), "project_" + projectionIndex, ParameterizedType.type(Void.TYPE), (Iterable<ParameterizedType>)ImmutableList.builder().addAll(Collections.nCopies(channels, ParameterizedType.type(TupleReadable.class))).add((Object)ParameterizedType.type(BlockBuilder.class)).build());
            }
        }
        ifStatement.ifTrue(trueBlock);
        forLoopBody.append(ifStatement.build());
        filterAndProjectMethod.getBody().append(forLoop.body(forLoopBody).build());
        for (LocalVariableDefinition cursorVariable : cursorVariables) {
            filterAndProjectMethod.getBody().comment("checkState(not(%s.advanceNextPosition))", cursorVariable.getName()).getVariable(cursorVariable).invokeInterface(BlockCursor.class, "advanceNextPosition", Boolean.TYPE, new Class[0]).invokeStatic(Operations.class, "not", Boolean.TYPE, Boolean.TYPE).invokeStatic(Preconditions.class, "checkState", Void.TYPE, Boolean.TYPE);
        }
        filterAndProjectMethod.getBody().ret();
    }

    private void generateFilterAndProjectCursorMethod(ClassDefinition classDefinition, List<Expression> projections) {
        MethodDefinition filterAndProjectMethod = classDefinition.declareMethod(new CompilerContext(this.bootstrapMethod), Access.a(Access.PUBLIC), "filterAndProjectRowOriented", ParameterizedType.type(Integer.TYPE), NamedParameterDefinition.arg("cursor", RecordCursor.class), NamedParameterDefinition.arg("pageBuilder", PageBuilder.class));
        CompilerContext compilerContext = filterAndProjectMethod.getCompilerContext();
        LocalVariableDefinition completedPositionsVariable = compilerContext.declareVariable(Integer.TYPE, "completedPositions");
        filterAndProjectMethod.getBody().comment("int completedPositions = 0;").putVariable(completedPositionsVariable, 0);
        LabelNode done = new LabelNode("done");
        ForLoop.ForLoopBuilder forLoop = ForLoop.forLoopBuilder(compilerContext).initialize(OpCodes.NOP).condition(new Block(compilerContext).comment("completedPositions < 16384").getVariable(completedPositionsVariable).push(16384).invokeStatic(Operations.class, "lessThan", Boolean.TYPE, Integer.TYPE, Integer.TYPE)).update(new Block(compilerContext).comment("completedPositions++").incrementVariable(completedPositionsVariable, (byte)1));
        Block forLoopBody = new Block(compilerContext);
        forLoop.body(forLoopBody);
        forLoopBody.comment("if (pageBuilder.isFull()) break;").append(new Block(compilerContext).getVariable("pageBuilder").invokeVirtual(PageBuilder.class, "isFull", Boolean.TYPE, new Class[0]).ifTrueGoto(done));
        forLoopBody.comment("if (!cursor.advanceNextPosition()) break;").append(new Block(compilerContext).getVariable("cursor").invokeInterface(RecordCursor.class, "advanceNextPosition", Boolean.TYPE, new Class[0]).ifFalseGoto(done));
        IfStatement.IfStatementBuilder ifStatement = new IfStatement.IfStatementBuilder(compilerContext);
        ifStatement.condition(new Block(compilerContext).pushThis().getVariable("cursor").invokeVirtual(classDefinition.getType(), "filter", ParameterizedType.type(Boolean.TYPE), ParameterizedType.type(RecordCursor.class)));
        Block trueBlock = new Block(compilerContext);
        ifStatement.ifTrue(trueBlock);
        if (projections.isEmpty()) {
            trueBlock.getVariable("pageBuilder").invokeVirtual(PageBuilder.class, "declarePosition", Void.TYPE, new Class[0]);
        } else {
            for (int projectionIndex = 0; projectionIndex < projections.size(); ++projectionIndex) {
                trueBlock.pushThis();
                trueBlock.getVariable("cursor");
                trueBlock.getVariable("pageBuilder").push(projectionIndex).invokeVirtual(PageBuilder.class, "getBlockBuilder", BlockBuilder.class, Integer.TYPE);
                trueBlock.invokeVirtual(classDefinition.getType(), "project_" + projectionIndex, ParameterizedType.type(Void.TYPE), ParameterizedType.type(RecordCursor.class), ParameterizedType.type(BlockBuilder.class));
            }
        }
        forLoopBody.append(ifStatement.build());
        filterAndProjectMethod.getBody().append(forLoop.build()).visitLabel(done).comment("return completedPositions;").getVariable("completedPositions").retInt();
    }

    private void generateFilterMethod(ClassDefinition classDefinition, Expression filter, Map<Input, Type> inputTypes, boolean sourceIsCursor) {
        MethodDefinition filterMethod = sourceIsCursor ? classDefinition.declareMethod(new CompilerContext(this.bootstrapMethod), Access.a(Access.PUBLIC), "filter", ParameterizedType.type(Boolean.TYPE), NamedParameterDefinition.arg("cursor", RecordCursor.class)) : classDefinition.declareMethod(new CompilerContext(this.bootstrapMethod), Access.a(Access.PUBLIC), "filter", ParameterizedType.type(Boolean.TYPE), this.toTupleReaderParameters(inputTypes));
        filterMethod.comment("Filter: %s", filter.toString());
        filterMethod.getCompilerContext().declareVariable(ParameterizedType.type(Boolean.TYPE), "wasNull");
        Block getSessionByteCode = new Block(filterMethod.getCompilerContext()).pushThis().getField(classDefinition.getType(), "session", ParameterizedType.type(Session.class));
        TypedByteCodeNode body = (TypedByteCodeNode)new ByteCodeExpressionVisitor(this.bootstrapFunctionBinder, inputTypes, getSessionByteCode, sourceIsCursor).process((Node)filter, filterMethod.getCompilerContext());
        if (body.getType() == Void.TYPE) {
            filterMethod.getBody().push(false).retBoolean();
        } else {
            LabelNode end = new LabelNode("end");
            filterMethod.getBody().comment("boolean wasNull = false;").putVariable("wasNull", false).append(body.getNode()).getVariable("wasNull").ifFalseGoto(end).pop(Boolean.TYPE).push(false).visitLabel(end).retBoolean();
        }
    }

    private Class<?> generateProjectMethod(ClassDefinition classDefinition, String methodName, Expression projection, Map<Input, Type> inputTypes, boolean sourceIsCursor) {
        MethodDefinition projectionMethod;
        if (sourceIsCursor) {
            projectionMethod = classDefinition.declareMethod(new CompilerContext(this.bootstrapMethod), Access.a(Access.PUBLIC), methodName, ParameterizedType.type(Void.TYPE), NamedParameterDefinition.arg("cursor", RecordCursor.class), NamedParameterDefinition.arg("output", BlockBuilder.class));
        } else {
            ImmutableList.Builder parameters = ImmutableList.builder();
            parameters.addAll(this.toTupleReaderParameters(inputTypes));
            parameters.add((Object)NamedParameterDefinition.arg("output", BlockBuilder.class));
            projectionMethod = classDefinition.declareMethod(new CompilerContext(this.bootstrapMethod), Access.a(Access.PUBLIC), methodName, ParameterizedType.type(Void.TYPE), (Iterable<NamedParameterDefinition>)parameters.build());
        }
        projectionMethod.comment("Projection: %s", projection.toString());
        CompilerContext context = projectionMethod.getCompilerContext();
        context.declareVariable(ParameterizedType.type(Boolean.TYPE), "wasNull");
        Block getSessionByteCode = new Block(context).pushThis().getField(classDefinition.getType(), "session", ParameterizedType.type(Session.class));
        TypedByteCodeNode body = (TypedByteCodeNode)new ByteCodeExpressionVisitor(this.bootstrapFunctionBinder, inputTypes, getSessionByteCode, sourceIsCursor).process((Node)projection, context);
        if (body.getType() != Void.TYPE) {
            projectionMethod.getBody().comment("boolean wasNull = false;").putVariable("wasNull", false).getVariable("output").append(body.getNode());
            Block notNullBlock = new Block(context);
            if (body.getType() == Boolean.TYPE) {
                notNullBlock.comment("output.append(<booleanStackValue>);").invokeVirtual(BlockBuilder.class, "append", BlockBuilder.class, Boolean.TYPE).pop();
            } else if (body.getType() == Long.TYPE) {
                notNullBlock.comment("output.append(<longStackValue>);").invokeVirtual(BlockBuilder.class, "append", BlockBuilder.class, Long.TYPE).pop();
            } else if (body.getType() == Double.TYPE) {
                notNullBlock.comment("output.append(<doubleStackValue>);").invokeVirtual(BlockBuilder.class, "append", BlockBuilder.class, Double.TYPE).pop();
            } else if (body.getType() == Slice.class) {
                notNullBlock.comment("output.append(<sliceStackValue>);").invokeVirtual(BlockBuilder.class, "append", BlockBuilder.class, Slice.class).pop();
            } else {
                throw new UnsupportedOperationException("Type " + body.getType() + " can not be output yet");
            }
            Block nullBlock = new Block(context).comment("output.appendNull();").pop(body.getType()).invokeVirtual(BlockBuilder.class, "appendNull", BlockBuilder.class, new Class[0]).pop();
            projectionMethod.getBody().comment("if the result was null, appendNull; otherwise append the value").append(new IfStatement(context, new Block(context).getVariable("wasNull"), nullBlock, notNullBlock)).ret();
        } else {
            projectionMethod.getBody().comment("output.appendNull();").getVariable("output").invokeVirtual(BlockBuilder.class, "appendNull", BlockBuilder.class, new Class[0]).pop().ret();
        }
        return body.getType();
    }

    private List<NamedParameterDefinition> toTupleReaderParameters(Map<Input, Type> inputTypes) {
        ImmutableList.Builder parameters = ImmutableList.builder();
        int channels = inputTypes.isEmpty() ? 0 : (Integer)Ordering.natural().max(Iterables.transform(inputTypes.keySet(), (Function)Input.channelGetter())) + 1;
        for (int i = 0; i < channels; ++i) {
            parameters.add((Object)NamedParameterDefinition.arg("channel_" + i, TupleReadable.class));
        }
        return parameters.build();
    }

    private <T> Class<? extends T> defineClass(ClassDefinition classDefinition, Class<T> superType, DynamicClassLoader classLoader) {
        Class<?> clazz = this.defineClasses((List<ClassDefinition>)ImmutableList.of((Object)classDefinition), classLoader).values().iterator().next();
        return clazz.asSubclass(superType);
    }

    private Map<String, Class<?>> defineClasses(List<ClassDefinition> classDefinitions, DynamicClassLoader classLoader) {
        ClassInfoLoader classInfoLoader = ClassInfoLoader.createClassInfoLoader(classDefinitions, classLoader);
        LinkedHashMap<String, byte[]> byteCodes = new LinkedHashMap<String, byte[]>();
        for (ClassDefinition classDefinition : classDefinitions) {
            SmartClassWriter cw = new SmartClassWriter(classInfoLoader);
            classDefinition.visit((ClassVisitor)cw);
            byte[] byteCode = cw.toByteArray();
            byteCodes.put(classDefinition.getType().getJavaClassName(), byteCode);
        }
        String dumpClassPath = DUMP_CLASS_FILES_TO.get();
        if (dumpClassPath != null) {
            for (Map.Entry entry : byteCodes.entrySet()) {
                File file = new File(dumpClassPath, ParameterizedType.typeFromJavaClassName((String)entry.getKey()).getClassName() + ".class");
                try {
                    log.debug("ClassFile: " + file.getAbsolutePath());
                    Files.createParentDirs((File)file);
                    Files.write((byte[])((byte[])entry.getValue()), (File)file);
                }
                catch (IOException e) {
                    log.error((Throwable)e, "Failed to write generated class file to: %s" + file.getAbsolutePath());
                }
            }
        }
        Map<String, Class<?>> classes = classLoader.defineClasses(byteCodes);
        this.generatedClasses.addAndGet(classes.size());
        return classes;
    }

    private static class ScanFilterAndProjectOperatorFactory
    implements SourceOperatorFactory {
        private final Constructor<? extends SourceOperator> constructor;
        private final int operatorId;
        private final PlanNodeId sourceId;
        private final DataStreamProvider dataStreamProvider;
        private final List<ColumnHandle> columns;
        private final List<TupleInfo> tupleInfos;
        private boolean closed;

        public ScanFilterAndProjectOperatorFactory(Constructor<? extends SourceOperator> constructor, int operatorId, PlanNodeId sourceId, DataStreamProvider dataStreamProvider, List<ColumnHandle> columns, List<TupleInfo> tupleInfos) {
            this.constructor = (Constructor)Preconditions.checkNotNull(constructor, (Object)"constructor is null");
            this.operatorId = operatorId;
            this.sourceId = (PlanNodeId)Preconditions.checkNotNull((Object)sourceId, (Object)"sourceId is null");
            this.dataStreamProvider = (DataStreamProvider)Preconditions.checkNotNull((Object)dataStreamProvider, (Object)"dataStreamProvider is null");
            this.columns = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(columns, (Object)"columns is null")));
            this.tupleInfos = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(tupleInfos, (Object)"tupleInfos is null")));
        }

        @Override
        public PlanNodeId getSourceId() {
            return this.sourceId;
        }

        @Override
        public List<TupleInfo> getTupleInfos() {
            return this.tupleInfos;
        }

        @Override
        public SourceOperator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, this.constructor.getDeclaringClass().getSimpleName());
            try {
                return this.constructor.newInstance(operatorContext, this.sourceId, this.dataStreamProvider, this.columns, this.tupleInfos);
            }
            catch (InvocationTargetException e) {
                throw Throwables.propagate((Throwable)e.getCause());
            }
            catch (ReflectiveOperationException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }

        @Override
        public void close() {
            this.closed = true;
        }
    }

    private static class ScanFilterAndProjectOperatorFactoryFactory {
        private final Constructor<? extends SourceOperator> constructor;
        private final PlanNodeId sourceId;
        private final List<TupleInfo> tupleInfos;

        public ScanFilterAndProjectOperatorFactoryFactory(Constructor<? extends SourceOperator> constructor, PlanNodeId sourceId, List<TupleInfo> tupleInfos) {
            this.sourceId = (PlanNodeId)Preconditions.checkNotNull((Object)sourceId, (Object)"sourceId is null");
            this.constructor = (Constructor)Preconditions.checkNotNull(constructor, (Object)"constructor is null");
            this.tupleInfos = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(tupleInfos, (Object)"tupleInfos is null")));
        }

        public SourceOperatorFactory create(int operatorId, DataStreamProvider dataStreamProvider, List<ColumnHandle> columns) {
            return new ScanFilterAndProjectOperatorFactory(this.constructor, operatorId, this.sourceId, dataStreamProvider, columns, this.tupleInfos);
        }
    }

    private static class FilterAndProjectOperatorFactory
    implements OperatorFactory {
        private final Constructor<? extends Operator> constructor;
        private final int operatorId;
        private final List<TupleInfo> tupleInfos;
        private boolean closed;

        public FilterAndProjectOperatorFactory(Constructor<? extends Operator> constructor, int operatorId, List<TupleInfo> tupleInfos) {
            this.constructor = (Constructor)Preconditions.checkNotNull(constructor, (Object)"constructor is null");
            this.operatorId = operatorId;
            this.tupleInfos = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(tupleInfos, (Object)"tupleInfos is null")));
        }

        @Override
        public List<TupleInfo> getTupleInfos() {
            return this.tupleInfos;
        }

        @Override
        public Operator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, this.constructor.getDeclaringClass().getSimpleName());
            try {
                return this.constructor.newInstance(operatorContext, this.tupleInfos);
            }
            catch (InvocationTargetException e) {
                throw Throwables.propagate((Throwable)e.getCause());
            }
            catch (ReflectiveOperationException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }

        @Override
        public void close() {
            this.closed = true;
        }
    }

    private static class FilterAndProjectOperatorFactoryFactory {
        private final Constructor<? extends Operator> constructor;
        private final List<TupleInfo> tupleInfos;

        public FilterAndProjectOperatorFactoryFactory(Constructor<? extends Operator> constructor, List<TupleInfo> tupleInfos) {
            this.constructor = (Constructor)Preconditions.checkNotNull(constructor, (Object)"constructor is null");
            this.tupleInfos = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(tupleInfos, (Object)"tupleInfos is null")));
        }

        public OperatorFactory create(int operatorId) {
            return new FilterAndProjectOperatorFactory(this.constructor, operatorId, this.tupleInfos);
        }
    }

    private static final class OperatorCacheKey {
        private final Expression filter;
        private final List<Expression> projections;
        private final Map<Input, Type> inputTypes;
        private final List<Type> outputTypes;
        private final PlanNodeId sourceId;

        private OperatorCacheKey(Expression expression, List<Expression> projections, Map<Input, Type> inputTypes, List<Type> outputTypes, PlanNodeId sourceId) {
            this.filter = expression;
            this.projections = ImmutableList.copyOf(projections);
            this.inputTypes = ImmutableMap.copyOf(inputTypes);
            this.outputTypes = ImmutableList.copyOf(outputTypes);
            this.sourceId = sourceId;
        }

        private Expression getFilter() {
            return this.filter;
        }

        private List<Expression> getProjections() {
            return this.projections;
        }

        private Map<Input, Type> getInputTypes() {
            return this.inputTypes;
        }

        public List<Type> getOutputTypes() {
            return this.outputTypes;
        }

        private PlanNodeId getSourceId() {
            return this.sourceId;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.filter, this.projections, this.inputTypes, this.sourceId});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            OperatorCacheKey other = (OperatorCacheKey)obj;
            return Objects.equal((Object)this.filter, (Object)other.filter) && Objects.equal(this.projections, other.projections) && Objects.equal(this.inputTypes, other.inputTypes) && Objects.equal(this.outputTypes, other.outputTypes) && Objects.equal((Object)this.sourceId, (Object)other.sourceId);
        }

        public String toString() {
            return Objects.toStringHelper((Object)this).add("filter", (Object)this.filter).add("projections", this.projections).add("inputTypes", this.inputTypes).add("outputTypes", this.outputTypes).add("sourceId", (Object)this.sourceId).toString();
        }
    }

    private static class TypedOperatorClass {
        private final Class<? extends Operator> operatorClass;
        private final List<TupleInfo> tupleInfos;

        private TypedOperatorClass(Class<? extends Operator> operatorClass, List<TupleInfo> tupleInfos) {
            this.operatorClass = operatorClass;
            this.tupleInfos = tupleInfos;
        }

        private Class<? extends Operator> getOperatorClass() {
            return this.operatorClass;
        }

        private List<TupleInfo> getTupleInfos() {
            return this.tupleInfos;
        }
    }
}

