/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.gen;

import com.facebook.presto.byteCode.ByteCodeNode;
import com.facebook.presto.byteCode.ByteCodeVisitor;
import com.facebook.presto.byteCode.instruction.Constant;
import com.facebook.presto.byteCode.instruction.InstructionNode;
import com.facebook.presto.byteCode.instruction.InvokeInstruction;
import com.facebook.presto.sql.gen.SliceLiteralBootstrap;
import com.google.common.base.Charsets;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.lang.invoke.MethodType;
import java.nio.charset.Charset;
import org.objectweb.asm.MethodVisitor;

public class SliceConstant
extends Constant {
    private final Slice value;

    public static SliceConstant sliceConstant(String value) {
        return new SliceConstant(Slices.copiedBuffer((String)value, (Charset)Charsets.UTF_8));
    }

    public static SliceConstant sliceConstant(Slice value) {
        return new SliceConstant(value);
    }

    private SliceConstant(Slice value) {
        this.value = value;
    }

    public Slice getValue() {
        return this.value;
    }

    @Override
    public void accept(MethodVisitor visitor) {
        InstructionNode node = InvokeInstruction.invokeDynamic("load", MethodType.methodType(Slice.class), SliceLiteralBootstrap.SLICE_LITERAL_BOOTSTRAP, this.value.toString(Charsets.UTF_8));
        node.accept(visitor);
    }

    @Override
    public <T> T accept(ByteCodeNode parent, ByteCodeVisitor<T> visitor) {
        return visitor.visitConstant(parent, this);
    }

    @Override
    public String toString() {
        return "load constant '" + this.value.toString(Charsets.UTF_8) + "'";
    }
}

